/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.genericactions;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.genericactions.IacucProtocolGenericActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.correspondence.IacucProtocolActionsCorrespondence;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionServiceImplBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;

public class IacucProtocolGenericActionServiceImpl
extends ProtocolGenericActionServiceImplBase
implements IacucProtocolGenericActionService {
    @Override
    public void disapprove(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "301", "303");
        this.performDisapprove(protocol);
    }

    @Override
    public void expire(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "302", "308");
    }

    @Override
    public ProtocolDocumentBase returnForSMR(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "209", "104");
        return this.getReturnedVersionedDocument(protocol);
    }

    @Override
    public ProtocolDocumentBase returnForSRR(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "211", "107");
        return this.getReturnedVersionedDocument(protocol);
    }

    @Override
    public ProtocolDocumentBase returnToPI(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "210", "102");
        return this.getReturnedVersionedDocument(protocol);
    }

    @Override
    public void suspend(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "307", "304");
    }

    @Override
    public void terminate(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "306", "307");
    }

    @Override
    public void iacucAcknowledgement(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "206", protocol.getProtocolStatusCode());
    }

    @Override
    public void iacucHold(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "305", "201");
    }

    @Override
    public void iacucLiftHold(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        ProtocolActionBase selectedPa = null;
        for (ProtocolActionBase pa : protocol.getProtocolActions()) {
            System.err.println("pa.getProtocolActionTypeCode(): " + pa.getProtocolActionTypeCode());
            if (!StringUtils.equalsIgnoreCase((String)pa.getProtocolActionTypeCode(), (String)"305") || selectedPa != null && pa.getSequenceNumber() <= selectedPa.getSequenceNumber()) continue;
            selectedPa = pa;
        }
        this.performGenericAction(protocol, actionBean, "208", selectedPa.getPrevProtocolStatusCode());
    }

    @Override
    public void iacucDeactivate(ProtocolBase protocol, ProtocolGenericActionBean actionBean) throws Exception {
        this.performGenericAction(protocol, actionBean, "303", "305");
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase submission, String protocolActionType) {
        return new IacucProtocolAction((IacucProtocol)protocol, (IacucProtocolSubmission)submission, protocolActionType);
    }

    @Override
    protected ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondenceHook(String protocolActionType) {
        return new IacucProtocolActionsCorrespondence(protocolActionType);
    }

    @Override
    protected String getProtocolPendingInProgressStatusCodeHook() {
        return "100";
    }

    @Override
    protected String getProtocolSubmissionStatusRejectedInRoutingCodeHook() {
        return "401";
    }

    @Override
    protected ProtocolActionBase getNewDisapprovedInRoutingProtocolActionInstanceHook(ProtocolBase protocol) {
        return new IacucProtocolAction((IacucProtocol)protocol, null, "401");
    }

    @Override
    protected String getDisapprovedProtocolStatusCodeHook() {
        return "303";
    }

    @Override
    protected String getRecallProtocolActionTypeCodeHook() {
        return null;
    }
}

