/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.notifyiacuc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.notifyiacuc.IacucProtocolNotifyIacucBean;
import org.kuali.kra.iacuc.actions.notifyiacuc.IacucProtocolNotifyIacucService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolActionService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionBuilder;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class IacucProtocolNotifyIacucServiceImpl
implements IacucProtocolNotifyIacucService {
    protected static final Log LOG = LogFactory.getLog(IacucProtocolNotifyIacucServiceImpl.class);
    protected static final String MODULE_ITEM_CODE = "moduleItemCode";
    protected static final String MODULE_ITEM_KEY = "moduleItemKey";
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private IacucProtocolActionService protocolActionService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionService(IacucProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    public void submitIacucNotification(IacucProtocol protocol, IacucProtocolNotifyIacucBean notifyIacucBean) throws WorkflowException {
        IacucProtocolSubmission submission = this.createProtocolSubmission(protocol, notifyIacucBean);
        IacucProtocolAction protocolAction = new IacucProtocolAction(protocol, submission, "114");
        protocolAction.setComments(notifyIacucBean.getComment());
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        if (!CollectionUtils.isEmpty(notifyIacucBean.getAnswerHeaders())) {
            this.saveQuestionnaire(notifyIacucBean, submission.getSubmissionNumber());
            notifyIacucBean.setAnswerHeaders(new ArrayList<AnswerHeader>());
        }
        this.cleanUnreferencedQuestionnaire(protocol.getProtocolNumber());
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        protocol.refreshReferenceObject("protocolSubmissions");
    }

    private void saveQuestionnaire(IacucProtocolNotifyIacucBean notifyIacucBean, Integer submissionNumber) {
        ArrayList<AnswerHeader> saveHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : notifyIacucBean.getAnswerHeaders()) {
            if (answerHeader.getAnswerHeaderId() == null) continue;
            answerHeader.setModuleSubItemKey(submissionNumber.toString());
            answerHeader.setModuleItemKey(answerHeader.getModuleItemKey().substring(0, answerHeader.getModuleItemKey().length() - 1));
            saveHeaders.add(answerHeader);
        }
        if (!saveHeaders.isEmpty()) {
            this.businessObjectService.save(saveHeaders);
        }
    }

    private void cleanUnreferencedQuestionnaire(String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, "7");
        fieldValues.put(MODULE_ITEM_KEY, protocolNumber + "T");
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)answerHeaders)) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected IacucProtocolSubmission createProtocolSubmission(IacucProtocol protocol, IacucProtocolNotifyIacucBean notifyIacucBean) {
        IacucProtocolSubmissionBuilder submissionBuilder = new IacucProtocolSubmissionBuilder(protocol, "110");
        submissionBuilder.setProtocolReviewTypeCode(notifyIacucBean.getReviewTypeCode());
        submissionBuilder.setSubmissionTypeQualifierCode(notifyIacucBean.getSubmissionQualifierTypeCode());
        submissionBuilder.setSubmissionStatus("102");
        submissionBuilder.setCommittee(notifyIacucBean.getCommitteeId());
        submissionBuilder.setComments(notifyIacucBean.getComment());
        submissionBuilder.setActionAttachments(notifyIacucBean.getActionAttachments());
        IacucProtocolSubmission submission = submissionBuilder.create();
        submission.setScheduleId(null);
        submission.setScheduleIdFk(null);
        return submission;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected IacucProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }
}

