/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmissionType;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class SubmissionTypeValuesFinder
extends IacucActionsKeyValuesBase {
    private static final long serialVersionUID = -4743158845190302163L;

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        ProtocolFormBase pf = (ProtocolFormBase)KNSGlobalVariables.getKualiForm();
        if (pf != null) {
            ProtocolBase protocol = pf.getProtocolDocument().getProtocol();
            Collection submissionTypes = this.getKeyValuesService().findAll(IacucProtocolSubmissionType.class);
            String currentStatus = pf.getProtocolDocument().getProtocol().getProtocolStatusCode();
            for (IacucProtocolSubmissionType submissionType : submissionTypes) {
                if (!this.validStatusSubmissionTypePair(submissionType, currentStatus, protocol)) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(submissionType.getSubmissionTypeCode(), submissionType.getDescription()));
            }
        }
        return keyValues;
    }

    protected boolean validStatusSubmissionTypePair(IacucProtocolSubmissionType submissionType, String currentStatus, ProtocolBase protocol) {
        if (StringUtils.equalsIgnoreCase((String)submissionType.getSubmissionTypeCode(), (String)"100")) {
            return this.displayResubmission(currentStatus) || this.displayInitialSubmission(currentStatus);
        }
        if (StringUtils.equalsIgnoreCase((String)submissionType.getSubmissionTypeCode(), (String)"104")) {
            return this.displayResubmission(currentStatus) || this.displayFYISubmission(currentStatus);
        }
        if (StringUtils.equalsIgnoreCase((String)submissionType.getSubmissionTypeCode(), (String)"105")) {
            return this.displayResubmission(currentStatus) || this.displayAmendment(currentStatus, protocol);
        }
        if (StringUtils.equalsIgnoreCase((String)submissionType.getSubmissionTypeCode(), (String)"108")) {
            return this.displayResubmission(currentStatus) || this.displayContinuation(currentStatus, protocol);
        }
        if (StringUtils.equalsIgnoreCase((String)submissionType.getSubmissionTypeCode(), (String)"109")) {
            return this.displayResubmission(currentStatus) || this.displayContinuationWithAmendment(currentStatus, protocol);
        }
        if (StringUtils.equalsIgnoreCase((String)submissionType.getSubmissionTypeCode(), (String)"101")) {
            return this.displayResubmission(currentStatus) || this.displayResponseToPrevIACUCNotification(currentStatus);
        }
        return false;
    }

    private boolean displayFYISubmission(String currentStatus) {
        String[] validStatuses = new String[]{"100", "105", "101", "302", "203"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayInitialSubmission(String currentStatus) {
        String[] validStatuses = new String[]{"100", "105", "101", "302", "203"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayResponseToPrevIACUCNotification(String currentStatus) {
        String[] validStatuses = new String[]{"104", "107", "201", "101", "102"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean displayAmendment(String currentStatus, ProtocolBase protocol) {
        String[] validStatuses = new String[]{"105", "205", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && this.hasAmmendmentProtocolNumber(protocol.getProtocolNumber());
    }

    private boolean displayContinuation(String currentStatus, ProtocolBase protocol) {
        String[] validStatuses = new String[]{"105", "206", "207", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && (this.hasRenewalProtocolNumber(protocol.getProtocolNumber()) || this.hasContinuationProtocolNumber(protocol.getProtocolNumber()));
    }

    private boolean displayContinuationWithAmendment(String currentStatus, ProtocolBase protocol) {
        String[] validStatuses = new String[]{"105", "206", "207", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses) && (this.hasRenewalProtocolNumber(protocol.getProtocolNumber()) || this.hasContinuationProtocolNumber(protocol.getProtocolNumber()));
    }

    private boolean hasAmmendmentProtocolNumber(String protocolNumber) {
        return protocolNumber.contains("A");
    }

    private boolean hasRenewalProtocolNumber(String protocolNumber) {
        return protocolNumber.contains("R");
    }

    private boolean hasContinuationProtocolNumber(String protocolNumber) {
        return protocolNumber.contains("C");
    }

    private boolean displayResubmission(String currentStatus) {
        String[] validStatuses = new String[]{"105", "101"};
        return this.validateCurrentStatus(currentStatus, validStatuses);
    }

    private boolean validateCurrentStatus(String currentStatus, String[] validStatuses) {
        for (String status : validStatuses) {
            if (!StringUtils.equals((String)currentStatus, (String)status)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

