/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.withdraw;

import java.sql.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.withdraw.IacucProtocolWithdrawService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyIncompleteBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyWithdrawBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawServiceImplBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;

public class IacucProtocolWithdrawServiceImpl
extends ProtocolWithdrawServiceImplBase
implements IacucProtocolWithdrawService {
    @Override
    public ProtocolDocumentBase administrativelyMarkIncomplete(ProtocolBase protocol, ProtocolAdministrativelyIncompleteBean markIncompleteBean) throws Exception {
        String protocolWithdrawnActionTypeCode = "216";
        String protocolWithdrawnStatusCode = "203";
        String protocolWithdrawnSubmissionStatusCode = "214";
        return this.commonWithdrawLogic(protocol, markIncompleteBean, protocolWithdrawnActionTypeCode, protocolWithdrawnStatusCode, protocolWithdrawnSubmissionStatusCode);
    }

    @Override
    public ProtocolDocumentBase administrativelyWithdraw(ProtocolBase protocol, ProtocolAdministrativelyWithdrawBean administrativelyWithdrawBean) throws Exception {
        String protocolWithdrawnActionTypeCode = "300";
        String protocolWithdrawnStatusCode = "302";
        String protocolWithdrawnSubmissionStatusCode = "204";
        return this.commonWithdrawLogic(protocol, administrativelyWithdrawBean, protocolWithdrawnActionTypeCode, protocolWithdrawnStatusCode, protocolWithdrawnSubmissionStatusCode);
    }

    @Override
    public ProtocolDocumentBase withdraw(ProtocolBase protocol, ProtocolWithdrawBean withdrawBean) throws Exception {
        String protocolWithdrawnActionTypeCode = "115";
        String protocolWithdrawnStatusCode = "105";
        String protocolWithdrawnSubmissionStatusCode = "204";
        return this.commonWithdrawLogic(protocol, withdrawBean, protocolWithdrawnActionTypeCode, protocolWithdrawnStatusCode, protocolWithdrawnSubmissionStatusCode);
    }

    private ProtocolDocumentBase commonWithdrawLogic(ProtocolBase protocol, ProtocolWithdrawBean withdrawBean, String protocolWithdrawnActionTypeCode, String protocolWithdrawnStatusCode, String protocolWithdrawnSubmissionStatusCode) throws Exception {
        ProtocolSubmissionBase submission = this.getSubmission(protocol);
        IacucProtocolAction protocolAction = new IacucProtocolAction((IacucProtocol)protocol, null, protocolWithdrawnActionTypeCode);
        protocolAction.setComments(withdrawBean.getReason());
        protocol.getProtocolActions().add(protocolAction);
        boolean isVersion = "100".equals(protocol.getProtocolStatusCode()) || "101".equals(protocol.getProtocolStatusCode()) || "103".equals(protocol.getProtocolStatusCode());
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        if (submission != null) {
            submission.setSubmissionDate(new Date(System.currentTimeMillis()));
            submission.setSubmissionStatusCode(protocolWithdrawnSubmissionStatusCode);
        }
        this.businessObjectService.save((PersistableBusinessObject)protocol.getProtocolDocument());
        if (isVersion) {
            this.cancelWorkflow(protocol);
            IacucProtocolDocument newProtocolDocument = (IacucProtocolDocument)this.protocolVersionService.versionProtocolDocument(protocol.getProtocolDocument());
            newProtocolDocument.getProtocol().setProtocolStatusCode(protocolWithdrawnStatusCode);
            newProtocolDocument.getProtocol().setProtocolSubmission(null);
            newProtocolDocument.getProtocol().setApprovalDate(null);
            newProtocolDocument.getProtocol().setLastApprovalDate(null);
            newProtocolDocument.getProtocol().setExpirationDate(null);
            newProtocolDocument.getProtocol().refreshReferenceObject("protocolStatus");
            this.documentService.saveDocument((Document)newProtocolDocument);
            newProtocolDocument.getProtocol().refreshReferenceObject("protocolStatus");
            this.documentService.saveDocument((Document)newProtocolDocument);
            this.generateCorrespondenceDocumentAndAttach(newProtocolDocument.getProtocol(), withdrawBean);
            return newProtocolDocument;
        }
        this.generateCorrespondenceDocumentAndAttach(protocol, withdrawBean);
        return protocol.getProtocolDocument();
    }

    @Override
    protected boolean isAllowedStatus(ProtocolSubmissionBase submission) {
        return StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"101") || StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102");
    }

    @Override
    protected boolean isNormalSubmission(ProtocolSubmissionBase submission) {
        return StringUtils.equals((String)submission.getSubmissionTypeCode(), (String)"105") || StringUtils.equals((String)submission.getSubmissionTypeCode(), (String)"100") || StringUtils.equals((String)submission.getSubmissionTypeCode(), (String)"108") || StringUtils.equals((String)submission.getSubmissionTypeCode(), (String)"109");
    }
}

