/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.protocol.auth.ProtocolAuthorizerBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class IacucProtocolAuthorizer
extends ProtocolAuthorizerBase {
    @Override
    public final boolean isAuthorized(String userId, ProtocolTaskBase task) {
        return this.isAuthorized(userId, (IacucProtocolTask)task);
    }

    public abstract boolean isAuthorized(String var1, IacucProtocolTask var2);

    protected boolean canPerformApproval(IacucProtocolAction lastAction, IacucProtocolSubmission lastSubmission) {
        boolean canPerform = false;
        if (lastAction != null && lastSubmission != null) {
            canPerform = this.isRecordCommitteeDecision(lastAction) && this.isMotionTypeApprove(lastSubmission) || this.isDesignatedMemberReview(lastAction, lastSubmission);
        }
        return canPerform;
    }

    protected boolean canPerformSMR(IacucProtocolAction lastAction, IacucProtocolSubmission lastSubmission) {
        boolean canPerform = false;
        if (lastAction != null && lastSubmission != null) {
            canPerform = this.isRecordCommitteeDecision(lastAction) && this.isMotionTypeMinorRevision(lastSubmission) || this.isDesignatedMemberReview(lastAction, lastSubmission);
        }
        return canPerform;
    }

    protected boolean canPerformSRR(IacucProtocolAction lastAction, IacucProtocolSubmission lastSubmission) {
        boolean canPerform = false;
        if (lastAction != null && lastSubmission != null) {
            canPerform = this.isRecordCommitteeDecision(lastAction) && this.isMotionTypeSubstantiveRevision(lastSubmission) || this.isDesignatedMemberReview(lastAction, lastSubmission);
        }
        return canPerform;
    }

    private boolean isMotionTypeMinorRevision(IacucProtocolSubmission lastSubmission) {
        return "3".equals(lastSubmission.getCommitteeDecisionMotionTypeCode());
    }

    private boolean isMotionTypeSubstantiveRevision(IacucProtocolSubmission lastSubmission) {
        return "4".equals(lastSubmission.getCommitteeDecisionMotionTypeCode());
    }

    private boolean isMotionTypeApprove(IacucProtocolSubmission lastSubmission) {
        return "1".equals(lastSubmission.getCommitteeDecisionMotionTypeCode());
    }

    private boolean isRecordCommitteeDecision(IacucProtocolAction lastAction) {
        return "318".equals(lastAction.getProtocolActionTypeCode());
    }

    private boolean isDesignatedMemberReview(IacucProtocolAction lastAction, IacucProtocolSubmission lastSubmission) {
        if (ObjectUtils.isNull((Object)lastAction.getProtocol())) {
            lastAction.refreshReferenceObject("protocol");
        }
        return "101".equals(lastAction.getProtocol().getProtocolStatusCode()) && "102".equals(lastSubmission.getSubmissionStatusCode()) && "2".equals(lastSubmission.getProtocolReviewTypeCode());
    }
}

