/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.iacuc.auth.ModifyIacucProtocolAuthorizer;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewService;

public abstract class ModifyIacucAmendmentAuthorizer
extends ModifyIacucProtocolAuthorizer {
    private String moduleTypeCode;
    private ProtocolAmendRenewService protocolAmendRenewService;

    protected ModifyIacucAmendmentAuthorizer(String moduleTypeCode) {
        this.moduleTypeCode = moduleTypeCode;
    }

    @Override
    public boolean isAuthorized(String userId, IacucProtocolTask task) {
        IacucProtocol protocol = task.getProtocol();
        boolean hasPermission = super.isAuthorized(userId, task);
        if (hasPermission && this.isAmendmentOrRenewal(protocol)) {
            hasPermission = this.canModifyModule(protocol, this.moduleTypeCode);
        }
        if (hasPermission && protocol.isCorrectionMode()) {
            hasPermission = this.canCorrectModule(protocol, this.moduleTypeCode);
        }
        return hasPermission;
    }

    private boolean canCorrectModule(ProtocolBase protocol, String moduleTypeCode) {
        List<Object> availableModules = new ArrayList();
        try {
            availableModules = this.protocolAmendRenewService.getAvailableModules(protocol.getProtocolNumber());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return availableModules.contains(moduleTypeCode);
    }

    private boolean canModifyModule(ProtocolBase protocol, String moduleTypeCode) {
        return protocol.getProtocolAmendRenewal().hasModule(moduleTypeCode);
    }

    public void setProtocolAmendRenewService(ProtocolAmendRenewService protocolAmendRenewService) {
        this.protocolAmendRenewService = protocolAmendRenewService;
    }
}

