/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.committee.print;

import edu.mit.coeus.xml.iacuc.FundingSourceType;
import edu.mit.coeus.xml.iacuc.InvestigatorType;
import edu.mit.coeus.xml.iacuc.PersonType;
import edu.mit.coeus.xml.iacuc.ProtocolMasterDataType;
import edu.mit.coeus.xml.iacuc.ProtocolReviewerType;
import edu.mit.coeus.xml.iacuc.ProtocolSubmissionType;
import edu.mit.coeus.xml.iacuc.ProtocolSummaryType;
import edu.mit.coeus.xml.iacuc.ScheduleDocument;
import edu.mit.coeus.xml.iacuc.ScheduleMasterDataType;
import edu.mit.coeus.xml.iacuc.ScheduleSummaryType;
import edu.mit.coeus.xml.iacuc.ScheduleType;
import edu.mit.coeus.xml.iacuc.SubmissionDetailsType;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.service.CommitteeMembershipServiceBase;
import org.kuali.kra.iacuc.committee.bo.IacucCommitteeSchedule;
import org.kuali.kra.iacuc.committee.print.service.IacucPrintXmlUtilService;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.xmlstream.PrintBaseXmlStream;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.service.KcPersonService;

public class IacucScheduleXmlStream
extends PrintBaseXmlStream {
    private CommitteeMembershipServiceBase committeeMembershipService;
    private KcPersonService kcPersonService;
    private IacucPrintXmlUtilService printXmlUtilService;
    private String EXPEDIT_ACTION_TYPE_CODE = "205";
    private String EXEMPT_ACTION_TYPE_CODE = "206";
    private String FOLLOW_UP_ACTION_CODE = "109";

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        CommitteeBase committee = (CommitteeBase)printableBusinessObject;
        String scheduleId = (String)reportParameters.get("scheduleId");
        CommitteeScheduleBase committeeSchedule = this.findCommitteeSchedule(committee, scheduleId);
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        ScheduleDocument scheduleDocument = ScheduleDocument.Factory.newInstance();
        scheduleDocument.setSchedule(this.getSchedule(committeeSchedule));
        xmlObjectList.put("Schedule", (XmlObject)scheduleDocument);
        System.out.print(xmlObjectList);
        return xmlObjectList;
    }

    private CommitteeScheduleBase findCommitteeSchedule(CommitteeBase committee, String scheduleId) {
        List committeeSchedules = committee.getCommitteeSchedules();
        for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
            if (!committeeSchedule.getScheduleId().equals(scheduleId)) continue;
            return committeeSchedule;
        }
        return null;
    }

    public ScheduleType getSchedule(CommitteeScheduleBase committeeSchedule) {
        ScheduleType schedule = ScheduleType.Factory.newInstance();
        this.setScheduleMasterData(committeeSchedule, schedule.addNewScheduleMasterData());
        ScheduleSummaryType prevSchedule = schedule.addNewPreviousSchedule();
        this.setPreviousSchedule(committeeSchedule, prevSchedule.addNewScheduleMasterData());
        ScheduleSummaryType nextScheduleType = schedule.addNewNextSchedule();
        this.setNextSchedule(committeeSchedule, nextScheduleType.addNewScheduleMasterData());
        if (this.getPrintXmlUtilService() == null) {
            this.printXmlUtilService = KraServiceLocator.getService(IacucPrintXmlUtilService.class);
        }
        this.getPrintXmlUtilService().setMinutes(committeeSchedule, schedule);
        this.setAttendance(committeeSchedule, schedule);
        committeeSchedule.refreshReferenceObject("protocolSubmissions");
        List submissions = committeeSchedule.getLatestProtocolSubmissions();
        for (ProtocolSubmissionBase protocolSubmission : submissions) {
            ProtocolSubmissionType protocolSubmissionType = schedule.addNewProtocolSubmission();
            SubmissionDetailsType protocolSubmissionDetail = protocolSubmissionType.addNewSubmissionDetails();
            ProtocolSummaryType protocolSummary = protocolSubmissionType.addNewProtocolSummary();
            ProtocolMasterDataType protocolMaster = protocolSummary.addNewProtocolMasterData();
            String followUpAction = null;
            String actionTypeCode = null;
            ProtocolBase protocol = protocolSubmission.getProtocol();
            String submissionStatus = protocol.getProtocolSubmission().getSubmissionStatusCode();
            List<ProtocolActionBase> protocolActions = protocolSubmission.getProtocol().getProtocolActions();
            for (ProtocolActionBase protocolAction : protocolActions) {
                actionTypeCode = protocolAction.getProtocolActionTypeCode();
                if (!actionTypeCode.equals(this.EXPEDIT_ACTION_TYPE_CODE) && !actionTypeCode.equals(this.EXEMPT_ACTION_TYPE_CODE)) continue;
                if (protocolAction.getFollowupActionCode() == null || !protocolAction.getFollowupActionCode().equals(this.FOLLOW_UP_ACTION_CODE)) break;
                followUpAction = protocolAction.getFollowupActionCode();
                break;
            }
            if ((actionTypeCode.equals(this.EXPEDIT_ACTION_TYPE_CODE) || actionTypeCode.equals(this.EXEMPT_ACTION_TYPE_CODE)) && followUpAction == null) continue;
            protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
            protocolMaster.setSequenceNumber(new BigInteger(String.valueOf(protocol.getSequenceNumber())));
            protocolMaster.setProtocolTitle(protocol.getTitle());
            protocolMaster.setProtocolStatusCode(new BigInteger(String.valueOf(protocol.getProtocolStatusCode())));
            protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
            protocolMaster.setProtocolTypeCode(new BigInteger(String.valueOf(protocol.getProtocolTypeCode())));
            protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
            if (protocol.getDescription() != null) {
                protocolMaster.setProtocolDescription(protocol.getDescription());
            }
            if (protocol.getApprovalDate() != null) {
                protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getApprovalDate()));
            }
            if (protocol.getExpirationDate() != null) {
                protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((java.util.Date)protocol.getExpirationDate()));
            }
            if (protocol.getFdaApplicationNumber() != null) {
                protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
            }
            if (protocol.getReferenceNumber1() != null) {
                protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
            }
            if (protocol.getReferenceNumber2() != null) {
                protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
            }
            protocolSubmissionDetail.setProtocolNumber(protocolSubmission.getProtocolNumber());
            if (protocolSubmission.getProtocolSubmissionType() != null) {
                protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
            }
            if (protocolSubmission.getProtocolReviewTypeCode() != null) {
                protocolSubmissionDetail.setProtocolReviewTypeCode(new BigInteger(protocolSubmission.getProtocolReviewTypeCode()));
            }
            if (protocolSubmission.getProtocolReviewType() != null) {
                protocolSubmissionDetail.setProtocolReviewTypeDesc(protocolSubmission.getProtocolReviewType().getDescription());
            }
            if (protocolSubmission.getSubmissionTypeCode() != null) {
                protocolSubmissionDetail.setSubmissionTypeCode(new BigInteger(String.valueOf(protocolSubmission.getSubmissionTypeCode())));
            }
            if (protocolSubmission.getProtocolSubmissionType() != null) {
                protocolSubmissionDetail.setSubmissionTypeDesc(protocolSubmission.getProtocolSubmissionType().getDescription());
            }
            if (protocolSubmission.getSubmissionNumber() != null) {
                protocolSubmissionDetail.setSubmissionNumber(new BigInteger(String.valueOf(protocolSubmission.getSubmissionNumber())));
            }
            if (protocolSubmission.getSubmissionStatusCode() != null) {
                protocolSubmissionDetail.setSubmissionStatusCode(new BigInteger(String.valueOf(protocolSubmission.getSubmissionStatusCode())));
            }
            if (protocolSubmission.getSubmissionStatus() != null) {
                protocolSubmissionDetail.setSubmissionStatusDesc(protocolSubmission.getSubmissionStatus().getDescription());
            }
            if (protocolSubmission.getSubmissionTypeQualifierCode() != null) {
                protocolSubmissionDetail.setSubmissionTypeQualifierCode(new BigInteger(protocolSubmission.getSubmissionTypeQualifierCode()));
            }
            if (protocolSubmission.getProtocolSubmissionQualifierType() != null) {
                protocolSubmissionDetail.setSubmissionTypeQualifierDesc(protocolSubmission.getProtocolSubmissionQualifierType().getDescription());
            }
            if (protocolSubmission.getYesVoteCount() != null) {
                protocolSubmissionDetail.setYesVote(BigInteger.valueOf(protocolSubmission.getYesVoteCount().intValue()));
            } else {
                protocolSubmissionDetail.setYesVote(BigInteger.ZERO);
            }
            if (protocolSubmission.getNoVoteCount() != null) {
                protocolSubmissionDetail.setNoVote(BigInteger.valueOf(protocolSubmission.getNoVoteCount().intValue()));
            } else {
                protocolSubmissionDetail.setNoVote(BigInteger.ZERO);
            }
            if (protocolSubmission.getAbstainerCount() != null) {
                protocolSubmissionDetail.setAbstainerCount(BigInteger.valueOf(protocolSubmission.getAbstainerCount().intValue()));
            } else {
                protocolSubmissionDetail.setAbstainerCount(BigInteger.ZERO);
            }
            protocolSubmissionDetail.setVotingComments(protocolSubmission.getVotingComments());
            this.setProtocolSubmissionAction(protocolSubmission, protocolSubmissionDetail);
            if (protocolSubmission.getSubmissionDate() != null) {
                protocolSubmissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((java.util.Date)protocolSubmission.getSubmissionDate()));
            }
            this.setSubmissionCheckListinfo(protocolSubmission, protocolSubmissionDetail);
            this.setProtocolSubmissionReviewers(protocolSubmission, protocolSubmissionDetail);
            List<ProtocolPersonBase> protocolPersons = protocolSubmission.getProtocol().getProtocolPersons();
            for (ProtocolPersonBase protocolPerson : protocolPersons) {
                if (!protocolPerson.getProtocolPersonRoleId().equals("PI") && !protocolPerson.getProtocolPersonRoleId().equals("COI")) continue;
                InvestigatorType investigator = protocolSummary.addNewInvestigator();
                this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, investigator.addNewPerson());
                if (!protocolPerson.getProtocolPersonRoleId().equals("PI")) continue;
                investigator.setPIFlag(true);
            }
            List<ProtocolFundingSourceBase> vecFundingSource = protocol.getProtocolFundingSources();
            for (ProtocolFundingSourceBase protocolFundingSourceBean : vecFundingSource) {
                protocolFundingSourceBean.refreshNonUpdateableReferences();
                FundingSourceType fundingSource = protocolSummary.addNewFundingSource();
                String fundingSourceCode = protocolFundingSourceBean.getFundingSourceNumber();
                int fundingSourceTypeCode = Integer.valueOf(protocolFundingSourceBean.getFundingSourceTypeCode());
                String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
                fundingSource.setFundingSourceName(fundingSourceName);
                if (protocolFundingSourceBean.getFundingSourceType() == null) continue;
                fundingSource.setTypeOfFundingSource(protocolFundingSourceBean.getFundingSourceType().getDescription());
            }
            this.getPrintXmlUtilService().setProcotolMinutes(committeeSchedule, protocolSubmission, protocolSubmissionType);
            this.setOtherActionItems(committeeSchedule, schedule);
        }
        return schedule;
    }

    private void setProtocolSubmissionAction(ProtocolSubmissionBase protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        ProtocolActionBase protcolAction = this.findProtocolActionForSubmission(protocolSubmission);
        if (protcolAction != null) {
            protcolAction.refreshNonUpdateableReferences();
            SubmissionDetailsType.ActionType actionTypeInfo = protocolSubmissionDetail.addNewActionType();
            actionTypeInfo.setActionId(BigInteger.valueOf(protcolAction.getActionId().intValue()));
            if (protcolAction.getProtocolActionTypeCode() != null) {
                actionTypeInfo.setActionTypeCode(new BigInteger(protcolAction.getProtocolActionTypeCode()));
                actionTypeInfo.setActionTypeDescription(protcolAction.getProtocolActionType().getDescription());
            }
            if (protcolAction.getActionDate() != null) {
                actionTypeInfo.setActionDate(this.getDateTimeService().getCalendar((java.util.Date)protcolAction.getActionDate()));
            }
            actionTypeInfo.setActionComments(protcolAction.getComments());
        }
    }

    private void setOtherActionItems(CommitteeScheduleBase committeeSchedule, ScheduleType schedule) {
        List<CommScheduleActItemBase> otherActions = committeeSchedule.getCommScheduleActItems();
        for (CommScheduleActItemBase otherActionInfoBean : otherActions) {
            otherActionInfoBean.refreshNonUpdateableReferences();
            ScheduleType.OtherBusiness otherBusinessType = schedule.addNewOtherBusiness();
            otherBusinessType.setActionItemNumber(BigInteger.valueOf(otherActionInfoBean.getActionItemNumber().intValue()));
            otherBusinessType.setActionItemDesc(otherActionInfoBean.getItemDescription());
            if (otherActionInfoBean.getScheduleActItemType() == null) continue;
            otherBusinessType.setActionItemCode(new BigInteger(otherActionInfoBean.getScheduleActItemTypeCode()));
            otherBusinessType.setActionItemCodeDesc(otherActionInfoBean.getScheduleActItemType().getDescription());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsor = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsor != null) {
                name = sponsor.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unit = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unit != null) {
                name = unit.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void setProtocolSubmissionReviewers(ProtocolSubmissionBase protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        List<ProtocolReviewer> vecReviewers = protocolSubmission.getProtocolReviewers();
        ArrayList<ProtocolReviewerType> protocolReviewerTypeList = new ArrayList<ProtocolReviewerType>();
        for (ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerType protocolReviewerType = ProtocolReviewerType.Factory.newInstance();
            this.setPerson(protocolReviewer, protocolReviewerType);
            protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
            protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
            protocolReviewerTypeList.add(protocolReviewerType);
        }
        protocolSubmissionDetail.setProtocolReviewerArray(protocolReviewerTypeList.toArray(new ProtocolReviewerType[0]));
    }

    private void setPerson(ProtocolReviewer protocolReviewer, ProtocolReviewerType protocolReviewerType) {
        PersonType personType = protocolReviewerType.addNewPerson();
        boolean nonEmployeeFlag = protocolReviewer.getNonEmployeeFlag();
        if (!nonEmployeeFlag) {
            String personId = protocolReviewer.getPersonId();
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(personId);
            this.getPrintXmlUtilService().setPersonXml(person, personType);
        } else {
            Rolodex rolodex = protocolReviewer.getRolodex();
            ProtocolPersonRolodexBase protocolRolodex = (ProtocolPersonRolodexBase)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolPersonRolodex.class, (Object)rolodex.getRolodexId());
            this.getPrintXmlUtilService().setPersonXml(protocolRolodex, personType);
        }
    }

    private void setSubmissionCheckListinfo(ProtocolSubmissionBase protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        SubmissionDetailsType.SubmissionChecklistInfo submissionChecklistInfo = protocolSubmissionDetail.addNewSubmissionChecklistInfo();
        String formattedCode = new String();
    }

    private ProtocolActionBase findProtocolActionForSubmission(ProtocolSubmissionBase protocolSubmission) {
        List<ProtocolActionBase> protocolActions = protocolSubmission.getProtocol().getProtocolActions();
        for (ProtocolActionBase protocolAction : protocolActions) {
            if (protocolAction.getSubmissionNumber() == null || !protocolAction.getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber())) continue;
            return protocolAction;
        }
        return null;
    }

    private void setAttendance(CommitteeScheduleBase committeeSchedule, ScheduleType schedule) {
        List<CommitteeScheduleAttendanceBase> attendenceList = committeeSchedule.getCommitteeScheduleAttendances();
        for (CommitteeScheduleAttendanceBase attendanceInfoBean : attendenceList) {
            ScheduleType.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(attendanceInfoBean.getPersonName());
            attendents.setAlternateFlag(attendanceInfoBean.getAlternateFlag());
            attendents.setGuestFlag(attendanceInfoBean.getGuestFlag());
            attendents.setAlternateFor(attendanceInfoBean.getAlternateFor());
            attendents.setPresentFlag(true);
        }
        List<CommitteeMembershipBase> committeeMemberships = ((CommitteeBase)committeeSchedule.getParentCommittee()).getCommitteeMemberships();
        for (CommitteeMembershipBase committeeMembership : committeeMemberships) {
            if (this.getCommitteeMembershipService().isMemberAttendedMeeting(committeeMembership, ((CommitteeBase)committeeSchedule.getParentCommittee()).getCommitteeId())) continue;
            ScheduleType.Attendents attendents = schedule.addNewAttendents();
            attendents.setAttendentName(committeeMembership.getPersonName());
            attendents.setAlternateFlag(false);
            attendents.setGuestFlag(false);
            attendents.setPresentFlag(false);
        }
    }

    public ScheduleMasterDataType setScheduleMasterData(CommitteeScheduleBase scheduleDetailsBean, ScheduleMasterDataType scheduleMasterDataType) {
        scheduleDetailsBean.refreshNonUpdateableReferences();
        String committeeId = ((CommitteeBase)scheduleDetailsBean.getParentCommittee()).getCommitteeId();
        scheduleMasterDataType.setScheduleId(scheduleDetailsBean.getScheduleId());
        scheduleMasterDataType.setCommitteeId(committeeId);
        scheduleMasterDataType.setCommitteeName(((CommitteeBase)scheduleDetailsBean.getParentCommittee()).getCommitteeName());
        scheduleMasterDataType.setScheduleStatusCode(BigInteger.valueOf(scheduleDetailsBean.getScheduleStatusCode().intValue()));
        scheduleMasterDataType.setScheduleStatusDesc(scheduleDetailsBean.getScheduleStatus().getDescription());
        if (scheduleDetailsBean.getScheduledDate() != null) {
            scheduleMasterDataType.setScheduledDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getScheduledDate()));
        } else {
            scheduleMasterDataType.setScheduledDate(this.getDateTimeService().getCurrentCalendar());
        }
        try {
            if (scheduleDetailsBean.getTime() != null) {
                Date date = this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getTime());
                scheduleMasterDataType.setScheduledTime(this.getDateTimeService().getCalendar((java.util.Date)date));
            }
            scheduleMasterDataType.setPlace(scheduleDetailsBean.getPlace());
            if (scheduleDetailsBean.getProtocolSubDeadline() != null) {
                scheduleMasterDataType.setProtocolSubDeadline(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getProtocolSubDeadline()));
            }
            if (scheduleDetailsBean.getMeetingDate() != null) {
                scheduleMasterDataType.setMeetingDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getMeetingDate()));
            }
            if (scheduleDetailsBean.getStartTime() != null) {
                scheduleMasterDataType.setStartTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getStartTime())));
            }
            if (scheduleDetailsBean.getEndTime() != null) {
                scheduleMasterDataType.setEndTime(this.getDateTimeService().getCalendar((java.util.Date)this.getDateTimeService().convertToSqlDate(scheduleDetailsBean.getEndTime())));
            }
            if (scheduleDetailsBean.getAgendaProdRevDate() != null) {
                scheduleMasterDataType.setAgendaProdRevDate(this.getDateTimeService().getCalendar((java.util.Date)scheduleDetailsBean.getAgendaProdRevDate()));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        scheduleMasterDataType.setMaxProtocols(new BigInteger(String.valueOf(scheduleDetailsBean.getMaxProtocols())));
        if (scheduleDetailsBean.getComments() != null) {
            scheduleMasterDataType.setComments(scheduleDetailsBean.getComments());
        }
        return scheduleMasterDataType;
    }

    public void setNextSchedule(CommitteeScheduleBase scheduleDetailsBean, ScheduleMasterDataType scheduleMasterData) {
        CommitteeScheduleBase nextSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, true);
        if (nextSchedule != null) {
            this.setScheduleMasterData(nextSchedule, scheduleMasterData);
        }
    }

    public void setPreviousSchedule(CommitteeScheduleBase scheduleDetailsBean, ScheduleMasterDataType scheduleMasterDataType) {
        CommitteeScheduleBase prevSchedule = this.getNextOrPreviousSchedule(scheduleDetailsBean, true);
        if (prevSchedule != null) {
            this.setScheduleMasterData(prevSchedule, scheduleMasterDataType);
        }
    }

    private CommitteeScheduleBase getNextOrPreviousSchedule(CommitteeScheduleBase scheduleDetailsBean, boolean nextFlag) {
        HashMap<String, String> scheduleParam = new HashMap<String, String>();
        scheduleParam.put("committeeIdFk", ((CommitteeBase)scheduleDetailsBean.getParentCommittee()).getId().toString());
        List schedules = (List)this.getBusinessObjectService().findMatchingOrderBy(IacucCommitteeSchedule.class, scheduleParam, "scheduledDate", false);
        if (!schedules.isEmpty()) {
            int size = schedules.size();
            for (int i = 0; i < size; ++i) {
                CommitteeScheduleBase schedule = (CommitteeScheduleBase)schedules.get(i);
                if (!schedule.getScheduleId().equals(scheduleDetailsBean.getScheduleId())) continue;
                if (nextFlag && i < size - 1) {
                    return (CommitteeScheduleBase)schedules.get(i + 1);
                }
                if (!nextFlag && i > 0) {
                    return (CommitteeScheduleBase)schedules.get(i - 1);
                }
                return null;
            }
        }
        return null;
    }

    public void setCommitteeMembershipService(CommitteeMembershipServiceBase committeeMembershipService) {
        this.committeeMembershipService = committeeMembershipService;
    }

    public CommitteeMembershipServiceBase getCommitteeMembershipService() {
        return this.committeeMembershipService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public IacucPrintXmlUtilService getPrintXmlUtilService() {
        return this.printXmlUtilService;
    }

    public void setPrintXmlUtilService(IacucPrintXmlUtilService PrintXmlUtilService) {
        this.printXmlUtilService = this.printXmlUtilService;
    }
}

