/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.committee.print.service.impl;

import edu.mit.coeus.xml.iacuc.MinuteType;
import edu.mit.coeus.xml.iacuc.PersonType;
import edu.mit.coeus.xml.iacuc.ProtocolSubmissionType;
import edu.mit.coeus.xml.iacuc.ProtocolType;
import edu.mit.coeus.xml.iacuc.ScheduleType;
import edu.mit.coeus.xml.iacuc.SubmissionDetailsType;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.iacuc.actions.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.print.service.IacucPrintXmlUtilService;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IacucPrintXmlUtilServiceImpl
implements IacucPrintXmlUtilService {
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private ReviewCommentsService reviewCommentsService;

    @Override
    public void setPersonXml(KcPerson person, PersonType personType) {
        personType.setPersonID(person.getPersonId());
        personType.setFullname(person.getFullName());
        personType.setLastName(person.getLastName());
        personType.setFirstname(person.getFirstName());
        personType.setDegree(person.getDegree() != null ? person.getDegree() : null);
        personType.setSalutation(person.getSaluation() != null ? person.getSaluation() : null);
        personType.setEmail(person.getEmailAddress() != null ? person.getEmailAddress() : null);
        personType.setOfficeLocation(person.getOfficeLocation() != null ? person.getOfficeLocation() : null);
        personType.setOfficePhone(person.getOfficePhone() != null ? person.getOfficePhone() : null);
        personType.setDirectoryTitle(person.getDirectoryTitle() != null ? person.getDirectoryTitle() : null);
        personType.setAddressLine1(person.getAddressLine1() != null ? person.getAddressLine1() : null);
        personType.setAddressLine2(person.getAddressLine2() != null ? person.getAddressLine2() : null);
        personType.setAddressLine3(person.getAddressLine3() != null ? person.getAddressLine3() : null);
        personType.setCity(person.getCity() != null ? person.getCity() : null);
        personType.setState(person.getState() != null ? person.getState() : null);
        personType.setCountry(person.getCountryCode() != null ? person.getCountryCode() : null);
        personType.setCountryCode(person.getCountryCode() != null ? person.getCountryCode() : null);
        personType.setPostalCode(person.getPostalCode() != null ? person.getPostalCode() : null);
        personType.setFaxNumber(person.getFaxNumber() != null ? person.getFaxNumber() : null);
        personType.setPagerNumber(person.getPagerNumber() != null ? person.getPagerNumber() : null);
        personType.setMobilePhoneNumber(person.getMobilePhoneNumber() != null ? person.getMobilePhoneNumber() : null);
        personType.setDepartmentOrganization(person.getDirectoryDepartment() != null ? person.getDirectoryDepartment() : null);
    }

    @Override
    public void setPersonRolodexType(ProtocolPersonBase protocolPerson, PersonType personType) {
        if (protocolPerson.getPerson() == null) {
            IacucProtocolPersonRolodex rolodex = (IacucProtocolPersonRolodex)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolPersonRolodex.class, (Object)protocolPerson.getRolodexId());
            this.setPersonXml(rolodex, personType);
        } else {
            KcPerson kcPerson = protocolPerson.getPerson();
            this.setPersonXml(kcPerson, personType);
        }
    }

    @Override
    public void setPersonXml(ProtocolPersonRolodexBase rolodex, PersonType personType) {
        personType.setPersonID(rolodex.getRolodexId().toString());
        String fullName = rolodex.getMiddleName() != null ? rolodex.getLastName() + "," + rolodex.getFirstName() + rolodex.getMiddleName() : rolodex.getLastName() + "," + rolodex.getFirstName();
        personType.setFullname(fullName);
        personType.setLastName(rolodex.getLastName());
        personType.setFirstname(rolodex.getFirstName());
        personType.setEmail(rolodex.getEmailAddress() != null ? rolodex.getEmailAddress() : null);
        personType.setAddressLine1(rolodex.getAddressLine1() != null ? rolodex.getAddressLine1() : null);
        personType.setAddressLine2(rolodex.getAddressLine2() != null ? rolodex.getAddressLine2() : null);
        personType.setAddressLine3(rolodex.getAddressLine3() != null ? rolodex.getAddressLine3() : null);
        personType.setCity(rolodex.getCity() != null ? rolodex.getCity() : null);
        personType.setState(rolodex.getState() != null ? rolodex.getState() : null);
        personType.setCountryCode(rolodex.getCountryCode() != null ? rolodex.getCountryCode() : null);
        personType.setPostalCode(rolodex.getPostalCode() != null ? rolodex.getPostalCode() : null);
        personType.setFaxNumber(rolodex.getFaxNumber() != null ? rolodex.getFaxNumber() : null);
        personType.setMobilePhoneNumber(rolodex.getPhoneNumber() != null ? rolodex.getPhoneNumber() : null);
        personType.setDepartmentOrganization(rolodex.getOrganization() != null ? rolodex.getOrganization() : null);
    }

    @Override
    public void setProtocolSubmissionAction(IacucProtocolSubmission protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        ProtocolActionBase protcolAction = this.findProtocolActionForSubmission(protocolSubmission);
        if (protcolAction != null) {
            protcolAction.refreshNonUpdateableReferences();
            SubmissionDetailsType.ActionType actionTypeInfo = protocolSubmissionDetail.addNewActionType();
            actionTypeInfo.setActionId(BigInteger.valueOf(protcolAction.getActionId().intValue()));
            if (protcolAction.getProtocolActionTypeCode() != null) {
                actionTypeInfo.setActionTypeCode(new BigInteger(protcolAction.getProtocolActionTypeCode()));
                actionTypeInfo.setActionTypeDescription(protcolAction.getProtocolActionType().getDescription());
            }
            if (protcolAction.getActionDate() != null) {
                actionTypeInfo.setActionDate(this.getDateTimeService().getCalendar((Date)protcolAction.getActionDate()));
            }
            actionTypeInfo.setActionComments(protcolAction.getComments());
        }
    }

    protected ProtocolActionBase findProtocolActionForSubmission(IacucProtocolSubmission protocolSubmission) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("submissionIdFk", protocolSubmission.getSubmissionId());
        List actions = (List)this.getBusinessObjectService().findMatchingOrderBy(IacucProtocolAction.class, param, "actionId", true);
        return actions.isEmpty() ? null : (ProtocolActionBase)actions.get(0);
    }

    @Override
    public void setSubmissionCheckListinfo(ProtocolSubmissionBase protocolSubmission, SubmissionDetailsType protocolSubmissionDetail) {
        SubmissionDetailsType.SubmissionChecklistInfo submissionChecklistInfo = protocolSubmissionDetail.addNewSubmissionChecklistInfo();
        String formattedCode = new String();
    }

    @Override
    public void setMinutes(CommitteeScheduleBase scheduleDetailsBean, ScheduleType schedule) {
        List vecMinutes = scheduleDetailsBean.getCommitteeScheduleMinutes();
        if (!vecMinutes.isEmpty()) {
            for (CommitteeScheduleMinuteBase minuteEntryInfoBean : vecMinutes) {
                if (minuteEntryInfoBean.getMinuteEntryTypeCode().equals("3") || minuteEntryInfoBean.getPrivateCommentFlag() || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean) || minuteEntryInfoBean.getPrivateCommentFlag() || !minuteEntryInfoBean.isFinalFlag()) continue;
                MinuteType mt = schedule.insertNewMinutes(schedule.getMinutesArray().length);
                this.addMinute(scheduleDetailsBean, minuteEntryInfoBean, mt);
            }
        }
    }

    protected void addMinute(CommitteeScheduleBase committeeSchedule, CommitteeScheduleMinuteBase committeeScheduleMinute, MinuteType minutesType) {
        committeeScheduleMinute.refreshNonUpdateableReferences();
        minutesType.setScheduleId(committeeScheduleMinute.getScheduleIdFk().toString());
        minutesType.setEntryNumber(new BigInteger(String.valueOf(committeeScheduleMinute.getEntryNumber())));
        minutesType.setEntryTypeCode(new BigInteger(String.valueOf(committeeScheduleMinute.getMinuteEntryTypeCode())));
        minutesType.setEntryTypeDesc(committeeScheduleMinute.getMinuteEntryType().getDescription());
        minutesType.setProtocolContingencyCode(committeeScheduleMinute.getProtocolContingencyCode() != null ? committeeScheduleMinute.getProtocolContingencyCode() : null);
        minutesType.setMinuteEntry(committeeScheduleMinute.getMinuteEntry());
        minutesType.setPrivateCommentFlag(committeeScheduleMinute.getPrivateCommentFlag());
        committeeScheduleMinute.refreshReferenceObject("protocol");
        if (committeeScheduleMinute.getProtocol() != null && committeeScheduleMinute.getProtocol().getProtocolNumber() != null) {
            String otherItemDescription = this.getOtherItemDescription(committeeSchedule, committeeScheduleMinute);
            if (otherItemDescription != null) {
                minutesType.setProtocolNumber(otherItemDescription);
            } else {
                minutesType.setProtocolNumber(committeeScheduleMinute.getProtocol().getProtocolNumber());
            }
        }
        minutesType.setEntrySortCode(BigInteger.valueOf(committeeScheduleMinute.getMinuteEntryType().getSortId().intValue()));
        Calendar updateTime = Calendar.getInstance();
        updateTime.setTimeInMillis(committeeScheduleMinute.getUpdateTimestamp().getTime());
        minutesType.setUpdateTimestamp(updateTime);
        minutesType.setUpdateUser(committeeScheduleMinute.getUpdateUserFullName());
    }

    protected String getOtherItemDescription(CommitteeScheduleBase committeeSchedule, CommitteeScheduleMinuteBase committeeScheduleMinute) {
        List<CommScheduleActItemBase> actionItems = committeeSchedule.getCommScheduleActItems();
        for (CommScheduleActItemBase commScheduleActItem : actionItems) {
            if (!committeeScheduleMinute.getMinuteEntryTypeCode().equals("4") || !committeeScheduleMinute.getProtocol().getProtocolNumber().equals(commScheduleActItem.getActionItemNumber())) continue;
            return commScheduleActItem.getItemDescription();
        }
        return committeeScheduleMinute.getProtocol().getProtocolNumber();
    }

    @Override
    public void setProcotolMinutes(CommitteeScheduleBase committeeSchedule, ProtocolSubmissionBase protocolSubmission, ProtocolSubmissionType protocolSubmissionType) {
        List minutes = committeeSchedule.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinuteBase minuteEntryInfoBean : minutes) {
            ProtocolBase protocol = minuteEntryInfoBean.getProtocol();
            if (protocol == null || protocol.getProtocolNumber() == null || !protocol.getProtocolNumber().equals(protocolSubmission.getProtocolNumber()) || protocol.getProtocolSubmission() == null || !protocol.getProtocolSubmission().getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber()) || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean) || minuteEntryInfoBean.getPrivateCommentFlag() || !minuteEntryInfoBean.isFinalFlag()) continue;
            this.addMinute(committeeSchedule, minuteEntryInfoBean, protocolSubmissionType.addNewMinutes());
        }
    }

    @Override
    public void setProcotolSubmissionMinutes(CommitteeScheduleBase committeeSchedule, ProtocolSubmissionBase protocolSubmission, ProtocolType.Submissions submissionsType) {
        List minutes = committeeSchedule.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinuteBase minuteEntryInfoBean : minutes) {
            ProtocolBase protocol = minuteEntryInfoBean.getProtocol();
            if (protocol == null || protocol.getProtocolNumber() == null || !protocol.getProtocolNumber().equals(protocolSubmission.getProtocolNumber()) || protocol.getProtocolSubmission() == null || !protocol.getProtocolSubmission().getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber()) || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean)) continue;
            this.addMinute(committeeSchedule, minuteEntryInfoBean, submissionsType.addNewMinutes());
        }
    }

    @Override
    public void setProtocolReviewMinutes(CommitteeScheduleBase committeeSchedule, ProtocolSubmissionBase protocolSubmission, ProtocolType.Submissions submissionsType) {
        List minutes = committeeSchedule.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinuteBase minuteEntryInfoBean : minutes) {
            ProtocolBase protocol = minuteEntryInfoBean.getProtocol();
            if (protocol == null || protocol.getProtocolNumber() == null || !protocol.getProtocolNumber().equals(protocolSubmission.getProtocolNumber()) || protocol.getProtocolSubmission() == null || !protocol.getProtocolSubmission().getSubmissionNumber().equals(protocolSubmission.getSubmissionNumber()) || !this.reviewCommentsService.getReviewerCommentsView(minuteEntryInfoBean)) continue;
            this.addMinute(committeeSchedule, minuteEntryInfoBean, submissionsType.addNewMinutes());
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setReviewCommentsService(ReviewCommentsService reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }
}

