/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.noteattachment;

import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.actions.print.IacucProtocolPrintingService;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentPersonnel;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentProtocol;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.util.CollectionUtil;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class IacucProtocolNoteAndAttachmentAction
extends IacucProtocolAction {
    private static final String CONFIRM_NO_DELETE = "";
    private static final String NOT_FOUND_SELECTION = "the attachment was not found for selection ";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private static final Log LOG = LogFactory.getLog(IacucProtocolNoteAndAttachmentAction.class);
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String ATTACHMNENT_PATH = "document.protocolList[0].attachmentProtocols[";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().prepareView();
        return forward;
    }

    @Override
    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().processSave();
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().fixReloadedAttachments(request.getParameterMap());
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        if (!((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete());
            ((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete().clear();
        }
        for (ProtocolPersonBase person : ((ProtocolFormBase)form).getProtocolDocument().getProtocol().getProtocolPersons()) {
            person.refreshReferenceObject("attachmentPersonnels");
        }
        for (ProtocolAttachmentProtocolBase attachment : ((ProtocolFormBase)form).getProtocolDocument().getProtocol().getAttachmentProtocols()) {
            attachment.getProtocol().refreshReferenceObject("attachmentProtocols");
        }
        for (ProtocolNotepadBase notepad : ((ProtocolFormBase)form).getProtocolDocument().getProtocol().getNotepads()) {
            notepad.setEditable(false);
        }
    }

    public ActionForward addAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().addNewProtocolAttachmentProtocol();
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (ProtocolFormBase)form, request, response);
    }

    private ActionForward deleteAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response, Class<? extends ProtocolAttachmentBase> attachmentType) throws Exception {
        int selection = this.getSelectedLine(request);
        if (!form.getNotesAttachmentsHelper().deleteExistingAttachmentByType(selection, attachmentType)) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        IacucProtocolAttachmentProtocol attachment = ((ProtocolFormBase)form).getNotesAttachmentsHelper().retrieveExistingAttachmentByType(selection, IacucProtocolAttachmentProtocol.class);
        if (this.isValidContactData(attachment, ATTACHMNENT_PATH + selection + "]")) {
            return this.confirmDeleteAttachment(mapping, (ProtocolFormBase)form, request, response, IacucProtocolAttachmentProtocol.class);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAttachmentPersonnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirmDeleteAttachment(mapping, (ProtocolFormBase)form, request, response, IacucProtocolAttachmentPersonnel.class);
    }

    public ActionForward confirmDeleteAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.deleteAttachment(mapping, (ProtocolFormBase)form, request, response, IacucProtocolAttachmentProtocol.class);
    }

    private ActionForward viewAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolAttachmentProtocolBase attachment = CollectionUtil.getFromList(selection, form.getProtocolDocument().getProtocol().getAttachmentProtocols());
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        byte[] attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_DELETE);
        if ((attachmentFileType = attachmentFileType.replace("\\", CONFIRM_NO_DELETE)).equalsIgnoreCase("application/pdf")) {
            attachmentFile = this.getProtocolAttachmentFile(form, attachment);
            if (attachmentFile != null) {
                this.streamToResponse(attachmentFile, IacucProtocolNoteAndAttachmentAction.getValidHeaderString(file.getName()), IacucProtocolNoteAndAttachmentAction.getValidHeaderString(file.getType()), response);
            } else {
                this.streamToResponse(file.getData(), IacucProtocolNoteAndAttachmentAction.getValidHeaderString(file.getName()), IacucProtocolNoteAndAttachmentAction.getValidHeaderString(file.getType()), response);
            }
            return RESPONSE_ALREADY_HANDLED;
        }
        this.streamToResponse(file.getData(), IacucProtocolNoteAndAttachmentAction.getValidHeaderString(file.getName()), IacucProtocolNoteAndAttachmentAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private boolean isValidContactData(ProtocolAttachmentBase attachment, String errorPath) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(errorPath);
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)attachment);
        errorMap.removeFromErrorPath(errorPath);
        return errorMap.hasNoErrors();
    }

    private ActionForward confirmDeleteAttachment(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response, Class<? extends ProtocolAttachmentBase> attachmentType) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolAttachmentBase attachment = form.getNotesAttachmentsHelper().retrieveExistingAttachmentByType(selection, attachmentType);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
            return mapping.findForward("basic");
        }
        String confirmMethod = form.getNotesAttachmentsHelper().retrieveConfirmMethodByType(attachmentType);
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, confirmMethod, "document.question.deleteAttachment.text", attachment.getAttachmentDescription(), attachment.getFile().getName());
        return this.confirm(confirm, confirmMethod, CONFIRM_NO_DELETE);
    }

    private byte[] getProtocolAttachmentFile(ProtocolFormBase form, ProtocolAttachmentProtocolBase attachment) {
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getProtocolPrintingService().getProtocolPrintArtifacts(form.getProtocolDocument().getProtocol());
        ProtocolBase protocolCurrent = form.getProtocolDocument().getProtocol();
        int currentProtoSeqNumber = protocolCurrent.getSequenceNumber();
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                int currentAttachmentSequence = attachment.getSequenceNumber();
                String docStatusCode = attachment.getDocumentStatusCode();
                String statusCode = attachment.getStatusCode();
                if (this.getProtocolAttachmentService().isAttachmentActive(attachment) && currentProtoSeqNumber == currentAttachmentSequence || docStatusCode.equals("1")) {
                    if ("1".equals(statusCode)) {
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getInvalidWatermark());
                    LOG.info((Object)(INVALID_ATTACHMENT + attachment.getDocumentId()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured in ProtocolNoteAndAttachmentAction. : ", (Throwable)e);
        }
        return attachmentFile;
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().addNewNote();
        return mapping.findForward("basic");
    }

    public ActionForward editNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().modifyNote(selection);
        return mapping.findForward("basic");
    }

    public ActionForward deleteNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirmDeleteNote(mapping, (ProtocolFormBase)form, request, response);
    }

    public ActionForward deleteNoteConfirmed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        if (!((ProtocolFormBase)form).getNotesAttachmentsHelper().deleteNote(selection)) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
        }
        return mapping.findForward("basic");
    }

    private ActionForward confirmDeleteNote(ActionMapping mapping, ProtocolFormBase form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        String confirmMethod = "deleteNoteConfirmed";
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, "deleteNoteConfirmed", "document.question.deleteNote.text", new String[0]);
        return this.confirm(confirm, "deleteNoteConfirmed", CONFIRM_NO_DELETE);
    }

    public ActionForward updateAttachmentFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProtocolFormBase)form).getNotesAttachmentsHelper().addNewProtocolAttachmentFilter();
        return mapping.findForward("basic");
    }

    protected static String getValidHeaderString(String s) {
        return MimeUtility.quote((String)s, (String)"()<>@,;:\\\"\t []/?=");
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }

    private WatermarkService getWatermarkService() {
        return KraServiceLocator.getService(WatermarkService.class);
    }

    private IacucProtocolPrintingService getProtocolPrintingService() {
        return KraServiceLocator.getService(IacucProtocolPrintingService.class);
    }

    private ProtocolAttachmentService getProtocolAttachmentService() {
        return (ProtocolAttachmentService)KraServiceLocator.getService("iacucProtocolAttachmentService");
    }
}

