/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.notification;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.notification.bo.NotificationModuleRoleQualifier;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRoleQualifierService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRoleQualifierServiceImpl;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;

public class IacucProtocolNotificationRoleQualifierServiceImpl
extends ProtocolNotificationRoleQualifierServiceImpl
implements IacucProtocolNotificationRoleQualifierService {
    private ProtocolBase protocol;
    private ProtocolOnlineReviewBase protocolOnlineReview;

    @Override
    public String getRoleQualifierValue(NotificationModuleRoleQualifier qualifier) {
        String roleQualifierValue = null;
        String qName = qualifier.getQualifier();
        if (StringUtils.equalsIgnoreCase((String)qName, (String)"unitNumber") || StringUtils.equalsIgnoreCase((String)qName, (String)"protocolLeadUnitNumber")) {
            roleQualifierValue = this.getProtocol().getLeadUnitNumber();
        } else if (StringUtils.equalsIgnoreCase((String)qName, (String)"protocol")) {
            roleQualifierValue = this.getProtocol().getProtocolNumber();
        } else if (StringUtils.equalsIgnoreCase((String)qName, (String)"subunits")) {
            roleQualifierValue = "Y";
        } else if (StringUtils.equalsIgnoreCase((String)qName, (String)"submissionId")) {
            if (this.getProtocol().getProtocolSubmission() != null) {
                roleQualifierValue = this.getProtocol().getProtocolSubmission().getSubmissionId().toString();
            }
        } else if (StringUtils.equals((String)qName, (String)"protocolOnlineReviewId") && this.protocolOnlineReview != null) {
            roleQualifierValue = this.protocolOnlineReview.getProtocolOnlineReviewId().toString();
        }
        return roleQualifierValue;
    }

    @Override
    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    @Override
    public ProtocolOnlineReviewBase getProtocolOnlineReview() {
        return this.protocolOnlineReview;
    }

    @Override
    public void setProtocolOnlineReview(ProtocolOnlineReviewBase protocolOnlineReview) {
        this.protocolOnlineReview = protocolOnlineReview;
    }
}

