/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.authorization;

import org.apache.log4j.Logger;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewAuthorizer;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ModifyIacucProtocolOnlineReviewAuthorizer
extends IacucProtocolOnlineReviewAuthorizer {
    private static final Logger LOG = Logger.getLogger(ModifyIacucProtocolOnlineReviewAuthorizer.class);

    @Override
    public boolean isAuthorized(String userId, IacucProtocolOnlineReviewTask task) {
        boolean hasPermission = true;
        ProtocolOnlineReviewBase protocolOnlineReview = task.getProtocolOnlineReview();
        ProtocolOnlineReviewDocumentBase protocolDoc = null;
        try {
            protocolDoc = (ProtocolOnlineReviewDocumentBase)KraServiceLocator.getService(DocumentService.class).getByDocumentHeaderId(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
        }
        catch (WorkflowException e) {
            LOG.error((Object)String.format("Could not find ProtocolOnlineReviewBase, document number %s", protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber()));
            return false;
        }
        if (protocolOnlineReview.getProtocolOnlineReviewId() == null) {
            return false;
        }
        hasPermission = !protocolOnlineReview.getProtocolOnlineReviewDocument().isViewOnly() && (this.hasPermission(userId, protocolOnlineReview, "Maintain IACUC Protocol Online Reviews") && this.kraWorkflowService.isEnRoute((Document)protocolDoc) || this.hasPermission(userId, protocolOnlineReview, "Maintain IACUC Protocol Online Review Comments") && this.kraWorkflowService.isUserApprovalRequested((Document)protocolDoc, userId));
        return hasPermission;
    }
}

