/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.permission;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.protocol.permission.PermissionsHelperBase;

public class IacucPermissionsHelper
extends PermissionsHelperBase {
    private static final long serialVersionUID = 3601806102887965826L;
    private static final Log LOG = LogFactory.getLog(IacucPermissionsHelper.class);

    public IacucPermissionsHelper(IacucProtocolForm form) {
        super(form, "KC-IACUC");
        this.form = form;
    }

    @Override
    protected void buildDisplayNameMap() {
        if (this.displayNameMap == null) {
            this.displayNameMap = new HashMap();
            this.displayNameMap.put("IACUC Protocol Aggregator", "Aggregator");
            this.displayNameMap.put("IACUC Protocol Viewer", "Viewer");
            this.displayNameMap.put("IACUC Protocol Unassigned", "unassigned");
        }
    }

    @Override
    protected boolean isStandardRoleName(String roleName) {
        return StringUtils.equals((String)roleName, (String)"IACUC Protocol Aggregator") || StringUtils.equals((String)roleName, (String)"IACUC Protocol Viewer");
    }

    @Override
    public boolean canModifyPermissions() {
        IacucProtocolTask task = new IacucProtocolTask("modifyIacucProtocolRoles", (IacucProtocol)this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    @Override
    protected void initExcludedRolesHook() {
        if (this.excludeRoles == null) {
            this.excludeRoles = new HashSet();
        }
        this.excludeRoles.add("IACUC ProtocolApprover");
        this.excludeRoles.add("IACUC Protocol Unassigned");
        this.excludeRoles.add("Modify IACUC Protocols");
        this.excludeRoles.add("Active IACUC Committee Member");
        this.excludeRoles.add("Active IACUC Committee Member on Protocol");
        this.excludeRoles.add("Active IACUC Committee Member on Scheduled Date");
        this.excludeRoles.add("IACUC Protocol Creator");
        this.excludeRoles.add("IACUC Protocol Deleter");
    }
}

