/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.personnel;

import java.util.List;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.personnel.DeleteIacucProtocolPersonnelEvent;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelRuleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.rule.BusinessRuleInterface;

public class DeleteIacucProtocolPersonnelRule
extends ProtocolPersonnelRuleBase
implements BusinessRuleInterface<DeleteIacucProtocolPersonnelEvent> {
    @Override
    public boolean processRules(DeleteIacucProtocolPersonnelEvent event) {
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)event.getDocument();
        return this.isPersonDeleteValid(protocolDocument);
    }

    @Override
    public ProtocolPersonnelService getProtocolPersonnelServiceHook() {
        return (ProtocolPersonnelService)KraServiceLocator.getService("iacucProtocolPersonnelService");
    }

    private boolean isPersonDeleteValid(IacucProtocolDocument protocolDocument) {
        boolean personDeleteValid = true;
        List<ProtocolPersonBase> protocolPersons = protocolDocument.getIacucProtocol().getProtocolPersons();
        List<IacucProtocolStudyGroupBean> protocolStudyGroups = protocolDocument.getIacucProtocol().getIacucProtocolStudyGroups();
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!protocolPerson.isDelete()) continue;
            int personIndex = protocolPersons.indexOf(protocolPerson);
            String personId = protocolPerson.getPersonId();
            if (!this.isPersonHandlingProcedure(personId, protocolStudyGroups)) continue;
            this.reportError(this.formatErrorPropertyName(false, personIndex, ""), "error.iacuc.protocol.person.dependency.exists", new String[0]);
            personDeleteValid = false;
        }
        return personDeleteValid;
    }

    private boolean isPersonHandlingProcedure(String personId, List<IacucProtocolStudyGroupBean> protocolStudyGroups) {
        boolean personHandlingProcedure = false;
        for (IacucProtocolStudyGroupBean studyGroupBean : protocolStudyGroups) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                block2: for (IacucProtocolStudyGroup studyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    for (IacucProcedurePersonResponsible procedurePerson : studyGroup.getIacucProcedurePersonsResponsible()) {
                        if (!procedurePerson.getPersonId().equals(personId)) continue;
                        personHandlingProcedure = true;
                        continue block2;
                    }
                }
            }
        }
        return personHandlingProcedure;
    }
}

