/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.personnel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.noteattachment.IacucProtocolAttachmentPersonnel;
import org.kuali.kra.iacuc.personnel.AddIacucProtocolAttachmentPersonnelEvent;
import org.kuali.kra.iacuc.personnel.AddIacucProtocolPersonnelEvent;
import org.kuali.kra.iacuc.personnel.DeleteIacucProtocolPersonnelEvent;
import org.kuali.kra.iacuc.personnel.IacucProtocolPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.personnel.AddProtocolUnitEvent;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public class IacucProtocolPersonnelAction
extends IacucProtocolAction {
    private static final Log LOG = LogFactory.getLog(IacucProtocolPersonnelAction.class);
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL = "confirmDeleteAttachmentPersonnel";
    private static final String CONFIRM_NO_DELETE = "";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private ProtocolAttachmentService protocolAttachmentService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        this.getProtocolPersonnelService().selectProtocolUnit(this.getProtocolPersons(form));
        ((ProtocolFormBase)form).getPersonnelHelper().prepareView();
        return actionForward;
    }

    public ActionForward addProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        IacucProtocolPerson newProtocolPerson = (IacucProtocolPerson)protocolForm.getPersonnelHelper().getNewProtocolPerson();
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new AddIacucProtocolPersonnelEvent(CONFIRM_NO_DELETE, protocolForm.getProtocolDocument(), newProtocolPerson));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPerson(protocol, newProtocolPerson);
            if (StringUtils.equals((String)newProtocolPerson.getProtocolPersonRoleId(), (String)"PI")) {
                protocolForm.getProtocolHelper().setPersonId(newProtocolPerson.getPersonId());
            }
            protocolForm.getPersonnelHelper().setNewProtocolPerson(new IacucProtocolPerson());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new DeleteIacucProtocolPersonnelEvent(CONFIRM_NO_DELETE, (IacucProtocolDocument)protocolDocument));
        if (rulePassed) {
            this.getProtocolPersonnelService().deleteProtocolPerson(protocolDocument.getProtocol());
        }
        return mapping.findForward("basic");
    }

    public ActionForward clearProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getPersonnelHelper().setNewProtocolPerson(new IacucProtocolPerson());
        return mapping.findForward("basic");
    }

    public ActionForward addPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        ProtocolPersonBase protocolPerson = protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex);
        ProtocolAttachmentPersonnelBase newAttachmentPersonnel = protocolForm.getPersonnelHelper().getNewProtocolAttachmentPersonnels().get(selectedPersonIndex);
        newAttachmentPersonnel.setPersonId(protocolPerson.getProtocolPersonId());
        newAttachmentPersonnel.setProtocolNumber(protocolPerson.getProtocolNumber());
        boolean rulePassed = this.applyRules((KualiDocumentEvent)new AddIacucProtocolAttachmentPersonnelEvent(CONFIRM_NO_DELETE, protocolForm.getProtocolDocument(), newAttachmentPersonnel, selectedPersonIndex));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPersonAttachment(protocolDocument.getProtocol(), newAttachmentPersonnel, selectedPersonIndex);
            protocolForm.getPersonnelHelper().getNewProtocolAttachmentPersonnels().set(selectedPersonIndex, new IacucProtocolAttachmentPersonnel());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        ProtocolPersonBase protocolPerson = protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentBase attachment = protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        return this.printAttachmentProtocol(mapping, protocolForm, response, attachment);
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, ProtocolFormBase form, HttpServletResponse response, ProtocolAttachmentBase attachment) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), IacucProtocolPersonnelAction.getValidHeaderString(file.getName()), IacucProtocolPersonnelAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deletePersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocumentBase protocolDocument = ((ProtocolFormBase)form).getProtocolDocument();
        ProtocolPersonBase protocolPerson = protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentPersonnelBase attachment = protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL, "document.question.deleteAttachment.text", attachment.getAttachmentDescription(), attachment.getFile().getName());
        return this.confirm(confirm, CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL, CONFIRM_NO_DELETE);
    }

    public ActionForward confirmDeleteAttachmentPersonnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocumentBase protocolDocument = ((ProtocolFormBase)form).getProtocolDocument();
        ProtocolPersonBase protocolPerson = protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentPersonnelBase attachment = protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        if (attachment.getFileId() != null && !this.getProtocolAttachmentService().isSharedFile(attachment)) {
            ((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete().add(attachment.getFile());
        }
        protocolPerson.getAttachmentPersonnels().remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward addProtocolPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        ProtocolPersonBase protocolPerson = protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex);
        ProtocolUnitBase newProtocolPersonUnit = protocolForm.getPersonnelHelper().getNewProtocolPersonUnits().get(selectedPersonIndex);
        boolean rulePassed = this.applyRules(new AddProtocolUnitEvent(CONFIRM_NO_DELETE, protocolForm.getProtocolDocument(), newProtocolPersonUnit, selectedPersonIndex));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPersonUnit(protocolForm.getPersonnelHelper().getNewProtocolPersonUnits(), protocolPerson, selectedPersonIndex);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        this.getProtocolPersonnelService().deleteProtocolPersonUnit(protocolDocument.getProtocol(), selectedPersonIndex, this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward updateProtocolPersonView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        this.getProtocolPersonnelService().switchInvestigatorCoInvestigatorRole(protocolDocument.getProtocol().getProtocolPersons());
        this.getProtocolPersonnelService().syncPersonRoleAndUnit(protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex));
        this.getProtocolPersonnelService().syncPersonRoleAndAffiliation(protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex));
        return mapping.findForward("basic");
    }

    protected int getSelectedPersonIndex(HttpServletRequest request, ProtocolDocumentBase document) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"protocolPersons[", (String)"]."));
        }
        return selectedPersonIndex;
    }

    private List<ProtocolPersonBase> getProtocolPersons(ActionForm form) {
        return ((ProtocolFormBase)form).getProtocolDocument().getProtocol().getProtocolPersons();
    }

    @Override
    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            KraAuthorizationService kraAuthService;
            String personComparator;
            String string = personComparator = protocolPerson.getPersonId() != null ? protocolPerson.getPersonId() : protocolPerson.getRolodexId().toString();
            if (protocolPerson.isPrincipalInvestigator() && !personComparator.equals(protocol.getPrincipalInvestigatorId())) {
                protocol.setPrincipalInvestigatorId(null);
                if (protocolPerson.getPersonId() == null) continue;
                kraAuthService = this.getKraAuthorizationService();
                kraAuthService.addRole(protocolPerson.getPersonId(), "IACUC Protocol Aggregator", protocol);
                kraAuthService.addRole(protocolPerson.getPersonId(), "IACUC ProtocolApprover", protocol);
                protocolForm.getPermissionsHelper().resetUserStates();
                continue;
            }
            if (protocolPerson.isPrincipalInvestigator() || StringUtils.equals((String)protocolPerson.getPersonId(), (String)protocol.getPrincipalInvestigatorId()) || protocolPerson.getPersonId() == null) continue;
            kraAuthService = KraServiceLocator.getService(KraAuthorizationService.class);
            kraAuthService.addRole(protocolPerson.getPersonId(), "IACUC Protocol Viewer", protocol);
            protocolForm.getPermissionsHelper().resetUserStates();
        }
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("protocolNumber", protocol.getProtocolNumber());
        keyMap.put("sequenceNumber", protocol.getSequenceNumber());
        List attachments = (List)this.getBusinessObjectService().findMatching(IacucProtocolAttachmentPersonnel.class, keyMap);
        ArrayList<AttachmentFile> filesToDelete = new ArrayList<AttachmentFile>();
        ArrayList<Long> attachmentIds = new ArrayList<Long>();
        for (ProtocolAttachmentPersonnelBase attachment : protocol.getAttachmentPersonnels()) {
            if (attachment.getId() == null) continue;
            attachmentIds.add(attachment.getId());
        }
        for (ProtocolAttachmentPersonnelBase attachment : attachments) {
            if (attachmentIds.contains(attachment.getId()) || this.getProtocolAttachmentService().isSharedFile(attachment)) continue;
            filesToDelete.add(attachment.getFile());
        }
        protocolForm.getNotesAttachmentsHelper().setFilesToDelete(filesToDelete);
    }

    private ProtocolAttachmentService getProtocolAttachmentService() {
        if (this.protocolAttachmentService == null) {
            this.protocolAttachmentService = (ProtocolAttachmentService)KraServiceLocator.getService("iacucProtocolAttachmentService");
        }
        return this.protocolAttachmentService;
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        if (!((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete());
            ((ProtocolFormBase)form).getNotesAttachmentsHelper().getFilesToDelete().clear();
        }
    }
}

