/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.protocol.ProtocolAssociateBase;

public class IacucProcedurePersonResponsible
extends ProtocolAssociateBase {
    private static final long serialVersionUID = 1L;
    private Integer iacucProcedurePersonResponsibleId;
    private Integer iacucProtocolStudyGroupId;
    private String personId;
    private String personName;
    private String personResponsibleDescription;
    private List<String> trainingDetails;
    private List<String> protocolPersonsResponsible;
    private IacucProtocolStudyGroup iacucProtocolStudyGroup;
    private List<IacucPersonTraining> trainings;

    public IacucProcedurePersonResponsible() {
        this.setProtocolPersonsResponsible(new ArrayList<String>());
    }

    public Integer getIacucProcedurePersonResponsibleId() {
        return this.iacucProcedurePersonResponsibleId;
    }

    public void setIacucProcedurePersonResponsibleId(Integer iacucProcedurePersonResponsibleId) {
        this.iacucProcedurePersonResponsibleId = iacucProcedurePersonResponsibleId;
    }

    public Integer getIacucProtocolStudyGroupId() {
        return this.iacucProtocolStudyGroupId;
    }

    public void setIacucProtocolStudyGroupId(Integer iacucProtocolStudyGroupId) {
        this.iacucProtocolStudyGroupId = iacucProtocolStudyGroupId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public IacucProtocolStudyGroup getIacucProtocolStudyGroup() {
        return this.iacucProtocolStudyGroup;
    }

    public void setIacucProtocolStudyGroup(IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        this.iacucProtocolStudyGroup = iacucProtocolStudyGroup;
    }

    @Override
    public void resetPersistenceState() {
        this.setIacucProcedurePersonResponsibleId(null);
    }

    public List<IacucPersonTraining> getTrainings() {
        return this.trainings;
    }

    public void setTrainings(List<IacucPersonTraining> trainings) {
        this.trainings = trainings;
    }

    public String getTrainingDetailsString() {
        String details = new String();
        boolean first = true;
        for (String detail : this.getTrainingDetails()) {
            if (!first) {
                details = details + "<br/>";
            }
            details = details + detail;
            first = false;
        }
        return details;
    }

    public List<String> getTrainingDetails() {
        this.trainingDetails = new ArrayList<String>();
        if (this.getTrainings() != null) {
            for (IacucPersonTraining iacucPersonTraining : this.getTrainings()) {
                StringBuffer trainingInfo = new StringBuffer();
                trainingInfo.append("Training : " + iacucPersonTraining.getPersonTraining().getTraining().getDescription());
                trainingInfo.append("\r\nSpecies : " + iacucPersonTraining.getIacucSpecies().getSpeciesName());
                trainingInfo.append("\r\nProcedure : " + iacucPersonTraining.getIacucProcedure().getProcedureDescription());
                trainingInfo.append("\r\n");
                this.trainingDetails.add(trainingInfo.toString());
            }
        }
        return this.trainingDetails;
    }

    public String getPersonResponsibleDescription() {
        if (this.personResponsibleDescription == null) {
            this.refreshReferenceObject("personResponsibleDescription");
        }
        return this.personResponsibleDescription;
    }

    public void setPersonResponsibleDescription(String personResponsibleDescription) {
        this.personResponsibleDescription = personResponsibleDescription;
    }

    public List<String> getProtocolPersonsResponsible() {
        return this.protocolPersonsResponsible;
    }

    public void setProtocolPersonsResponsible(List<String> protocolPersonsResponsible) {
        this.protocolPersonsResponsible = protocolPersonsResponsible;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IacucProcedurePersonResponsible other = (IacucProcedurePersonResponsible)obj;
        if (this.iacucProtocolStudyGroupId == null ? other.iacucProtocolStudyGroupId != null : !this.iacucProtocolStudyGroupId.equals(other.iacucProtocolStudyGroupId)) {
            return false;
        }
        return !(this.personId == null ? other.personId != null : !this.personId.equals(other.personId));
    }
}

