/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.kuali.kra.iacuc.IacucPainCategory;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.kra.iacuc.IacucProcedureCategoryCustomData;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.IacucSpecies;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonTrainingService;
import org.kuali.kra.iacuc.procedures.IacucProcedure;
import org.kuali.kra.iacuc.procedures.IacucProcedureCategory;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyCustomData;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroup;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolProcedureServiceImpl
implements IacucProtocolProcedureService {
    private BusinessObjectService businessObjectService;
    private IacucProtocolPersonTrainingService iacucProtocolPersonTrainingService;
    private static final String PROTOCOL_STUDY_GROUP_SEQUENCE_ID = "SEQ_IACUC_PROTO_STUDY_GROUP_ID";
    private static final String PROTOCOL_PERSON_RESPONSIBLE_SEQUENCE_ID = "SEQ_IACUC_PROC_PERS_RESP_ID";
    private static final String PROTOCOL_STUDY_GROUP_LOCATION_SEQUENCE_ID = "SEQ_IACUC_PROT_STUD_GRP_LOC_ID";
    private static final String PROTOCOL_STUDY_GROUP_CUSTOM_DATA_SEQUENCE_ID = "SEQ_IACUC_PROT_STUD_CUS_DAT_ID";
    private static final String PROTOCOL_STUDY_GROUP_HEADER_SEQUENCE_ID = "SEQ_IACUC_PROT_STUD_GRP_HDR_ID";
    private static final String PROTOCOL_STUDY_GROUP_DETAIL_SEQUENCE_ID = "SEQ_IACUC_PROT_STUD_GRP_DTL_ID";
    private IacucProtocolSpeciesService iacucProtocolSpeciesService;
    private SequenceAccessorService sequenceAccessorService;

    @Override
    public List<IacucProcedure> getAllProcedures() {
        return (List)this.getBusinessObjectService().findAllOrderBy(IacucProcedure.class, "procedureCategoryCode", true);
    }

    @Override
    public List<IacucProcedureCategory> getAllProcedureCategories() {
        return (List)this.getBusinessObjectService().findAllOrderBy(IacucProcedureCategory.class, "procedureCategoryCode", true);
    }

    @Override
    public List<IacucProtocolSpecies> getProtocolSpecies() {
        Long protocolId = ((IacucProtocolForm)KNSGlobalVariables.getKualiForm()).getIacucProtocolDocument().getProtocol().getProtocolId();
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("protocolId", protocolId);
        return (List)this.getBusinessObjectService().findMatching(IacucProtocolSpecies.class, keyMap);
    }

    @Override
    public void createNewStudyGroups(IacucProtocol iacucProtocol, List<IacucProtocolStudyGroupBean> sourceStudyGroupBeans, HashMap<Integer, Integer> protocolSpeciesIdMapping) {
        iacucProtocol.setIacucProtocolStudyGroupBeans(new ArrayList<IacucProtocolStudyGroupBean>());
        iacucProtocol.setIacucProtocolStudyGroups(new ArrayList<IacucProtocolStudyGroupBean>());
        for (IacucProtocolStudyGroupBean studyGroupBean : sourceStudyGroupBeans) {
            IacucProtocolStudyGroupBean newStudyGroupBean = this.getNewCopyOfStudyGroupBean(studyGroupBean);
            newStudyGroupBean.setIacucProtocolStudyGroupDetailBeans(new ArrayList<IacucProtocolStudyGroupDetailBean>());
            this.setAttributesForNewStudyGroupBean(newStudyGroupBean, iacucProtocol);
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                IacucProtocolStudyGroupDetailBean newStudyGroupDetailBean = this.getNewCopyOfStudyGroupDetailBean(studyGroupDetailBean);
                newStudyGroupDetailBean.setIacucProtocolStudyCustomDataList(new ArrayList<IacucProtocolStudyCustomData>());
                newStudyGroupDetailBean.setIacucProcedurePersonsResponsible(new ArrayList<IacucProcedurePersonResponsible>());
                newStudyGroupDetailBean.setIacucProtocolStudyGroupLocations(new ArrayList<IacucProtocolStudyGroupLocation>());
                newStudyGroupDetailBean.setIacucProtocolStudyGroupDetailId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_DETAIL_SEQUENCE_ID));
                newStudyGroupDetailBean.setIacucProtocolStudyGroupHeaderId(newStudyGroupBean.getIacucProtocolStudyGroupHeaderId());
                ArrayList<IacucProtocolStudyGroup> studyGroups = new ArrayList<IacucProtocolStudyGroup>();
                for (IacucProtocolStudyGroup protocolStudyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    IacucProtocolStudyGroup newProtocolStudyGroup = this.getNewCopyOfProtocolStudyGroup(protocolStudyGroup);
                    newProtocolStudyGroup.setIacucProtocolStudyCustomDataList(new ArrayList<IacucProtocolStudyCustomData>());
                    newProtocolStudyGroup.setIacucProcedurePersonsResponsible(new ArrayList<IacucProcedurePersonResponsible>());
                    newProtocolStudyGroup.setIacucProtocolStudyGroupLocations(new ArrayList<IacucProtocolStudyGroupLocation>());
                    this.setAttributesForNewProtocolStudyGroup(newProtocolStudyGroup, newStudyGroupDetailBean, iacucProtocol);
                    Integer newProtocolSpeciesId = protocolSpeciesIdMapping.get(newProtocolStudyGroup.getIacucProtocolSpeciesId());
                    if (newProtocolSpeciesId == null) {
                        newProtocolSpeciesId = newProtocolStudyGroup.getIacucProtocolSpeciesId();
                    }
                    newProtocolStudyGroup.setIacucProtocolSpeciesId(newProtocolSpeciesId);
                    studyGroups.add(newProtocolStudyGroup);
                    for (IacucProcedurePersonResponsible procedurePersonResponsible : protocolStudyGroup.getIacucProcedurePersonsResponsible()) {
                        IacucProcedurePersonResponsible newPersonResponsible = this.getNewCopyOfPersonResponsible(procedurePersonResponsible);
                        this.setAttributesForNewProcedurePersonResponsible(newPersonResponsible, newProtocolStudyGroup, newStudyGroupBean);
                        newProtocolStudyGroup.getIacucProcedurePersonsResponsible().add(newPersonResponsible);
                    }
                    for (IacucProtocolStudyGroupLocation studyGroupLocation : protocolStudyGroup.getIacucProtocolStudyGroupLocations()) {
                        IacucProtocolStudyGroupLocation newStudyGroupLocation = this.getNewCopyOfStudyGroupLocation(studyGroupLocation);
                        this.updateAttributesForNewProcedureLocation(newStudyGroupLocation, newProtocolStudyGroup, iacucProtocol);
                        newProtocolStudyGroup.getIacucProtocolStudyGroupLocations().add(newStudyGroupLocation);
                    }
                    for (IacucProtocolStudyCustomData studyGroupCustomData : protocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                        IacucProtocolStudyCustomData newStudyCustomData = this.getNewCopyOfStudyCustomData(studyGroupCustomData);
                        this.updateAttributesForNewProcedureCustomData(newStudyCustomData, iacucProtocol, newProtocolStudyGroup);
                        newProtocolStudyGroup.getIacucProtocolStudyCustomDataList().add(newStudyCustomData);
                    }
                }
                newStudyGroupDetailBean.setIacucProtocolStudyGroups(studyGroups);
                newStudyGroupBean.getIacucProtocolStudyGroupDetailBeans().add(newStudyGroupDetailBean);
            }
            iacucProtocol.getIacucProtocolStudyGroups().add(newStudyGroupBean);
        }
    }

    @Override
    public void addProtocolStudyGroup(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocol iacucProtocol) {
        boolean isNewCategoryBean = ObjectUtils.isNull((Object)selectedProtocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId());
        List<String> protocolSpeciesAndGroups = selectedProtocolStudyGroupBean.getProtocolSpeciesAndGroups();
        List<String> protocolPersonsResponsible = selectedProtocolStudyGroupBean.getProtocolPersonsResponsible();
        if (isNewCategoryBean) {
            this.setAttributesForNewStudyGroupBean(selectedProtocolStudyGroupBean, iacucProtocol);
        }
        List<IacucProtocolStudyGroupDetailBean> newDetailBeans = this.addStudyGroupBeans(protocolSpeciesAndGroups, selectedProtocolStudyGroupBean, iacucProtocol);
        List<IacucProcedurePersonResponsible> procedurePersonsResponsible = this.addPersonsResponsible(protocolPersonsResponsible);
        this.addPersonToDetailBean(newDetailBeans, procedurePersonsResponsible, selectedProtocolStudyGroupBean, iacucProtocol);
        this.addProcedureCustomData(selectedProtocolStudyGroupBean, newDetailBeans, iacucProtocol);
        if (isNewCategoryBean) {
            iacucProtocol.getIacucProtocolStudyGroups().add(selectedProtocolStudyGroupBean);
        } else {
            IacucProtocolStudyGroupBean selectedProtocolStudyGroup = this.getProtocolStudyGroup(iacucProtocol, selectedProtocolStudyGroupBean);
            selectedProtocolStudyGroup.getIacucProtocolStudyGroupDetailBeans().addAll(this.getAllDetailBeansThatDoesNotExist(newDetailBeans, selectedProtocolStudyGroup));
        }
    }

    private List<IacucProtocolStudyGroupDetailBean> getAllDetailBeansThatDoesNotExist(List<IacucProtocolStudyGroupDetailBean> newDetailBeans, IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean) {
        ArrayList<IacucProtocolStudyGroupDetailBean> newBeansToAdd = new ArrayList<IacucProtocolStudyGroupDetailBean>();
        newBeansToAdd.addAll(newDetailBeans);
        newBeansToAdd.removeAll(iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans());
        return newBeansToAdd;
    }

    @Override
    public void deleteProtocolStudyGroup(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocolStudyGroupDetailBean selectedProcedureDetailBean, IacucProtocol iacucProtocol) {
        selectedProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans().remove((Object)selectedProcedureDetailBean);
        IacucProtocolStudyGroupBean selectedProtocolStudyGroup = this.getProtocolStudyGroup(iacucProtocol, selectedProtocolStudyGroupBean);
        if (selectedProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans().size() == 0) {
            iacucProtocol.getIacucProtocolStudyGroups().remove(selectedProtocolStudyGroup);
            selectedProtocolStudyGroupBean.setIacucProtocolStudyGroupHeaderId(null);
        } else {
            selectedProtocolStudyGroup.getIacucProtocolStudyGroupDetailBeans().remove((Object)selectedProcedureDetailBean);
        }
    }

    @Override
    public void deleteProcedurePersonResponsible(IacucProtocolStudyGroupDetailBean selectedProcedureDetailBean, IacucProcedurePersonResponsible selectedPersonResponsible, IacucProtocol iacucProtocol) {
        for (IacucProtocolStudyGroup beanProtocolStudyGroup : selectedProcedureDetailBean.getIacucProtocolStudyGroups()) {
            beanProtocolStudyGroup.getIacucProcedurePersonsResponsible().remove(selectedPersonResponsible);
        }
        selectedProcedureDetailBean.getIacucProcedurePersonsResponsible().remove(selectedPersonResponsible);
    }

    @Override
    public void deleteStudyGroupLocation(IacucProtocolStudyGroupDetailBean selectedProcedureDetailBean, IacucProtocolStudyGroupLocation selectedStudyGroupLocation, IacucProtocol iacucProtocol) {
        for (IacucProtocolStudyGroup beanProtocolStudyGroup : selectedProcedureDetailBean.getIacucProtocolStudyGroups()) {
            beanProtocolStudyGroup.getIacucProtocolStudyGroupLocations().remove(selectedStudyGroupLocation);
        }
        selectedProcedureDetailBean.getIacucProtocolStudyGroupLocations().remove(selectedStudyGroupLocation);
    }

    @Override
    public void addProcedurePersonResponsible(IacucProcedurePersonResponsible newIacucProcedurePersonResponsible, IacucProtocolStudyGroupDetailBean selectedProcedureDetailBean, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        List<String> protocolPersonsResponsible = newIacucProcedurePersonResponsible.getProtocolPersonsResponsible();
        List<IacucProcedurePersonResponsible> procedurePersonsResponsible = this.addNewPersonResponsible(protocolPersonsResponsible, newIacucProcedurePersonResponsible);
        this.addPersonToStudyGroupAndDetailBean(selectedProcedureDetailBean, procedurePersonsResponsible, selectedProtocolStudyGroupBean);
    }

    @Override
    public void addProcedureLocation(IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation, IacucProtocolStudyGroupDetailBean selectedProcedureDetailBean, IacucProtocol protocol) {
        int locationGroupIndex = selectedProcedureDetailBean.getIacucProtocolStudyGroupLocations().size() + 1;
        newIacucProtocolStudyGroupLocation.setLocationGroupIndex(locationGroupIndex);
        selectedProcedureDetailBean.getIacucProtocolStudyGroupLocations().add(newIacucProtocolStudyGroupLocation);
        for (IacucProtocolStudyGroup protocolStudyGroup : selectedProcedureDetailBean.getIacucProtocolStudyGroups()) {
            IacucProtocolStudyGroupLocation newStudyGroupLocation = (IacucProtocolStudyGroupLocation)ObjectUtils.deepCopy((Serializable)newIacucProtocolStudyGroupLocation);
            newStudyGroupLocation.setLocationGroupIndex(locationGroupIndex);
            this.updateAttributesForNewProcedureLocation(newStudyGroupLocation, protocolStudyGroup, protocol);
            protocolStudyGroup.getIacucProtocolStudyGroupLocations().add(newStudyGroupLocation);
        }
    }

    @Override
    public void resetProcedurePanel(IacucProtocol protocol) {
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans = protocol.getIacucProtocolStudyGroups();
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocolStudyGroupBeans) {
            for (IacucProtocolStudyGroupDetailBean iacucProtocolStudyGroupDetailBean : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                iacucProtocolStudyGroupDetailBean.resetPersistenceState();
                for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    iacucProtocolStudyGroup.resetPersistenceState();
                    for (IacucProcedurePersonResponsible protocolPersonResponsible : iacucProtocolStudyGroup.getIacucProcedurePersonsResponsible()) {
                        protocolPersonResponsible.resetPersistenceState();
                    }
                    for (IacucProtocolStudyGroupLocation protocolLocation : iacucProtocolStudyGroup.getIacucProtocolStudyGroupLocations()) {
                        protocolLocation.resetPersistenceState();
                    }
                    for (IacucProtocolStudyCustomData protocolCustomData : iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                        protocolCustomData.resetPersistenceState();
                    }
                }
            }
        }
    }

    @Override
    public void setIacucProtocolStudyGroupReferences(IacucProtocol protocol) {
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans = protocol.getIacucProtocolStudyGroupBeans();
        HashMap<Object, Object> newSpeciesIdMapping = new HashMap();
        if (this.isSpeciesAndProcedureExists(protocol)) {
            newSpeciesIdMapping = this.getIacucProtocolSpeciesService().getNewProtocolSpeciesMap(protocol);
        }
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocolStudyGroupBeans) {
            for (IacucProtocolStudyGroupDetailBean iacucProtocolStudyGroupDetailBean : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    Integer newProtocolSpeciesId = (Integer)newSpeciesIdMapping.get(iacucProtocolStudyGroup.getIacucProtocolSpeciesId());
                    iacucProtocolStudyGroup.setIacucProtocolSpeciesId(newProtocolSpeciesId);
                    this.setStudyGoupPersonResponsibleReferences(iacucProtocolStudyGroup.getIacucProcedurePersonsResponsible(), protocol);
                    this.setStudyGoupCustomDataReferences(iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList(), protocol);
                    this.setStudyGoupLocationReferences(iacucProtocolStudyGroup.getIacucProtocolStudyGroupLocations(), protocol);
                }
            }
        }
    }

    private boolean isSpeciesAndProcedureExists(IacucProtocol protocol) {
        return protocol.getIacucProtocolSpeciesList().size() > 0 && protocol.getIacucProtocolStudyGroups().size() > 0;
    }

    private void setStudyGoupPersonResponsibleReferences(List<IacucProcedurePersonResponsible> personsResponsible, IacucProtocol protocol) {
        for (IacucProcedurePersonResponsible protocolPersonResponsible : personsResponsible) {
            protocolPersonResponsible.setProtocolId(protocol.getProtocolId());
            protocolPersonResponsible.setProtocolNumber(protocol.getProtocolNumber());
            protocolPersonResponsible.setSequenceNumber(protocol.getSequenceNumber());
        }
    }

    private void setStudyGoupCustomDataReferences(List<IacucProtocolStudyCustomData> beanCustomDataList, IacucProtocol protocol) {
        for (IacucProtocolStudyCustomData protocolCustomData : beanCustomDataList) {
            protocolCustomData.setProtocolId(protocol.getProtocolId());
            protocolCustomData.setProtocolNumber(protocol.getProtocolNumber());
            protocolCustomData.setSequenceNumber(protocol.getSequenceNumber());
        }
    }

    private void setStudyGoupLocationReferences(List<IacucProtocolStudyGroupLocation> beanLocations, IacucProtocol protocol) {
        for (IacucProtocolStudyGroupLocation protocolLocation : beanLocations) {
            protocolLocation.setProtocolId(protocol.getProtocolId());
            protocolLocation.setProtocolNumber(protocol.getProtocolNumber());
            protocolLocation.setSequenceNumber(protocol.getSequenceNumber());
        }
    }

    @Override
    public void updateIacucProtocolStudyGroup(IacucProtocol protocol) {
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans = protocol.getIacucProtocolStudyGroupBeans();
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocolStudyGroupBeans) {
            for (IacucProtocolStudyGroupDetailBean iacucProtocolStudyGroupDetailBean : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                this.updateExistingStudyGroupPersonResponsible(iacucProtocolStudyGroupDetailBean.getIacucProcedurePersonsResponsible(), iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups());
                this.updateExistingStudyGroupLocation(iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroupLocations(), iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups());
                this.updateExistingStudyGroupCustomData(iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyCustomDataList(), iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups());
            }
        }
    }

    @Override
    public List<IacucProtocolStudyGroupBean> getRevisedStudyGroupBeans(IacucProtocol iacucProtocol, List<IacucProcedure> allProcedures) {
        List<IacucProtocolStudyGroupBean> studyGroupBeans = iacucProtocol.getIacucProtocolStudyGroupBeans();
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups = iacucProtocol.getIacucProtocolStudyGroups();
        if (studyGroupBeans.isEmpty()) {
            studyGroupBeans = this.getNewListOfStudyGroupBeans();
            if (!iacucProtocolStudyGroups.isEmpty()) {
                this.groupProtocolStudyAndBeans(iacucProtocol, studyGroupBeans, allProcedures);
            }
        }
        return studyGroupBeans;
    }

    private void updateExistingStudyGroupPersonResponsible(List<IacucProcedurePersonResponsible> beanPersonsResponsible, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (IacucProcedurePersonResponsible beanPersonResponsible : beanPersonsResponsible) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
                for (IacucProcedurePersonResponsible protocolPersonResponsible : iacucProtocolStudyGroup.getIacucProcedurePersonsResponsible()) {
                    if (!protocolPersonResponsible.getPersonId().equalsIgnoreCase(beanPersonResponsible.getPersonId())) continue;
                    protocolPersonResponsible.setPersonResponsibleDescription(beanPersonResponsible.getPersonResponsibleDescription());
                }
            }
        }
    }

    private void updateExistingStudyGroupLocation(List<IacucProtocolStudyGroupLocation> beanLocations, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (IacucProtocolStudyGroupLocation beanLocation : beanLocations) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
                for (IacucProtocolStudyGroupLocation protocolLocation : iacucProtocolStudyGroup.getIacucProtocolStudyGroupLocations()) {
                    if (!protocolLocation.getLocationGroupIndex().equals(beanLocation.getLocationGroupIndex())) continue;
                    protocolLocation.setLocationId(beanLocation.getLocationId());
                    protocolLocation.setLocationTypeCode(beanLocation.getLocationTypeCode());
                    protocolLocation.setLocationRoom(beanLocation.getLocationRoom());
                    protocolLocation.setStudyGroupLocationDescription(beanLocation.getStudyGroupLocationDescription());
                }
            }
        }
    }

    private void updateExistingStudyGroupCustomData(List<IacucProtocolStudyCustomData> beanCustomDataList, List<IacucProtocolStudyGroup> iacucProtocolStudyGroups) {
        for (IacucProtocolStudyCustomData beanCustomData : beanCustomDataList) {
            for (IacucProtocolStudyGroup iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
                for (IacucProtocolStudyCustomData protocolCustomData : iacucProtocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                    if (!protocolCustomData.getProcedureCustomAttributeId().equals(beanCustomData.getProcedureCustomAttributeId())) continue;
                    protocolCustomData.setValue(beanCustomData.getValue());
                }
            }
        }
    }

    private void updateAttributesForNewProcedureLocation(IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation, IacucProtocolStudyGroup protocolStudyGroup, IacucProtocol protocol) {
        newIacucProtocolStudyGroupLocation.setStudyGroupLocationId(this.getNextStudyGroupLocationId(protocolStudyGroup));
        newIacucProtocolStudyGroupLocation.setIacucProtocolStudyGroupId(protocolStudyGroup.getIacucProtocolStudyGroupId());
        newIacucProtocolStudyGroupLocation.setIacucProtocolStudyGroupLocationId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_LOCATION_SEQUENCE_ID));
        newIacucProtocolStudyGroupLocation.setProtocolId(protocol.getProtocolId());
        newIacucProtocolStudyGroupLocation.setProtocolNumber(protocol.getProtocolNumber());
        newIacucProtocolStudyGroupLocation.setSequenceNumber(protocol.getSequenceNumber());
    }

    private IacucProtocolStudyGroupBean getProtocolStudyGroup(IacucProtocol protocol, IacucProtocolStudyGroupBean selectedStudyGroupBean) {
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups = protocol.getIacucProtocolStudyGroups();
        IacucProtocolStudyGroupBean selectedProtocolStudyGroup = null;
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
            if (!selectedStudyGroupBean.getProcedureCategoryCode().equals(iacucProtocolStudyGroup.getProcedureCategoryCode()) || !selectedStudyGroupBean.getProcedureCode().equals(iacucProtocolStudyGroup.getProcedureCode())) continue;
            selectedProtocolStudyGroup = iacucProtocolStudyGroup;
        }
        return selectedProtocolStudyGroup;
    }

    private void groupProtocolStudyAndBeans(IacucProtocol protocol, List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroupBeans, List<IacucProcedure> allProcedures) {
        List<IacucProtocolStudyGroupBean> iacucProtocolStudyGroups = protocol.getIacucProtocolStudyGroups();
        block0: for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : iacucProtocolStudyGroupBeans) {
            for (IacucProtocolStudyGroupBean iacucProtocolStudyGroup : iacucProtocolStudyGroups) {
                if (!iacucProtocolStudyGroupBean.getProcedureCategoryCode().equals(iacucProtocolStudyGroup.getProcedureCategoryCode()) || !iacucProtocolStudyGroupBean.getProcedureCode().equals(iacucProtocolStudyGroup.getProcedureCode())) continue;
                iacucProtocolStudyGroupBean.setIacucProtocolStudyGroupHeaderId(iacucProtocolStudyGroup.getIacucProtocolStudyGroupHeaderId());
                iacucProtocolStudyGroupBean.setProtocol(iacucProtocolStudyGroup.getProtocol());
                iacucProtocolStudyGroupBean.setProtocolId(iacucProtocolStudyGroup.getProtocolId());
                iacucProtocolStudyGroupBean.setProtocolNumber(iacucProtocolStudyGroup.getProtocolNumber());
                iacucProtocolStudyGroupBean.setSequenceNumber(iacucProtocolStudyGroup.getSequenceNumber());
                iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans().addAll(iacucProtocolStudyGroup.getIacucProtocolStudyGroupDetailBeans());
                this.selectUsedProcedureCategory(allProcedures, iacucProtocolStudyGroup.getProcedureCode());
                continue block0;
            }
        }
        this.syncStudyGroupAndBeans(iacucProtocolStudyGroupBeans);
    }

    private void selectUsedProcedureCategory(List<IacucProcedure> allProcedures, Integer selectedProcedureCode) {
        for (IacucProcedure iacucProcedure : allProcedures) {
            if (!iacucProcedure.getProcedureCode().equals(selectedProcedureCode)) continue;
            iacucProcedure.setProcedureSelected(true);
            break;
        }
    }

    private void syncStudyGroupAndBeans(List<IacucProtocolStudyGroupBean> studyGroupBeans) {
        for (IacucProtocolStudyGroupBean iacucProtocolStudyGroupBean : studyGroupBeans) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : iacucProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                this.syncPersonsResposible(studyGroupDetailBean);
                this.syncStudyGroupLocation(studyGroupDetailBean);
                this.syncStudyGroupCustomData(studyGroupDetailBean);
            }
        }
    }

    private void syncPersonsResposible(IacucProtocolStudyGroupDetailBean studyGroupDetailBean) {
        List<IacucProcedurePersonResponsible> protocolPersonsResponsible = this.getDistinctPersonsResponsibleForDetailBean(studyGroupDetailBean);
        for (IacucProcedurePersonResponsible personResponsible : protocolPersonsResponsible) {
            IacucProcedurePersonResponsible newPersonResponsible = this.getNewCopyOfPersonResponsible(personResponsible);
            newPersonResponsible.setTrainings(this.getIacucPersonTrainingDetails(newPersonResponsible.getPersonId()));
            studyGroupDetailBean.getIacucProcedurePersonsResponsible().add(newPersonResponsible);
        }
    }

    private void syncStudyGroupLocation(IacucProtocolStudyGroupDetailBean studyGroupDetailBean) {
        List<IacucProtocolStudyGroupLocation> protocolGroupLocations = this.getDistinctGroupLocationsForDetailBean(studyGroupDetailBean);
        for (IacucProtocolStudyGroupLocation groupLocation : protocolGroupLocations) {
            IacucProtocolStudyGroupLocation newStudyGroupLocation = (IacucProtocolStudyGroupLocation)ObjectUtils.deepCopy((Serializable)groupLocation);
            studyGroupDetailBean.getIacucProtocolStudyGroupLocations().add(newStudyGroupLocation);
        }
    }

    private void syncStudyGroupCustomData(IacucProtocolStudyGroupDetailBean studyGroupDetailBean) {
        List<IacucProtocolStudyCustomData> protocolStudyCustomDataList = this.getDistinctGroupCustomDataListForDetailBean(studyGroupDetailBean);
        for (IacucProtocolStudyCustomData groupCustomData : protocolStudyCustomDataList) {
            IacucProtocolStudyCustomData newIacucProtocolStudyCustomData = (IacucProtocolStudyCustomData)ObjectUtils.deepCopy((Serializable)groupCustomData);
            studyGroupDetailBean.getIacucProtocolStudyCustomDataList().add(newIacucProtocolStudyCustomData);
        }
    }

    private List<IacucProcedurePersonResponsible> getDistinctPersonsResponsibleForDetailBean(IacucProtocolStudyGroupDetailBean studyGroupDetailBean) {
        HashSet<String> distinctPersonIds = new HashSet<String>();
        ArrayList<IacucProcedurePersonResponsible> beanPersonsResponsible = new ArrayList<IacucProcedurePersonResponsible>();
        for (IacucProtocolStudyGroup protocolStudyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
            for (IacucProcedurePersonResponsible personResponsible : protocolStudyGroup.getIacucProcedurePersonsResponsible()) {
                if (distinctPersonIds.contains(personResponsible.getPersonId())) continue;
                distinctPersonIds.add(personResponsible.getPersonId());
                beanPersonsResponsible.add(personResponsible);
            }
        }
        return beanPersonsResponsible;
    }

    private List<IacucProtocolStudyGroupLocation> getDistinctGroupLocationsForDetailBean(IacucProtocolStudyGroupDetailBean studyGroupDetailBean) {
        HashSet<Integer> distinctLocationIndexes = new HashSet<Integer>();
        ArrayList<IacucProtocolStudyGroupLocation> beanGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
        for (IacucProtocolStudyGroup protocolStudyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyGroupLocation groupLocation : protocolStudyGroup.getIacucProtocolStudyGroupLocations()) {
                if (distinctLocationIndexes.contains(groupLocation.getLocationGroupIndex())) continue;
                distinctLocationIndexes.add(groupLocation.getLocationGroupIndex());
                beanGroupLocations.add(groupLocation);
            }
        }
        return beanGroupLocations;
    }

    private List<IacucProtocolStudyCustomData> getDistinctGroupCustomDataListForDetailBean(IacucProtocolStudyGroupDetailBean studyGroupDetailBean) {
        HashSet<Integer> distinctCustomIds = new HashSet<Integer>();
        ArrayList<IacucProtocolStudyCustomData> beanGroupCustomDataList = new ArrayList<IacucProtocolStudyCustomData>();
        for (IacucProtocolStudyGroup protocolStudyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyCustomData groupCustomData : protocolStudyGroup.getIacucProtocolStudyCustomDataList()) {
                if (distinctCustomIds.contains(groupCustomData.getProcedureCustomAttributeId())) continue;
                distinctCustomIds.add(groupCustomData.getProcedureCustomAttributeId());
                beanGroupCustomDataList.add(groupCustomData);
            }
        }
        return beanGroupCustomDataList;
    }

    private List<IacucProcedurePersonResponsible> addNewPersonResponsible(List<String> protocolPersonsResponsible, IacucProcedurePersonResponsible newIacucProcedurePersonResponsible) {
        List<IacucProcedurePersonResponsible> iacucProcedurePersonsResponsible = this.addPersonsResponsible(protocolPersonsResponsible);
        for (IacucProcedurePersonResponsible personResponsible : iacucProcedurePersonsResponsible) {
            String description = newIacucProcedurePersonResponsible.getPersonResponsibleDescription();
            personResponsible.setPersonResponsibleDescription(description);
        }
        return iacucProcedurePersonsResponsible;
    }

    private void addPersonToDetailBean(List<IacucProtocolStudyGroupDetailBean> studyGroupDetailBeans, List<IacucProcedurePersonResponsible> iacucProcedurePersonsResponsible, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocol iacucProtocol) {
        for (IacucProtocolStudyGroupDetailBean detailBean : studyGroupDetailBeans) {
            this.addPersonToStudyGroupAndDetailBean(detailBean, iacucProcedurePersonsResponsible, selectedProtocolStudyGroupBean);
        }
    }

    private void addPersonToStudyGroupAndDetailBean(IacucProtocolStudyGroupDetailBean detailBean, List<IacucProcedurePersonResponsible> iacucProcedurePersonsResponsible, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        detailBean.setNewIacucProcedurePersonResponsible(new IacucProcedurePersonResponsible());
        for (IacucProcedurePersonResponsible personResponsible : iacucProcedurePersonsResponsible) {
            IacucProcedurePersonResponsible newPersonResponsible = this.getNewCopyOfPersonResponsible(personResponsible);
            detailBean.getIacucProcedurePersonsResponsible().add(newPersonResponsible);
        }
        this.addNewStudyGroupPersonResponsible(detailBean, iacucProcedurePersonsResponsible, selectedProtocolStudyGroupBean);
    }

    private void addNewStudyGroupPersonResponsible(IacucProtocolStudyGroupDetailBean detailBean, List<IacucProcedurePersonResponsible> iacucProcedurePersonsResponsible, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        for (IacucProtocolStudyGroup protocolStudyGroup : detailBean.getIacucProtocolStudyGroups()) {
            for (IacucProcedurePersonResponsible personResponsible : iacucProcedurePersonsResponsible) {
                IacucProcedurePersonResponsible newPersonResponsible = this.getNewCopyOfPersonResponsible(personResponsible);
                this.setAttributesForNewProcedurePersonResponsible(newPersonResponsible, protocolStudyGroup, selectedProtocolStudyGroupBean);
                protocolStudyGroup.getIacucProcedurePersonsResponsible().add(newPersonResponsible);
            }
        }
    }

    private void setAttributesForNewProcedurePersonResponsible(IacucProcedurePersonResponsible personResponsible, IacucProtocolStudyGroup studyGroup, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean) {
        personResponsible.setIacucProcedurePersonResponsibleId(this.getNextSequenceNumber(PROTOCOL_PERSON_RESPONSIBLE_SEQUENCE_ID));
        personResponsible.setIacucProtocolStudyGroupId(studyGroup.getIacucProtocolStudyGroupId());
        personResponsible.setProtocolNumber(selectedProtocolStudyGroupBean.getProtocolNumber());
        personResponsible.setSequenceNumber(selectedProtocolStudyGroupBean.getSequenceNumber());
        personResponsible.setProtocolId(selectedProtocolStudyGroupBean.getProtocolId());
    }

    private List<IacucProcedurePersonResponsible> addPersonsResponsible(List<String> protocolPersonsResponsible) {
        ArrayList<IacucProcedurePersonResponsible> iacucProcedurePersonsResponsible = new ArrayList<IacucProcedurePersonResponsible>();
        for (String personKey : protocolPersonsResponsible) {
            IacucProcedurePersonResponsible iacucProcedurePersonResponsible = new IacucProcedurePersonResponsible();
            String personId = null;
            String personName = null;
            StringTokenizer personInfo = new StringTokenizer(personKey, "|");
            while (personInfo.hasMoreTokens()) {
                personId = personInfo.nextToken();
                personName = personInfo.nextToken();
            }
            iacucProcedurePersonResponsible.setPersonId(personId);
            iacucProcedurePersonResponsible.setPersonName(personName);
            iacucProcedurePersonResponsible.setTrainings(this.getIacucPersonTrainingDetails(personId));
            iacucProcedurePersonsResponsible.add(iacucProcedurePersonResponsible);
        }
        return iacucProcedurePersonsResponsible;
    }

    protected List<IacucPersonTraining> getIacucPersonTrainingDetails(String personId) {
        return this.getIacucProtocolPersonTrainingService().getIacucPersonTrainingDetails(personId);
    }

    private List<IacucProtocolStudyGroupDetailBean> addStudyGroupBeans(List<String> protocolSpeciesAndGroups, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, IacucProtocol protocol) {
        ArrayList<IacucProtocolStudyGroupDetailBean> updatedDetailBeans = new ArrayList<IacucProtocolStudyGroupDetailBean>();
        HashMap<Integer, List<IacucProtocolStudyGroup>> studiesGroupedBySpecies = this.getNewProcedureStudyGroupedBySpecies(protocolSpeciesAndGroups);
        for (Map.Entry<Integer, List<IacucProtocolStudyGroup>> entry : studiesGroupedBySpecies.entrySet()) {
            Integer speciesCode = entry.getKey();
            List<IacucProtocolStudyGroup> studyGroups = entry.getValue();
            IacucProtocolStudyGroupDetailBean selectedDetailBean = null;
            selectedDetailBean = this.addNewStudyGroupDetailBean(studyGroups, selectedProtocolStudyGroupBean, speciesCode, protocol);
            updatedDetailBeans.add(selectedDetailBean);
        }
        return updatedDetailBeans;
    }

    private IacucProtocolStudyGroupDetailBean addNewStudyGroupDetailBean(List<IacucProtocolStudyGroup> studyGroups, IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, Integer speciesCode, IacucProtocol protocol) {
        IacucProtocolStudyGroupDetailBean newIacucProtocolStudyGroupDetailBean = new IacucProtocolStudyGroupDetailBean();
        this.addIacucProtocolStudyGroups(selectedProtocolStudyGroupBean, studyGroups, newIacucProtocolStudyGroupDetailBean, speciesCode, protocol);
        selectedProtocolStudyGroupBean.getIacucProtocolStudyGroupDetailBeans().add(newIacucProtocolStudyGroupDetailBean);
        return newIacucProtocolStudyGroupDetailBean;
    }

    private void addIacucProtocolStudyGroups(IacucProtocolStudyGroupBean selectedProtocolStudyGroupBean, List<IacucProtocolStudyGroup> studyGroups, IacucProtocolStudyGroupDetailBean iacucProtocolStudyGroupDetailBean, Integer speciesCode, IacucProtocol protocol) {
        Integer speciesCount = 0;
        TreeSet<IacucPainCategory> painCategory = new TreeSet<IacucPainCategory>();
        ArrayList<String> speciesAndGroups = new ArrayList<String>();
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : studyGroups) {
            IacucProtocolSpecies protocolSpecies = iacucProtocolStudyGroup.getIacucProtocolSpecies();
            painCategory.add(protocolSpecies.getIacucPainCategory());
            speciesCount = speciesCount + protocolSpecies.getSpeciesCount();
            speciesAndGroups.add(protocolSpecies.getGroupAndSpecies());
            iacucProtocolStudyGroupDetailBean.getIacucProtocolStudyGroups().add(iacucProtocolStudyGroup);
        }
        iacucProtocolStudyGroupDetailBean.setIacucProtocolStudyGroupDetailId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_DETAIL_SEQUENCE_ID));
        iacucProtocolStudyGroupDetailBean.setIacucProtocolStudyGroupHeaderId(selectedProtocolStudyGroupBean.getIacucProtocolStudyGroupHeaderId());
        iacucProtocolStudyGroupDetailBean.setSpeciesCode(speciesCode);
        iacucProtocolStudyGroupDetailBean.setMaxPainCategory(((IacucPainCategory)painCategory.last()).getPainCategory());
        iacucProtocolStudyGroupDetailBean.setMaxPainCategoryCode(((IacucPainCategory)painCategory.last()).getPainCategoryCode());
        iacucProtocolStudyGroupDetailBean.setMaxIacucPainCategory((IacucPainCategory)painCategory.last());
        iacucProtocolStudyGroupDetailBean.setSpeciesAndGroupsText(speciesAndGroups);
        iacucProtocolStudyGroupDetailBean.setTotalSpeciesCount(speciesCount);
        this.setAttributesForNewProtocolStudyGroups(studyGroups, iacucProtocolStudyGroupDetailBean, protocol);
    }

    private void setAttributesForNewProtocolStudyGroups(List<IacucProtocolStudyGroup> studyGroups, IacucProtocolStudyGroupDetailBean studyGroupDetailBean, IacucProtocol protocol) {
        for (IacucProtocolStudyGroup iacucProtocolStudyGroup : studyGroups) {
            this.setAttributesForNewProtocolStudyGroup(iacucProtocolStudyGroup, studyGroupDetailBean, protocol);
        }
    }

    private void setAttributesForNewProtocolStudyGroup(IacucProtocolStudyGroup iacucProtocolStudyGroup, IacucProtocolStudyGroupDetailBean studyGroupDetailBean, IacucProtocol protocol) {
        iacucProtocolStudyGroup.setIacucProtocolStudyGroupId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_SEQUENCE_ID));
        iacucProtocolStudyGroup.setIacucProtocolStudyGroupDetailId(studyGroupDetailBean.getIacucProtocolStudyGroupDetailId());
        iacucProtocolStudyGroup.setStudyGroupId(this.getNextStudyGroupId(protocol));
        iacucProtocolStudyGroup.setPainCategory(studyGroupDetailBean.getMaxPainCategory());
        iacucProtocolStudyGroup.setPainCategoryCode(studyGroupDetailBean.getMaxPainCategoryCode());
        iacucProtocolStudyGroup.setCount(studyGroupDetailBean.getTotalSpeciesCount());
    }

    private Integer getNextStudyGroupLocationId(IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        int totalStudyGroupLocs = iacucProtocolStudyGroup.getIacucProtocolStudyGroupLocations().size();
        Integer nextStudyGroupLocationId = 1;
        if (totalStudyGroupLocs > 0) {
            List<IacucProtocolStudyGroupLocation> sortedStudyGroupLocations = this.getSortedStudyGroupLocations(iacucProtocolStudyGroup);
            IacucProtocolStudyGroupLocation studyGroupLocation = sortedStudyGroupLocations.get(totalStudyGroupLocs - 1);
            nextStudyGroupLocationId = studyGroupLocation.getStudyGroupLocationId() + 1;
        }
        return nextStudyGroupLocationId;
    }

    private Integer getNextStudyGroupId(IacucProtocol protocol) {
        int totalStudyGroups = this.getTotalStudyGroups(protocol);
        Integer nextStudyGroupId = 1;
        if (totalStudyGroups > 0) {
            List<IacucProtocolStudyGroup> sortedStudyGroups = this.getSortedStudyGroups(protocol);
            IacucProtocolStudyGroup studyGroup = sortedStudyGroups.get(totalStudyGroups - 1);
            nextStudyGroupId = studyGroup.getStudyGroupId() + 1;
        }
        return nextStudyGroupId;
    }

    private int getTotalStudyGroups(IacucProtocol protocol) {
        int totalStudyGroups = 0;
        for (IacucProtocolStudyGroupBean studyGroupBean : protocol.getIacucProtocolStudyGroupBeans()) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                totalStudyGroups += studyGroupDetailBean.getIacucProtocolStudyGroups().size();
            }
        }
        return totalStudyGroups;
    }

    private List<IacucProtocolStudyGroup> getSortedStudyGroups(IacucProtocol protocol) {
        ArrayList<IacucProtocolStudyGroup> protocolStudyGroups = new ArrayList<IacucProtocolStudyGroup>();
        for (IacucProtocolStudyGroupBean studyGroupBean : protocol.getIacucProtocolStudyGroupBeans()) {
            for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : studyGroupBean.getIacucProtocolStudyGroupDetailBeans()) {
                for (IacucProtocolStudyGroup studyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
                    protocolStudyGroups.add((IacucProtocolStudyGroup)((Object)ObjectUtils.deepCopy((Serializable)((Object)studyGroup))));
                }
            }
        }
        Collections.sort(protocolStudyGroups, new Comparator<IacucProtocolStudyGroup>(){

            @Override
            public int compare(IacucProtocolStudyGroup group1, IacucProtocolStudyGroup group2) {
                return group1.getStudyGroupId().compareTo(group2.getStudyGroupId());
            }
        });
        return protocolStudyGroups;
    }

    private List<IacucProtocolStudyGroupLocation> getSortedStudyGroupLocations(IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        ArrayList<IacucProtocolStudyGroupLocation> protocolStudyGroupLocations = new ArrayList<IacucProtocolStudyGroupLocation>();
        for (IacucProtocolStudyGroupLocation studyGroupLocation : iacucProtocolStudyGroup.getIacucProtocolStudyGroupLocations()) {
            protocolStudyGroupLocations.add((IacucProtocolStudyGroupLocation)ObjectUtils.deepCopy((Serializable)studyGroupLocation));
        }
        Collections.sort(protocolStudyGroupLocations, new Comparator<IacucProtocolStudyGroupLocation>(){

            @Override
            public int compare(IacucProtocolStudyGroupLocation location1, IacucProtocolStudyGroupLocation location2) {
                return location1.getStudyGroupLocationId().compareTo(location2.getStudyGroupLocationId());
            }
        });
        return protocolStudyGroupLocations;
    }

    private HashMap<Integer, List<IacucProtocolStudyGroup>> getNewProcedureStudyGroupedBySpecies(List<String> protocolSpeciesAndGroups) {
        HashMap<Integer, List<IacucProtocolStudyGroup>> studiesGroupedBySpecies = new HashMap<Integer, List<IacucProtocolStudyGroup>>();
        List<Object> studyGroups = null;
        for (String iacucProtocolSpeciesId : protocolSpeciesAndGroups) {
            IacucProtocolStudyGroup iacucProtocolStudyGroup = new IacucProtocolStudyGroup();
            iacucProtocolStudyGroup.setIacucProtocolSpeciesId(Integer.parseInt(iacucProtocolSpeciesId));
            Integer speciesCode = this.getSpeciesCodeFromIacucProtocolSpecies(iacucProtocolStudyGroup);
            studyGroups = studiesGroupedBySpecies.get(speciesCode) == null ? new ArrayList() : studiesGroupedBySpecies.get(speciesCode);
            studyGroups.add((Object)iacucProtocolStudyGroup);
            studiesGroupedBySpecies.put(speciesCode, studyGroups);
        }
        return studiesGroupedBySpecies;
    }

    private Integer getSpeciesCodeFromIacucProtocolSpecies(IacucProtocolStudyGroup iacucProtocolStudyGroup) {
        iacucProtocolStudyGroup.refreshReferenceObject("iacucProtocolSpecies");
        IacucProtocolSpecies protocolSpecies = iacucProtocolStudyGroup.getIacucProtocolSpecies();
        protocolSpecies.refreshReferenceObject("iacucPainCategory");
        protocolSpecies.refreshReferenceObject("iacucSpecies");
        IacucSpecies iacucSpecies = protocolSpecies.getIacucSpecies();
        return iacucSpecies.getSpeciesCode();
    }

    private void setAttributesForNewStudyGroupBean(IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean, IacucProtocol protocol) {
        selectedIacucProtocolStudyGroupBean.setIacucProtocolStudyGroupHeaderId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_HEADER_SEQUENCE_ID));
        selectedIacucProtocolStudyGroupBean.setProtocolId(protocol.getProtocolId());
        selectedIacucProtocolStudyGroupBean.setProtocolNumber(protocol.getProtocolNumber());
        selectedIacucProtocolStudyGroupBean.setSequenceNumber(protocol.getSequenceNumber());
    }

    private List<IacucProtocolStudyGroupBean> getNewListOfStudyGroupBeans() {
        ArrayList<IacucProtocolStudyGroupBean> studyGroupBeans = new ArrayList<IacucProtocolStudyGroupBean>();
        for (IacucProcedure iacucProcedure : this.getAllProcedures()) {
            IacucProtocolStudyGroupBean newIacucProtocolStudyGroupBean = new IacucProtocolStudyGroupBean();
            newIacucProtocolStudyGroupBean.setProcedureCategoryCode(iacucProcedure.getProcedureCategoryCode());
            newIacucProtocolStudyGroupBean.setProcedureCode(iacucProcedure.getProcedureCode());
            newIacucProtocolStudyGroupBean.setProcedureDescription(iacucProcedure.getProcedureDescription());
            newIacucProtocolStudyGroupBean.setProcedureCategory(iacucProcedure.getIacucProcedureCategory().getProcedureCategory());
            studyGroupBeans.add(newIacucProtocolStudyGroupBean);
        }
        return studyGroupBeans;
    }

    private void addProcedureCustomData(IacucProtocolStudyGroupBean selectedIacucProtocolStudyGroupBean, List<IacucProtocolStudyGroupDetailBean> newStudyGroupDetailBeans, IacucProtocol protocol) {
        List<IacucProcedureCategoryCustomData> procedureCustomDataList = this.getIacucProcedureCustomData(selectedIacucProtocolStudyGroupBean.getProcedureCategoryCode());
        for (IacucProtocolStudyGroupDetailBean studyGroupDetailBean : newStudyGroupDetailBeans) {
            ArrayList<IacucProtocolStudyCustomData> protocolStudyCustomDataList = new ArrayList<IacucProtocolStudyCustomData>();
            for (IacucProcedureCategoryCustomData procedureCategoryCustomData : procedureCustomDataList) {
                if (!procedureCategoryCustomData.isActive()) continue;
                IacucProtocolStudyCustomData newIacucProtocolStudyCustomData = new IacucProtocolStudyCustomData();
                newIacucProtocolStudyCustomData.setProcedureCustomAttributeId(procedureCategoryCustomData.getId());
                newIacucProtocolStudyCustomData.setIacucProcedureCategoryCustomData(procedureCategoryCustomData);
                protocolStudyCustomDataList.add(newIacucProtocolStudyCustomData);
            }
            for (IacucProtocolStudyCustomData iacucProtocolStudyCustomData : protocolStudyCustomDataList) {
                if (this.isCustomDataExists(iacucProtocolStudyCustomData, studyGroupDetailBean.getIacucProtocolStudyCustomDataList())) continue;
                studyGroupDetailBean.getIacucProtocolStudyCustomDataList().add(iacucProtocolStudyCustomData);
            }
            this.addProcedureCustomDataInProtocolStudyGroup(studyGroupDetailBean, protocolStudyCustomDataList, protocol);
        }
    }

    private boolean isCustomDataExists(IacucProtocolStudyCustomData newIacucProtocolStudyCustomData, List<IacucProtocolStudyCustomData> iacucProtocolStudyCustomDataList) {
        boolean customDataExists = false;
        for (IacucProtocolStudyCustomData iacucProtocolStudyCustomData : iacucProtocolStudyCustomDataList) {
            if (!iacucProtocolStudyCustomData.getProcedureCustomAttributeId().equals(newIacucProtocolStudyCustomData.getProcedureCustomAttributeId())) continue;
            customDataExists = true;
            break;
        }
        return customDataExists;
    }

    private void addProcedureCustomDataInProtocolStudyGroup(IacucProtocolStudyGroupDetailBean studyGroupDetailBean, List<IacucProtocolStudyCustomData> protocolStudyCustomDataList, IacucProtocol protocol) {
        for (IacucProtocolStudyGroup protocolStudyGroup : studyGroupDetailBean.getIacucProtocolStudyGroups()) {
            for (IacucProtocolStudyCustomData studyGroupCustomData : protocolStudyCustomDataList) {
                if (this.isCustomDataExists(studyGroupCustomData, protocolStudyGroup.getIacucProtocolStudyCustomDataList())) continue;
                IacucProtocolStudyCustomData newIacucProtocolStudyCustomData = (IacucProtocolStudyCustomData)ObjectUtils.deepCopy((Serializable)studyGroupCustomData);
                protocolStudyGroup.getIacucProtocolStudyCustomDataList().add(newIacucProtocolStudyCustomData);
                this.updateAttributesForNewProcedureCustomData(newIacucProtocolStudyCustomData, protocol, protocolStudyGroup);
            }
        }
    }

    private void updateAttributesForNewProcedureCustomData(IacucProtocolStudyCustomData newIacucProtocolStudyCustomData, IacucProtocol protocol, IacucProtocolStudyGroup protocolStudyGroup) {
        newIacucProtocolStudyCustomData.setIacucProtocolStudyCustomDataId(this.getNextSequenceNumber(PROTOCOL_STUDY_GROUP_CUSTOM_DATA_SEQUENCE_ID));
        newIacucProtocolStudyCustomData.setProtocolId(protocol.getProtocolId());
        newIacucProtocolStudyCustomData.setProtocolNumber(protocol.getProtocolNumber());
        newIacucProtocolStudyCustomData.setSequenceNumber(protocol.getSequenceNumber());
        newIacucProtocolStudyCustomData.setIacucProtocolStudyGroupId(protocolStudyGroup.getIacucProtocolStudyGroupId());
    }

    private List<IacucProcedureCategoryCustomData> getIacucProcedureCustomData(Integer procedureCategoryCode) {
        HashMap<String, Integer> matchingKey = new HashMap<String, Integer>();
        matchingKey.put("procedureCategoryCode", procedureCategoryCode);
        return (List)this.getBusinessObjectService().findMatchingOrderBy(IacucProcedureCategoryCustomData.class, matchingKey, "sortId", true);
    }

    private Integer getNextSequenceNumber(String sequenceKey) {
        return this.getSequenceAccessorService().getNextAvailableSequenceNumber(sequenceKey).intValue();
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    private IacucProcedurePersonResponsible getNewCopyOfPersonResponsible(IacucProcedurePersonResponsible personResponsible) {
        return (IacucProcedurePersonResponsible)ObjectUtils.deepCopy((Serializable)personResponsible);
    }

    private IacucProtocolStudyGroupBean getNewCopyOfStudyGroupBean(IacucProtocolStudyGroupBean protocolStudyGroupBean) {
        return (IacucProtocolStudyGroupBean)ObjectUtils.deepCopy((Serializable)protocolStudyGroupBean);
    }

    private IacucProtocolStudyGroupDetailBean getNewCopyOfStudyGroupDetailBean(IacucProtocolStudyGroupDetailBean protocolStudyGroupDetailBean) {
        return (IacucProtocolStudyGroupDetailBean)((Object)ObjectUtils.deepCopy((Serializable)((Object)protocolStudyGroupDetailBean)));
    }

    private IacucProtocolStudyGroupLocation getNewCopyOfStudyGroupLocation(IacucProtocolStudyGroupLocation protocolStudyGroupLocation) {
        return (IacucProtocolStudyGroupLocation)ObjectUtils.deepCopy((Serializable)protocolStudyGroupLocation);
    }

    private IacucProtocolStudyCustomData getNewCopyOfStudyCustomData(IacucProtocolStudyCustomData protocolStudyCustomData) {
        return (IacucProtocolStudyCustomData)ObjectUtils.deepCopy((Serializable)protocolStudyCustomData);
    }

    private IacucProtocolStudyGroup getNewCopyOfProtocolStudyGroup(IacucProtocolStudyGroup protocolStudyGroup) {
        return (IacucProtocolStudyGroup)((Object)ObjectUtils.deepCopy((Serializable)((Object)protocolStudyGroup)));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public IacucProtocolPersonTrainingService getIacucProtocolPersonTrainingService() {
        return this.iacucProtocolPersonTrainingService;
    }

    public void setIacucProtocolPersonTrainingService(IacucProtocolPersonTrainingService iacucProtocolPersonTrainingService) {
        this.iacucProtocolPersonTrainingService = iacucProtocolPersonTrainingService;
    }

    public IacucProtocolSpeciesService getIacucProtocolSpeciesService() {
        return this.iacucProtocolSpeciesService;
    }

    public void setIacucProtocolSpeciesService(IacucProtocolSpeciesService iacucProtocolSpeciesService) {
        this.iacucProtocolSpeciesService = iacucProtocolSpeciesService;
    }
}

