/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures.rule;

import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupLocation;
import org.kuali.kra.iacuc.procedures.rule.AddProcedureLocationEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AddProcedureLocationRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddProcedureLocationEvent> {
    private static final String PROCEDURE_BEAN_PATH = "iacucProtocolStudyGroupBeans[";
    private static final String PROCEDURE_DETAIL_BEAN_PATH = "].iacucProtocolStudyGroupDetailBeans[";
    private static final String NEW_PROCEDURE_LOCATION_PATH = "].newIacucProtocolStudyGroupLocation";

    @Override
    public boolean processRules(AddProcedureLocationEvent event) {
        return this.processAddProcedureLocationBusinessRules(event);
    }

    private boolean processAddProcedureLocationBusinessRules(AddProcedureLocationEvent event) {
        boolean rulePassed = true;
        if (rulePassed &= this.isLocationValid(event)) {
            rulePassed &= !this.isDuplicateLocation(event);
        }
        return rulePassed;
    }

    private boolean isLocationValid(AddProcedureLocationEvent event) {
        boolean locationValid = true;
        IacucProtocolStudyGroupDetailBean procedureDetailBean = event.getProcedureDetailBean();
        IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation = procedureDetailBean.getNewIacucProtocolStudyGroupLocation();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.addToErrorPath(this.getErrorPath(event));
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)newIacucProtocolStudyGroupLocation);
        errorMap.removeFromErrorPath(this.getErrorPath(event));
        return locationValid &= GlobalVariables.getMessageMap().hasNoErrors();
    }

    private boolean isDuplicateLocation(AddProcedureLocationEvent event) {
        boolean duplicateLocation = false;
        IacucProtocolStudyGroupDetailBean procedureDetailBean = event.getProcedureDetailBean();
        IacucProtocolStudyGroupLocation newIacucProtocolStudyGroupLocation = procedureDetailBean.getNewIacucProtocolStudyGroupLocation();
        for (IacucProtocolStudyGroupLocation studyGroupLocation : procedureDetailBean.getIacucProtocolStudyGroupLocations()) {
            if (!studyGroupLocation.getLocationId().equals(newIacucProtocolStudyGroupLocation.getLocationId()) || !studyGroupLocation.getLocationTypeCode().equals(newIacucProtocolStudyGroupLocation.getLocationTypeCode())) continue;
            GlobalVariables.getMessageMap().putError(this.getErrorPath(event) + "locationTypeCode", "error.iacuc.validation.duplicate.studyGroup.location", new String[0]);
            duplicateLocation = true;
        }
        return duplicateLocation;
    }

    private String getErrorPath(AddProcedureLocationEvent event) {
        StringBuffer errorPath = new StringBuffer();
        errorPath.append(PROCEDURE_BEAN_PATH);
        errorPath.append(event.getProcedureBeanIndex());
        errorPath.append(PROCEDURE_DETAIL_BEAN_PATH);
        errorPath.append(event.getProcedureDetailBeanIndex());
        errorPath.append(NEW_PROCEDURE_LOCATION_PATH);
        return errorPath.toString();
    }
}

