/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.procedures.rule;

import java.util.List;
import java.util.StringTokenizer;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolStudyGroupDetailBean;
import org.kuali.kra.iacuc.procedures.rule.AddProcedurePersonResponsibleEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AddProcedurePersonResponsibleRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<AddProcedurePersonResponsibleEvent> {
    private static final String PROCEDURE_BEAN_PATH = "iacucProtocolStudyGroupBeans[";
    private static final String PROCEDURE_DETAIL_BEAN_PATH = "].iacucProtocolStudyGroupDetailBeans[";
    private static final String NEW_PROCEDURE_PERSON_RESPONSIBLE_PATH = "].newIacucProcedurePersonResponsible";

    @Override
    public boolean processRules(AddProcedurePersonResponsibleEvent event) {
        return this.processAddProcedurePersonResponsibleBusinessRules(event);
    }

    private boolean processAddProcedurePersonResponsibleBusinessRules(AddProcedurePersonResponsibleEvent event) {
        boolean rulePassed = true;
        if (rulePassed &= this.isPersonListValid(event)) {
            rulePassed &= !this.isDuplicatePerson(event);
        }
        return rulePassed;
    }

    private boolean isPersonListValid(AddProcedurePersonResponsibleEvent event) {
        boolean personListValid = true;
        IacucProtocolStudyGroupDetailBean procedureDetailBean = event.getProcedureDetailBean();
        List<String> protocolPersonsResponsible = procedureDetailBean.getNewIacucProcedurePersonResponsible().getProtocolPersonsResponsible();
        if (ObjectUtils.isNull(protocolPersonsResponsible) || protocolPersonsResponsible.isEmpty()) {
            GlobalVariables.getMessageMap().putError(this.getErrorPath(event) + "personId", "error.iacuc.validation.personResponsible.valid", new String[0]);
            personListValid = false;
        }
        return personListValid;
    }

    private boolean isDuplicatePerson(AddProcedurePersonResponsibleEvent event) {
        boolean duplicatePerson = false;
        IacucProtocolStudyGroupDetailBean procedureDetailBean = event.getProcedureDetailBean();
        List<String> protocolPersonsResponsible = procedureDetailBean.getNewIacucProcedurePersonResponsible().getProtocolPersonsResponsible();
        for (String personKey : protocolPersonsResponsible) {
            String personId = null;
            String personName = null;
            StringTokenizer personInfo = new StringTokenizer(personKey, "|");
            while (personInfo.hasMoreTokens()) {
                personId = personInfo.nextToken();
                personName = personInfo.nextToken();
                for (IacucProcedurePersonResponsible personResponsible : procedureDetailBean.getIacucProcedurePersonsResponsible()) {
                    if (!personResponsible.getPersonId().equals(personId)) continue;
                    GlobalVariables.getMessageMap().putError(this.getErrorPath(event) + "personId", "error.iacuc.validation.duplicate.personResponsible", new String[0]);
                    duplicatePerson = true;
                }
            }
        }
        return duplicatePerson;
    }

    private String getErrorPath(AddProcedurePersonResponsibleEvent event) {
        StringBuffer errorPath = new StringBuffer();
        errorPath.append(PROCEDURE_BEAN_PATH);
        errorPath.append(event.getProcedureBeanIndex());
        errorPath.append(PROCEDURE_DETAIL_BEAN_PATH);
        errorPath.append(event.getProcedureDetailBeanIndex());
        errorPath.append(NEW_PROCEDURE_PERSON_RESPONSIBLE_PATH);
        return errorPath.toString();
    }
}

