/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.iacuc.IacucSpecies;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class IacucSpeciesValuesFinder
extends KeyValuesBase {
    private static final long serialVersionUID = 3597528521094545089L;

    public List<KeyValue> getKeyValues() {
        Collection iacucSpeciesList = this.getKeyValuesService().findAllOrderBy(IacucSpecies.class, "speciesCode", true);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        for (IacucSpecies iacucSpecies : iacucSpeciesList) {
            keyValues.add((KeyValue)new ConcreteKeyValue(iacucSpecies.getSpeciesCode().toString(), iacucSpecies.getSpeciesName()));
        }
        return keyValues;
    }

    protected KeyValuesService getKeyValuesService() {
        return (KeyValuesService)KraServiceLocator.getService("keyValuesService");
    }
}

