/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.species.exception.IacucProtocolExceptionService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;

public class IacucProtocolExceptionServiceImpl
implements IacucProtocolExceptionService {
    private SequenceAccessorService sequenceAccessorService;
    private static final String PROTOCOL_EXCEPTION_SEQUENCE_ID = "SEQ_IACUC_PROTO_EXCEPTION_ID";
    private static final String REFERENCE_EXCEPTION_CATEGORY = "iacucExceptionCategory";
    private static final String REFERENCE_PROTOCOL_SPECIES = "iacucSpecies";

    @Override
    public void addProtocolException(IacucProtocol protocol, IacucProtocolException protocolException) {
        protocol.getIacucProtocolExceptions().add(this.getNewProtocolException(protocol, protocolException));
    }

    @Override
    public IacucProtocolException getNewProtocolException(IacucProtocol protocol, IacucProtocolException protocolException) {
        protocolException.setIacucProtocolExceptionId(this.getNextProtocolExceptionSequence());
        protocolException.setExceptionId(this.getNextProtocolExceptionId(protocol));
        protocolException.setProtocolNumber(protocol.getProtocolNumber());
        protocolException.setSequenceNumber(protocol.getSequenceNumber());
        this.refreshSpeciesReferenceObjects(protocolException);
        return protocolException;
    }

    private void refreshSpeciesReferenceObjects(IacucProtocolException protocolException) {
        protocolException.refreshReferenceObject(REFERENCE_EXCEPTION_CATEGORY);
        protocolException.refreshReferenceObject(REFERENCE_PROTOCOL_SPECIES);
    }

    private Integer getNextProtocolExceptionSequence() {
        return this.getSequenceAccessorService().getNextAvailableSequenceNumber(PROTOCOL_EXCEPTION_SEQUENCE_ID).intValue();
    }

    private Integer getNextProtocolExceptionId(IacucProtocol protocol) {
        int totalExceptions = protocol.getIacucProtocolExceptions().size();
        Integer nextExceptionId = 1;
        if (totalExceptions > 0) {
            List<IacucProtocolException> sortedProtocolExceptions = this.getSortedExceptions(protocol);
            IacucProtocolException protocolException = sortedProtocolExceptions.get(totalExceptions - 1);
            nextExceptionId = protocolException.getExceptionId() + 1;
        }
        return nextExceptionId;
    }

    public List<IacucProtocolException> getSortedExceptions(IacucProtocol protocol) {
        ArrayList<IacucProtocolException> protocolExceptionsList = new ArrayList<IacucProtocolException>();
        for (IacucProtocolException exception : protocol.getIacucProtocolExceptions()) {
            protocolExceptionsList.add((IacucProtocolException)ObjectUtils.deepCopy((Serializable)exception));
        }
        Collections.sort(protocolExceptionsList, new Comparator<IacucProtocolException>(){

            @Override
            public int compare(IacucProtocolException exception1, IacucProtocolException exception2) {
                return exception1.getExceptionId().compareTo(exception2.getExceptionId());
            }
        });
        return protocolExceptionsList;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

