/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.IacucSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class IacucProtocolSpeciesValuesFinder
extends KeyValuesBase {
    private static final long serialVersionUID = 1095033401204774650L;

    public List<KeyValue> getKeyValues() {
        Long protocolId = ((IacucProtocolForm)KNSGlobalVariables.getKualiForm()).getIacucProtocolDocument().getProtocol().getProtocolId();
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("protocolId", protocolId);
        Collection protocolSpeciesList = this.getKeyValuesService().findMatching(IacucProtocolSpecies.class, keyMap);
        HashMap<Integer, String> distinctSpecies = this.getDistinctSpeciesList(protocolSpeciesList);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        for (Map.Entry<Integer, String> species : distinctSpecies.entrySet()) {
            Integer speciesCode = species.getKey();
            String speciesName = species.getValue();
            keyValues.add((KeyValue)new ConcreteKeyValue(speciesCode.toString(), speciesName));
        }
        return keyValues;
    }

    protected HashMap<Integer, String> getDistinctSpeciesList(Collection<IacucProtocolSpecies> protocolSpeciesList) {
        HashMap<Integer, String> speciesList = new HashMap<Integer, String>();
        for (IacucProtocolSpecies iacucProtocolSpecies : protocolSpeciesList) {
            iacucProtocolSpecies.refreshReferenceObject("iacucSpecies");
            IacucSpecies species = iacucProtocolSpecies.getIacucSpecies();
            speciesList.put(species.getSpeciesCode(), species.getSpeciesName());
        }
        return speciesList;
    }

    protected KeyValuesService getKeyValuesService() {
        return (KeyValuesService)KraServiceLocator.getService("keyValuesService");
    }
}

