/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.summary;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.species.exception.IacucProtocolException;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;

public class IacucProtocolExceptionSummary
implements Serializable {
    private static final long serialVersionUID = -3542316037590648543L;
    private Integer iacucProtocolExceptionId;
    private String speciesName;
    private String exceptionCategory;
    private String exceptionDescription;
    private Integer exceptionCount;
    private boolean speciesNameChanged;
    private boolean exceptionCategoryChanged;
    private boolean exceptionDescriptionChanged;
    private boolean exceptionCountChanged;

    public IacucProtocolExceptionSummary(IacucProtocolException exception) {
        this.iacucProtocolExceptionId = exception.getExceptionId();
        this.speciesName = exception.getSpeciesName();
        this.exceptionCategory = exception.getCategoryName();
        this.exceptionDescription = exception.getExceptionDescription();
        this.exceptionCount = exception.getExceptionCount();
    }

    public Integer getIacucProtocolExceptionId() {
        return this.iacucProtocolExceptionId;
    }

    public void setIacucProtocolExceptionId(Integer iacucProtocolExceptionId) {
        this.iacucProtocolExceptionId = iacucProtocolExceptionId;
    }

    public String getSpeciesName() {
        return this.speciesName;
    }

    public void setSpeciesName(String speciesName) {
        this.speciesName = speciesName;
    }

    public String getExceptionCategory() {
        return this.exceptionCategory;
    }

    public void setExceptionCategory(String exceptionCategory) {
        this.exceptionCategory = exceptionCategory;
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    public void setExceptionDescription(String exceptionDescription) {
        this.exceptionDescription = exceptionDescription;
    }

    public Integer getExceptionCount() {
        return this.exceptionCount;
    }

    public void setExceptionCount(Integer exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    public boolean isSpeciesNameChanged() {
        return this.speciesNameChanged;
    }

    public void setSpeciesNameChanged(boolean speciesNameChanged) {
        this.speciesNameChanged = speciesNameChanged;
    }

    public boolean isExceptionCategoryChanged() {
        return this.exceptionCategoryChanged;
    }

    public void setExceptionCategoryChanged(boolean exceptionCategoryChanged) {
        this.exceptionCategoryChanged = exceptionCategoryChanged;
    }

    public boolean isExceptionDescriptionChanged() {
        return this.exceptionDescriptionChanged;
    }

    public void setExceptionDescriptionChanged(boolean exceptionDescriptionChanged) {
        this.exceptionDescriptionChanged = exceptionDescriptionChanged;
    }

    public boolean isExceptionCountChanged() {
        return this.exceptionCountChanged;
    }

    public void setExceptionCountChanged(boolean exceptionCountChanged) {
        this.exceptionCountChanged = exceptionCountChanged;
    }

    public void compare(IacucProtocolSummary other) {
        IacucProtocolExceptionSummary otherSummary;
        IacucProtocolExceptionSummary iacucProtocolExceptionSummary = otherSummary = other == null ? null : other.findExceptionSummary(this.iacucProtocolExceptionId);
        if (otherSummary == null) {
            this.speciesNameChanged = true;
            this.exceptionCategoryChanged = true;
            this.exceptionDescriptionChanged = true;
            this.exceptionCountChanged = true;
        } else {
            this.speciesNameChanged = !StringUtils.equals((String)this.speciesName, (String)otherSummary.speciesName);
            this.exceptionCategoryChanged = !StringUtils.equals((String)this.exceptionCategory, (String)otherSummary.exceptionCategory);
            this.exceptionDescriptionChanged = !StringUtils.equals((String)this.exceptionDescription, (String)otherSummary.exceptionDescription);
            this.exceptionCountChanged = !ObjectUtils.equals((Object)this.exceptionCount, (Object)otherSummary.exceptionCount);
        }
    }
}

