/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.summary;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.summary.IacucProtocolSummary;

public class IacucProtocolSpeciesSummary
implements Serializable {
    private static final long serialVersionUID = 9204826126972393444L;
    private Integer speciesId;
    private String species;
    private boolean speciesChanged;
    private String speciesGroup;
    private boolean speciesGroupChanged;
    private boolean usdaCovered;
    private boolean usdaCoveredChanged;
    private String strain;
    private boolean strainChanged;
    private int speciesCount;
    private boolean speciesCountChanged;
    private String speciesCountType;
    private boolean speciesCountTypeChanged;
    private String painCategory;
    private boolean painCategoryChanged;
    private String procedureSummary;
    private boolean procedureSummaryChanged;

    public IacucProtocolSpeciesSummary(IacucProtocolSpecies iacucSpecies) {
        this.speciesId = iacucSpecies.getSpeciesId();
        this.species = iacucSpecies.getSpeciesName();
        this.speciesGroup = iacucSpecies.getSpeciesGroup();
        this.usdaCovered = iacucSpecies.getUsdaCovered();
        this.strain = iacucSpecies.getStrain();
        this.speciesCount = iacucSpecies.getSpeciesCount();
        this.speciesCountType = iacucSpecies.getCountTypeName();
        this.painCategory = iacucSpecies.getPainCategoryName();
        this.procedureSummary = iacucSpecies.getProcedureSummary();
    }

    public Integer getSpeciesId() {
        return this.speciesId;
    }

    public void setSpeciesId(Integer speciesId) {
        this.speciesId = speciesId;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public boolean isSpeciesChanged() {
        return this.speciesChanged;
    }

    public void setSpeciesChanged(boolean speciesChanged) {
        this.speciesChanged = speciesChanged;
    }

    public String getSpeciesGroup() {
        return this.speciesGroup;
    }

    public void setSpeciesGroup(String speciesGroup) {
        this.speciesGroup = speciesGroup;
    }

    public boolean isSpeciesGroupChanged() {
        return this.speciesGroupChanged;
    }

    public void setSpeciesGroupChanged(boolean speciesGroupChanged) {
        this.speciesGroupChanged = speciesGroupChanged;
    }

    public boolean isUsdaCovered() {
        return this.usdaCovered;
    }

    public void setUsdaCovered(boolean usdaCovered) {
        this.usdaCovered = usdaCovered;
    }

    public boolean isUsdaCoveredChanged() {
        return this.usdaCoveredChanged;
    }

    public void setUsdaCoveredChanged(boolean usdaCoveredChanged) {
        this.usdaCoveredChanged = usdaCoveredChanged;
    }

    public String getStrain() {
        return this.strain;
    }

    public void setStrain(String strain) {
        this.strain = strain;
    }

    public boolean isStrainChanged() {
        return this.strainChanged;
    }

    public void setStrainChanged(boolean strainChanged) {
        this.strainChanged = strainChanged;
    }

    public int getSpeciesCount() {
        return this.speciesCount;
    }

    public void setSpeciesCount(int speciesCount) {
        this.speciesCount = speciesCount;
    }

    public boolean isSpeciesCountChanged() {
        return this.speciesCountChanged;
    }

    public void setSpeciesCountChanged(boolean speciesCountChanged) {
        this.speciesCountChanged = speciesCountChanged;
    }

    public String getSpeciesCountType() {
        return this.speciesCountType;
    }

    public void setSpeciesCountType(String speciesCountType) {
        this.speciesCountType = speciesCountType;
    }

    public boolean isSpeciesCountTypeChanged() {
        return this.speciesCountTypeChanged;
    }

    public void setSpeciesCountTypeChanged(boolean speciesCountTypeChanged) {
        this.speciesCountTypeChanged = speciesCountTypeChanged;
    }

    public String getPainCategory() {
        return this.painCategory;
    }

    public void setPainCategory(String painCategory) {
        this.painCategory = painCategory;
    }

    public boolean isPainCategoryChanged() {
        return this.painCategoryChanged;
    }

    public void setPainCategoryChanged(boolean painCategoryChanged) {
        this.painCategoryChanged = painCategoryChanged;
    }

    public String getProcedureSummary() {
        return this.procedureSummary;
    }

    public void setProcedureSummary(String procedureSummary) {
        this.procedureSummary = procedureSummary;
    }

    public boolean isProcedureSummaryChanged() {
        return this.procedureSummaryChanged;
    }

    public void setProcedureSummaryChanged(boolean procedureSummaryChanged) {
        this.procedureSummaryChanged = procedureSummaryChanged;
    }

    public void compare(IacucProtocolSummary other) {
        IacucProtocolSpeciesSummary otherSummary;
        IacucProtocolSpeciesSummary iacucProtocolSpeciesSummary = otherSummary = other == null ? null : other.findSpeciesSummary(this.speciesId);
        if (otherSummary == null) {
            this.speciesChanged = true;
            this.speciesGroupChanged = true;
            this.usdaCoveredChanged = true;
            this.strainChanged = true;
            this.speciesCountChanged = true;
            this.speciesCountTypeChanged = true;
            this.painCategoryChanged = true;
            this.procedureSummaryChanged = true;
        } else {
            this.speciesChanged = !StringUtils.equals((String)this.species, (String)otherSummary.species);
            this.speciesGroupChanged = !StringUtils.equals((String)this.speciesGroup, (String)otherSummary.speciesGroup);
            this.usdaCoveredChanged = this.usdaCovered != otherSummary.usdaCoveredChanged;
            this.strainChanged = !StringUtils.equals((String)this.strain, (String)otherSummary.strain);
            this.speciesCountChanged = this.speciesCount != otherSummary.speciesCount;
            this.speciesCountTypeChanged = !StringUtils.equals((String)this.speciesCountType, (String)otherSummary.speciesCountType);
            this.painCategoryChanged = !StringUtils.equals((String)this.painCategory, (String)otherSummary.painCategory);
            this.procedureSummaryChanged = !StringUtils.equals((String)this.procedureSummary, (String)otherSummary.procedureSummary);
        }
    }
}

