/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.rice.core.web.format.BigDecimalFormatter;
import org.kuali.rice.core.web.format.FormatException;

public class BudgetDecimalFormatter
extends BigDecimalFormatter {
    private static final long serialVersionUID = 8395988033199649377L;
    private static Log LOG = LogFactory.getLog(BudgetDecimalFormatter.class);

    protected Object convertToObject(String target) {
        return new BudgetDecimal((BigDecimal)super.convertToObject(target));
    }

    public Object format(Object obj) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("format '" + obj + "'"));
        }
        if (obj == null) {
            return null;
        }
        NumberFormat formatter = NumberFormat.getNumberInstance();
        ((DecimalFormat)formatter).setParseBigDecimal(true);
        ((DecimalFormat)formatter).setDecimalSeparatorAlwaysShown(true);
        String string = null;
        try {
            BudgetDecimal number = (BudgetDecimal)((Object)obj);
            string = formatter.format(number.doubleValue());
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("formatting", "error.bigDecimal", obj.toString(), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new FormatException("formatting", "error.bigDecimal", obj.toString(), (Throwable)e);
        }
        if (obj.toString().length() > 15) {
            return obj.toString();
        }
        if (StringUtils.isNotBlank((String)string)) {
            if (string.indexOf(".") == string.length() - 1) {
                string = string + "00";
            } else if (string.indexOf(".") == string.length() - 2) {
                string = string + "0";
            }
        }
        return string;
    }
}

