/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public final class KraServiceLocator {
    private static ApplicationContext appContext;

    private KraServiceLocator() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void setAppContext(ApplicationContext appContext) {
        KraServiceLocator.appContext = appContext;
    }

    public static ApplicationContext getAppContext() {
        return appContext;
    }

    public static <T> T getService(String serviceName) {
        if (StringUtils.isBlank((String)serviceName)) {
            throw new IllegalArgumentException("the service name is blank.");
        }
        try {
            return (T)KraServiceLocator.getAppContext().getBean(serviceName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)GlobalResourceLoader.getService((String)serviceName);
        }
        catch (Exception ex) {
            return (T)GlobalResourceLoader.getService((String)serviceName);
        }
    }

    public static <T> T getService(Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("the service class is null.");
        }
        String name = serviceClass.getSimpleName().substring(0, 1).toLowerCase() + serviceClass.getSimpleName().substring(1);
        return KraServiceLocator.getService(name);
    }
}

