/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.infrastructure;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.util.StringUtils;
import org.kuali.rice.core.web.format.Formatter;

public class TimeFormatter
extends Formatter {
    private static final long serialVersionUID = 1L;
    private static final Pattern TIME_PATTERN_12_HOUR = Pattern.compile("(0?[1-9]|1[0-2])(?:(?::|\\.)([0-5][0-9]))?(?:\\s*(([ap]m?|[ap]\\.m\\.)))?", 2);
    private static final Pattern TIME_PATTERN_24_HOUR = Pattern.compile("([01][0-9]|2[0-3])(?:(?::|\\.)?([0-5][0-9]))(?:\\s*(([ap]m?|[ap]\\.m\\.)))?", 2);

    public Object convertToObject(String input) {
        if (!StringUtils.isEmpty((CharSequence)input)) {
            Matcher matcher = TIME_PATTERN_12_HOUR.matcher(input = input.trim());
            if (matcher.matches()) {
                return this.parseTwelveHourTime(matcher);
            }
            matcher = TIME_PATTERN_24_HOUR.matcher(input);
            if (matcher.matches()) {
                return this.parseTwentyFourHourTime(matcher);
            }
            return "Invalid Time";
        }
        return "";
    }

    private String parseTwelveHourTime(Matcher matcher) {
        String amPmMarker;
        String minute;
        String hour = matcher.group(1);
        if (hour.startsWith("0")) {
            hour = hour.substring(1);
        }
        if ((minute = matcher.group(2)) == null) {
            minute = "00";
        }
        if ((amPmMarker = matcher.group(3)) == null) {
            amPmMarker = "12".equals(hour) ? "PM" : "AM";
        } else if ((amPmMarker = amPmMarker.replaceAll("\\.", "").toUpperCase()).length() == 1) {
            amPmMarker = amPmMarker + "M";
        }
        return hour + ":" + minute + " " + amPmMarker;
    }

    private String parseTwentyFourHourTime(Matcher matcher) {
        String hour = matcher.group(1);
        String minute = matcher.group(2);
        int intHour = Integer.parseInt(hour);
        String amPmMarker = "AM";
        if (intHour == 0) {
            intHour = 12;
        } else if (intHour >= 12) {
            amPmMarker = "PM";
            intHour -= 12;
        }
        if (minute == null) {
            minute = "00";
        }
        return intHour + ":" + minute + " " + amPmMarker;
    }
}

