/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class InstitutionalProposalContactsBean
implements Serializable {
    private static final long serialVersionUID = -4211366507290652295L;
    private static final String PERSON_IDENTIFIER_FIELD = "personId";
    private static final String ROLODEX_IDENTIFIER_FIELD = "rolodexId";
    protected List<? extends ContactRole> contactRoles;
    protected InstitutionalProposalContact newInstitutionalProposalContact;
    protected InstitutionalProposalForm institutionalProposalForm;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;
    private String personId;
    private Integer rolodexId;

    public InstitutionalProposalContactsBean(InstitutionalProposalForm institutionalProposalForm) {
        this.institutionalProposalForm = institutionalProposalForm;
        this.init();
    }

    public List<? extends ContactRole> getContactRoles() {
        if (this.contactRoles == null) {
            this.contactRoles = (List)this.getBusinessObjectService().findAll(this.getContactRoleType());
        }
        return this.contactRoles;
    }

    protected abstract Class<? extends ContactRole> getContactRoleType();

    public String getContactRoleCode() {
        return this.newInstitutionalProposalContact.getContactRole() != null ? this.newInstitutionalProposalContact.getContactRole().getRoleCode() : null;
    }

    public InstitutionalProposalContact getNewInstitutionalProposalContact() {
        return this.newInstitutionalProposalContact;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setContactRoleCode(String contactRoleCode) {
        ContactRole matchingRole = this.findMatchingContactRole(this.getContactRoles(), contactRoleCode);
        this.newInstitutionalProposalContact.setContactRole(matchingRole);
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        KcPerson person = personId != null ? (KcPerson)this.findContact(PERSON_IDENTIFIER_FIELD, KcPerson.class, personId) : null;
        this.newInstitutionalProposalContact.setPerson(person);
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
        NonOrganizationalRolodex rolodex = rolodexId != null ? (NonOrganizationalRolodex)this.findContact(ROLODEX_IDENTIFIER_FIELD, NonOrganizationalRolodex.class, rolodexId) : null;
        this.newInstitutionalProposalContact.setRolodex(rolodex);
    }

    protected Object findContact(String identifierField, Class contactClass, Object contactIdentifier) {
        if (KcPerson.class.isAssignableFrom(contactClass)) {
            return this.getKcPersonService().getKcPersonByPersonId((String)contactIdentifier);
        }
        HashMap<String, Object> identifierMap = new HashMap<String, Object>();
        identifierMap.put(identifierField, contactIdentifier);
        return this.getBusinessObjectService().findByPrimaryKey(contactClass, identifierMap);
    }

    protected ContactRole findMatchingContactRole(Collection<? extends ContactRole> roles, String contactRoleCode) {
        ContactRole matchingRole = null;
        for (ContactRole contactRole : roles) {
            if (!contactRole.getRoleCode().equals(contactRoleCode)) continue;
            matchingRole = contactRole;
            break;
        }
        return matchingRole;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected void init() {
        this.newInstitutionalProposalContact = this.createNewContact();
        this.personId = null;
        this.rolodexId = null;
    }

    protected abstract InstitutionalProposalContact createNewContact();

    protected InstitutionalProposal getInstitutionalProposal() {
        return this.getDocument().getInstitutionalProposal();
    }

    protected InstitutionalProposalDocument getDocument() {
        return this.institutionalProposalForm.getInstitutionalProposalDocument();
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }
}

