/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplitRuleEvent;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplitRuleImpl;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplitRuleEvent;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplitRuleImpl;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.proposaldevelopment.bo.CreditSplit;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;

public class InstitutionalProposalCreditSplitBean
implements Serializable {
    private static final long serialVersionUID = 1033802859817554693L;
    static final String PERSON_TOTALS_KEY = "personTotalsKey";
    private static Log LOGGER = LogFactory.getLog(InstitutionalProposalCreditSplitBean.class);
    private static final String PARM_TYPE_CODE = "D";
    private static final String YES = "Y";
    private static final String PROPOSAL_CREDIT_SPLIT_PARM_NAME = "institutionalproposal.creditsplit.enabled";
    private static final KualiDecimal ZERO_VALUE = new KualiDecimal(0);
    private static final KualiDecimal MAX_VALUE = new KualiDecimal(100.0);
    private InstitutionalProposalForm institutionalProposalForm;
    private InstitutionalProposalDocument institutionalProposalDocument;
    private transient Collection<InvestigatorCreditType> investigatorCreditTypes;
    private transient ParameterService parameterService;

    public InstitutionalProposalCreditSplitBean(InstitutionalProposalForm institutionalProposalForm) {
        this.institutionalProposalForm = institutionalProposalForm;
    }

    public InstitutionalProposalCreditSplitBean(InstitutionalProposalDocument institutionalProposalDocument) {
        this.institutionalProposalDocument = institutionalProposalDocument;
    }

    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        if (this.investigatorCreditTypes == null || this.investigatorCreditTypes.size() == 0) {
            this.investigatorCreditTypes = this.loadInvestigatorCreditTypes();
        }
        return this.investigatorCreditTypes;
    }

    public Map<String, KualiDecimal> getPersonsTotalsMap() {
        return this.calculateCreditSplitTotals().get(PERSON_TOTALS_KEY);
    }

    public InstitutionalProposalPerson getProjectPerson(int index) {
        return this.getProjectPersons().get(index);
    }

    public List<InstitutionalProposalPerson> getProjectPersons() {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        List<InstitutionalProposalPerson> projectPersons = this.getInstitutionalProposal().getProjectPersons();
        for (InstitutionalProposalPerson p : projectPersons) {
            this.createDefaultCreditSplitMapForProjectPerson(creditTypes, p);
            for (InstitutionalProposalPersonUnit apu : p.getUnits()) {
                this.createDefaultCreditSplitMapForPersonUnit(creditTypes, apu);
            }
        }
        return this.getInstitutionalProposal().getProjectPersons();
    }

    public Map<String, Map<String, KualiDecimal>> getUnitTotalsMap() {
        return this.calculateCreditSplitTotals();
    }

    public boolean isInstitutionalProposalCreditsLimitApplicable() {
        try {
            String parmValue = this.fetchParameterValue(PROPOSAL_CREDIT_SPLIT_PARM_NAME);
            return parmValue.equalsIgnoreCase(YES);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean recalculateCreditSplit() {
        boolean noErrors = true;
        if (this.isInstitutionalProposalCreditsLimitApplicable()) {
            Map<String, Map<String, KualiDecimal>> totalsMap = this.calculateCreditSplitTotals();
            noErrors = this.checkIfPersonTotalsAreValid(totalsMap);
            noErrors &= this.checkIfPersonUnitsTotalsAreValid(totalsMap);
        }
        return noErrors;
    }

    protected String fetchParameterValue(String parmName) {
        return this.getParameterService().getParameterValueAsString(InstitutionalProposalDocument.class, parmName);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    Map<String, Map<String, KualiDecimal>> calculateCreditSplitTotals() {
        HashMap<String, Map<String, KualiDecimal>> allCreditSplitTotals = new HashMap<String, Map<String, KualiDecimal>>();
        this.calculatePersonTotals(allCreditSplitTotals);
        this.calculatePersonUnitTotals(allCreditSplitTotals);
        return allCreditSplitTotals;
    }

    InstitutionalProposal getInstitutionalProposal() {
        InstitutionalProposal institutionalProposal = this.institutionalProposalForm != null ? this.institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal() : (this.institutionalProposalDocument != null ? this.institutionalProposalDocument.getInstitutionalProposal() : null);
        return institutionalProposal;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }

    private void calculatePersonTotalForCreditSplitType(InstitutionalProposalPerson projectPerson, InvestigatorCreditType creditType, Map<String, KualiDecimal> personCreditSplitTotalMap) {
        String creditTypeCode = creditType.getInvCreditTypeCode();
        KualiDecimal personsTotalCredit = personCreditSplitTotalMap.get(creditTypeCode);
        if (personsTotalCredit == null) {
            personsTotalCredit = ZERO_VALUE;
        }
        for (CreditSplit creditSplit : projectPerson.getCreditSplits()) {
            if (!creditSplit.getInvCreditTypeCode().equals(creditTypeCode)) continue;
            personCreditSplitTotalMap.put(creditTypeCode, (KualiDecimal)personsTotalCredit.add((AbstractKualiDecimal)creditSplit.getCredit()));
        }
    }

    private void calculatePersonTotals(Map<String, Map<String, KualiDecimal>> allCreditSplitTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        Map<String, KualiDecimal> personCreditSplitTotalMap = this.initializePersonCreditSplitTotalMap(allCreditSplitTotals);
        for (InstitutionalProposalPerson projectPerson : this.getProjectPersons()) {
            for (InvestigatorCreditType creditType : creditTypes) {
                this.calculatePersonTotalForCreditSplitType(projectPerson, creditType, personCreditSplitTotalMap);
            }
        }
    }

    private void calculatePersonUnitTotals(Map<String, Map<String, KualiDecimal>> allCreditSplitTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        for (InstitutionalProposalPerson projectPerson : this.getProjectPersons()) {
            String personKey = this.getPersonKey(projectPerson);
            Map<String, KualiDecimal> personUnitCreditTotals = allCreditSplitTotals.get(personKey);
            if (personUnitCreditTotals == null) {
                personUnitCreditTotals = new HashMap<String, KualiDecimal>();
                allCreditSplitTotals.put(personKey, personUnitCreditTotals);
            }
            for (InvestigatorCreditType creditType : creditTypes) {
                String creditTypeCode;
                KualiDecimal totalCredit = personUnitCreditTotals.get(creditTypeCode = creditType.getInvCreditTypeCode());
                personUnitCreditTotals.put(creditTypeCode, totalCredit != null ? totalCredit : ZERO_VALUE);
            }
            this.calculateUnitCreditSplitTotals(projectPerson, personUnitCreditTotals);
        }
    }

    private void calculateUnitCreditSplitTotals(InstitutionalProposalPerson projectPerson, Map<String, KualiDecimal> personUnitCreditTotals) {
        if (projectPerson.isKeyPerson() && projectPerson.getUnits().size() == 0) {
            this.handleKeyPersonWithNoUnits(personUnitCreditTotals);
        } else {
            for (InstitutionalProposalPersonUnit unit : projectPerson.getUnits()) {
                for (CreditSplit creditSplit : unit.getCreditSplits()) {
                    KualiDecimal totalCredit = personUnitCreditTotals.get(creditSplit.getInvCreditTypeCode());
                    if (totalCredit == null) {
                        totalCredit = ZERO_VALUE;
                    }
                    personUnitCreditTotals.put(creditSplit.getInvCreditTypeCode(), (KualiDecimal)totalCredit.add((AbstractKualiDecimal)creditSplit.getCredit()));
                }
            }
        }
    }

    private void handleKeyPersonWithNoUnits(Map<String, KualiDecimal> personUnitCreditTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        for (InvestigatorCreditType creditType : creditTypes) {
            personUnitCreditTotals.put(creditType.getInvCreditTypeCode(), MAX_VALUE);
        }
    }

    private boolean checkIfPersonTotalsAreValid(Map<String, Map<String, KualiDecimal>> totalsMap) {
        InstitutionalProposalPersonCreditSplitRuleImpl rule = new InstitutionalProposalPersonCreditSplitRuleImpl();
        InstitutionalProposalPersonCreditSplitRuleEvent event = new InstitutionalProposalPersonCreditSplitRuleEvent((Document)this.institutionalProposalDocument, totalsMap.get(PERSON_TOTALS_KEY));
        return rule.checkInstitutionalProposalPersonCreditSplitTotals(event);
    }

    private boolean checkIfPersonUnitsTotalsAreValid(Map<String, Map<String, KualiDecimal>> totalsMap) {
        InstitutionalProposalPersonUnitCreditSplitRuleImpl rule = new InstitutionalProposalPersonUnitCreditSplitRuleImpl();
        boolean success = true;
        for (InstitutionalProposalPerson projectPerson : this.getInstitutionalProposal().getProjectPersons()) {
            InstitutionalProposalPersonUnitCreditSplitRuleEvent event = new InstitutionalProposalPersonUnitCreditSplitRuleEvent((Document)this.institutionalProposalDocument, projectPerson, totalsMap.get(this.getPersonKey(projectPerson)));
            success &= rule.checkInstitutionalProposalPersonUnitCreditSplitTotals(event);
        }
        return success;
    }

    private void createDefaultCreditSplitMapForPersonUnit(Collection<InvestigatorCreditType> creditTypes, InstitutionalProposalPersonUnit apu) {
        HashMap<InvestigatorCreditType, InstitutionalProposalPersonUnitCreditSplit> personUnitCreditMap = new HashMap<InvestigatorCreditType, InstitutionalProposalPersonUnitCreditSplit>();
        for (InstitutionalProposalPersonUnitCreditSplit apuCreditSplit : apu.getCreditSplits()) {
            personUnitCreditMap.put(apuCreditSplit.getInvestigatorCreditType(), apuCreditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personUnitCreditMap.get((Object)creditType) != null) continue;
            apu.add(new InstitutionalProposalPersonUnitCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private void createDefaultCreditSplitMapForProjectPerson(Collection<InvestigatorCreditType> creditTypes, InstitutionalProposalPerson projectPerson) {
        HashMap<InvestigatorCreditType, InstitutionalProposalPersonCreditSplit> personCreditMap = new HashMap<InvestigatorCreditType, InstitutionalProposalPersonCreditSplit>();
        for (InstitutionalProposalPersonCreditSplit creditSplit : projectPerson.getCreditSplits()) {
            personCreditMap.put(creditSplit.getInvestigatorCreditType(), creditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personCreditMap.get((Object)creditType) != null) continue;
            projectPerson.add(new InstitutionalProposalPersonCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private String getPersonKey(InstitutionalProposalPerson projectPerson) {
        return projectPerson.getFullName();
    }

    private Map<String, KualiDecimal> initializePersonCreditSplitTotalMap(Map<String, Map<String, KualiDecimal>> allCreditSplitTotals) {
        Map<String, KualiDecimal> personCreditTypeTotals = allCreditSplitTotals.get(PERSON_TOTALS_KEY);
        if (personCreditTypeTotals == null) {
            personCreditTypeTotals = new HashMap<String, KualiDecimal>();
            allCreditSplitTotals.put(PERSON_TOTALS_KEY, personCreditTypeTotals);
        }
        return personCreditTypeTotals;
    }
}

