/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class InstitutionalProposalPerson
extends InstitutionalProposalContact
implements PersonRolodex,
AbstractProjectPerson {
    private static final long serialVersionUID = -5406431014745059361L;
    private KualiDecimal academicYearEffort;
    private KualiDecimal calendarYearEffort;
    private boolean faculty;
    private KualiDecimal summerEffort;
    private KualiDecimal totalEffort;
    private String keyPersonRole;
    private List<InstitutionalProposalPersonUnit> units;
    private List<InstitutionalProposalPersonCreditSplit> creditSplits;
    private boolean multiplePi;

    public InstitutionalProposalPerson() {
        this.init();
    }

    public InstitutionalProposalPerson(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        super(rolodex, contactRole);
        this.init();
    }

    public InstitutionalProposalPerson(KcPerson person, ContactRole role) {
        super(person, role);
        this.init();
    }

    public void add(InstitutionalProposalPersonCreditSplit creditSplit) {
        this.creditSplits.add(creditSplit);
        creditSplit.setInstitutionalProposalPerson(this);
    }

    public void add(InstitutionalProposalPersonUnit institutionalProposalPersonUnit) {
        this.units.add(institutionalProposalPersonUnit);
        institutionalProposalPersonUnit.setInstitutionalProposalPerson(this);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getUnits());
        return managedLists;
    }

    public Unit findLeadUnit() {
        return InstitutionalProposalPersonUnit.findLeadUnit(this.units);
    }

    public KualiDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public KualiDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public InstitutionalProposalPersonCreditSplit getCreditSplit(int index) {
        return this.creditSplits.get(index);
    }

    public List<InstitutionalProposalPersonCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public KualiDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public KualiDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public InstitutionalProposalPersonUnit getUnit(int index) {
        return this.units.get(index);
    }

    public List<InstitutionalProposalPersonUnit> getUnits() {
        return this.units;
    }

    public boolean isCoInvestigator() {
        return this.getContactRole() != null && this.getContactRole().getRoleCode().equals("COI");
    }

    public boolean isFaculty() {
        return this.faculty;
    }

    public boolean isKeyPerson() {
        return this.getContactRole() != null && this.getContactRole().getRoleCode().equals("KP");
    }

    public boolean isPrincipalInvestigator() {
        return this.getContactRole() != null && this.getContactRole().getRoleCode().equals("PI");
    }

    public void setAcademicYearEffort(KualiDecimal academicYearEffort) {
        this.academicYearEffort = academicYearEffort;
    }

    public void setCalendarYearEffort(KualiDecimal calendarYearEffort) {
        this.calendarYearEffort = calendarYearEffort;
    }

    public void setCreditSplits(List<InstitutionalProposalPersonCreditSplit> creditSplits) {
        this.creditSplits = creditSplits;
    }

    public void initializeDefaultCreditSplits() {
        List creditTypes = (List)this.getBusinessObjectService().findAll(InvestigatorCreditType.class);
        for (InvestigatorCreditType creditType : creditTypes) {
            InstitutionalProposalPersonCreditSplit creditSplit = new InstitutionalProposalPersonCreditSplit(creditType, new KualiDecimal(0));
            this.add(creditSplit);
        }
    }

    public void setFaculty(boolean faculty) {
        this.faculty = faculty;
    }

    public void setSummerEffort(KualiDecimal summerEffort) {
        this.summerEffort = summerEffort;
    }

    public void setTotalEffort(KualiDecimal totalEffort) {
        this.totalEffort = totalEffort;
    }

    public void setUnits(List<InstitutionalProposalPersonUnit> units) {
        this.units = units;
    }

    public String toString() {
        return String.format("%s:%s", this.getContact().getIdentifier().toString(), this.getContact().getFullName());
    }

    protected Class getContactRoleType() {
        return ProposalPersonRole.class;
    }

    @Override
    protected String getContactRoleTypeIdentifier() {
        return "proposalPersonRoleId";
    }

    protected void init() {
        this.units = new ArrayList<InstitutionalProposalPersonUnit>();
        this.creditSplits = new ArrayList<InstitutionalProposalPersonCreditSplit>();
    }

    @Override
    public String getProjectRole() {
        return this.getContactRole().getRoleDescription();
    }

    @Override
    public boolean isOtherSignificantContributorFlag() {
        return false;
    }

    public String getKeyPersonRole() {
        return this.keyPersonRole;
    }

    public void setKeyPersonRole(String keyPersonRole) {
        this.keyPersonRole = keyPersonRole;
    }

    @Override
    public void resetPersistenceState() {
        this.setInstitutionalProposalContactId(null);
    }

    @Override
    public boolean isMultiplePi() {
        return this.multiplePi;
    }

    public void setMultiplePi(boolean multiplePi) {
        this.multiplePi = multiplePi;
    }

    @Override
    public Sponsorable getParent() {
        return this.getInstitutionalProposal();
    }

    @Override
    public String getInvestigatorRoleDescription() {
        return KraServiceLocator.getService(KeyPersonnelService.class).getPersonnelRoleDesc(this);
    }
}

