/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplitRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplitRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCreditSplitAuditError;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class InstitutionalProposalPersonCreditSplitRuleImpl
extends ResearchDocumentRuleBase
implements InstitutionalProposalPersonCreditSplitRule {
    private static final KualiDecimal MAX_TOTAL_VALUE = new KualiDecimal(100.0);

    @Override
    public boolean checkInstitutionalProposalPersonCreditSplitTotals(InstitutionalProposalPersonCreditSplitRuleEvent event) {
        boolean retval = true;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            KualiDecimal value = event.getTotalsByCreditSplitType().get(creditType.getInvCreditTypeCode());
            if (value == null) break;
            if (((KualiDecimal)MAX_TOTAL_VALUE.subtract((AbstractKualiDecimal)value)).isZero()) continue;
            InstitutionalProposalCreditSplitAuditError.addAuditError("error.award.person.credit.split.error", creditType.getDescription());
            retval = false;
        }
        return retval;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

