/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContactsProjectRoleValuesFinder;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class InstitutionalProposalPersonProjectRolesValuesFinder
extends InstitutionalProposalContactsProjectRoleValuesFinder {
    private KeyPersonnelService keyPersonnelService;

    @Override
    public List getKeyValues() {
        Collection roles = this.getKeyValuesService().findAll(ProposalPersonRole.class);
        InstitutionalProposalDocument institutionalProposalDocument = ((InstitutionalProposalForm)KNSGlobalVariables.getKualiForm()).getInstitutionalProposalDocument();
        InstitutionalProposal sponsorable = institutionalProposalDocument.getInstitutionalProposal();
        Map<String, String> roleDescriptions = this.getKeyPersonnelService().loadKeyPersonnelRoleDescriptions(sponsorable.isSponsorNihMultiplePi());
        ArrayList<ConcreteKeyValue> keyValues = new ArrayList<ConcreteKeyValue>();
        keyValues.add(new ConcreteKeyValue("", "select"));
        for (ProposalPersonRole role : roles) {
            boolean showRole = true;
            BufferedLogger.info("showRole = ", showRole);
            if (showRole) {
                String roleDescription = roleDescriptions.get(role.getRoleCode());
                keyValues.add(new ConcreteKeyValue(role.getProposalPersonRoleId(), roleDescription));
                BufferedLogger.info("Added role ", role.getProposalPersonRoleId());
                BufferedLogger.info("With description ", roleDescription);
            }
            BufferedLogger.info("Returning ", keyValues);
        }
        return keyValues;
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        if (this.keyPersonnelService == null) {
            this.keyPersonnelService = KraServiceLocator.getService(KeyPersonnelService.class);
        }
        return this.keyPersonnelService;
    }

    @Override
    protected Class<? extends ContactRole> getRoleType() {
        return ProposalPersonRole.class;
    }

    protected void setKeyPersonnelService(KeyPersonnelService keyPersonnelService) {
        this.keyPersonnelService = keyPersonnelService;
    }
}

