/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.BaseInstitutionalProposalContactAddRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonAddRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonRuleAddEvent;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalProjectPersonAddRuleImpl
extends BaseInstitutionalProposalContactAddRule
implements InstitutionalProposalProjectPersonAddRule {
    @Override
    public boolean processAddInstitutionalProposalProjectPersonBusinessRules(InstitutionalProposalProjectPersonRuleAddEvent event) {
        InstitutionalProposalPerson newProjectPerson = event.getNewProjectPerson();
        InstitutionalProposal institutionalProposal = ((InstitutionalProposalDocument)event.getDocument()).getInstitutionalProposal();
        return this.checkForSelectedContactAndRole(newProjectPerson) && this.checkForExistingPrincipalInvestigators(institutionalProposal, newProjectPerson) & this.checkForDuplicatePerson(institutionalProposal, newProjectPerson);
    }

    boolean checkForSelectedContactAndRole(InstitutionalProposalContact newContact) {
        return super.checkForSelectedContactAndRole(newContact, "projectPersonnelBean.contactRoleCode");
    }

    boolean checkForExistingPrincipalInvestigators(InstitutionalProposal institutionalProposal, InstitutionalProposalPerson newProjectPerson) {
        boolean valid = true;
        if (newProjectPerson.isPrincipalInvestigator()) {
            for (InstitutionalProposalPerson p : institutionalProposal.getProjectPersons()) {
                if (!p.isPrincipalInvestigator()) continue;
                valid = false;
                break;
            }
        }
        if (!valid) {
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.contactRoleCode", "error.institutionalProposalProjectPerson.pi.exists", new String[0]);
        }
        return valid;
    }

    boolean checkForDuplicatePerson(InstitutionalProposal institutionalProposal, InstitutionalProposalPerson newProjectPerson) {
        boolean valid = true;
        for (InstitutionalProposalPerson p : institutionalProposal.getProjectPersons()) {
            if (!p.getClass().equals(newProjectPerson.getClass()) || !p.getContact().getIdentifier().equals(newProjectPerson.getContact().getIdentifier()) || !this.isProjectPersonInvestigator(p) || !this.isProjectPersonInvestigator(newProjectPerson)) continue;
            valid = false;
            break;
        }
        if (!valid) {
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.contactRoleCode", "error.institutionalProposalProjectPerson.person.exists", new String[]{newProjectPerson.getContact().getFullName()});
        }
        return valid;
    }

    private boolean isProjectPersonInvestigator(InstitutionalProposalPerson projectPerson) {
        return projectPerson.isCoInvestigator() || projectPerson.isPrincipalInvestigator();
    }

    boolean checkForDuplicateUnits(List<InstitutionalProposalPerson> projectPersons) {
        boolean valid = true;
        for (InstitutionalProposalPerson p : projectPersons) {
            HashSet<Unit> uniqueUnits = new HashSet<Unit>();
            ArrayList<Unit> tempUnits = new ArrayList<Unit>();
            for (InstitutionalProposalPersonUnit apu : p.getUnits()) {
                uniqueUnits.add(apu.getUnit());
                tempUnits.add(apu.getUnit());
            }
            if (valid &= tempUnits.size() == uniqueUnits.size()) continue;
            this.removeUniqueUnitsFromAllUnits(uniqueUnits, tempUnits);
            this.reportDuplicateUnits(p, tempUnits);
        }
        return valid;
    }

    private void reportDuplicateUnits(InstitutionalProposalPerson p, List<Unit> tempUnits) {
        HashSet<Unit> duplicateUnits = new HashSet<Unit>(tempUnits);
        for (Unit dupeUnit : duplicateUnits) {
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.contactRoleCode", "error.institutionalProposalProjectPerson.duplicate.units", new String[]{dupeUnit.getUnitName(), dupeUnit.getUnitNumber(), p.getFullName()});
        }
    }

    private void removeUniqueUnitsFromAllUnits(Set<Unit> uniqueUnits, List<Unit> tempUnits) {
        for (Unit u : uniqueUnits) {
            tempUnits.remove((Object)u);
        }
    }
}

