/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.document;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

@ParameterConstants.NAMESPACE(namespace="KC-IP")
@ParameterConstants.COMPONENT(component="Document")
public class InstitutionalProposalDocument
extends ResearchDocumentBase {
    private static final Log LOG = LogFactory.getLog(InstitutionalProposalDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "INPR";
    private static final long serialVersionUID = 5101782927161970631L;
    private List<InstitutionalProposal> institutionalProposalList;

    public InstitutionalProposalDocument() {
        this.init();
    }

    public InstitutionalProposal getInstitutionalProposal() {
        return this.institutionalProposalList.get(0);
    }

    public void setInstitutionalProposal(InstitutionalProposal institutionalProposal) {
        this.institutionalProposalList.set(0, institutionalProposal);
    }

    public List<InstitutionalProposal> getInstitutionalProposalList() {
        return this.institutionalProposalList;
    }

    public void setInstitutionalProposalList(List<InstitutionalProposal> institutionalProposalList) {
        this.institutionalProposalList = institutionalProposalList;
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    protected void init() {
        this.institutionalProposalList = new ArrayList<InstitutionalProposal>();
        this.institutionalProposalList.add(new InstitutionalProposal());
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposal();
        managedLists.add(institutionalProposal.getInstitutionalProposalUnitContacts());
        managedLists.add(institutionalProposal.getInstitutionalProposalScienceKeywords());
        managedLists.add(institutionalProposal.getInstitutionalProposalCostShares());
        managedLists.add(institutionalProposal.getInstitutionalProposalUnrecoveredFandAs());
        managedLists.add(institutionalProposal.getAwardFundingProposals());
        ArrayList specialReviewExemptions = new ArrayList();
        for (InstitutionalProposalSpecialReview specialReview : this.getInstitutionalProposal().getSpecialReviews()) {
            specialReviewExemptions.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(specialReviewExemptions);
        managedLists.add(institutionalProposal.getSpecialReviews());
        ArrayList<InstitutionalProposalPersonUnit> units = new ArrayList<InstitutionalProposalPersonUnit>();
        ArrayList<InstitutionalProposalPersonCreditSplit> creditSplits = new ArrayList<InstitutionalProposalPersonCreditSplit>();
        for (InstitutionalProposalPerson person : institutionalProposal.getProjectPersons()) {
            units.addAll(person.getUnits());
            creditSplits.addAll(person.getCreditSplits());
        }
        managedLists.add(units);
        managedLists.add(creditSplits);
        managedLists.add(institutionalProposal.getProjectPersons());
        return managedLists;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        String newStatus = statusChangeEvent.getNewRouteStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("********************* Status Change: from %s to %s", statusChangeEvent.getOldRouteStatus(), newStatus));
        }
        if ("P".equalsIgnoreCase(newStatus)) {
            this.getInstitutionalProposalVersioningService().updateInstitutionalProposalVersionStatus(this.getInstitutionalProposal(), VersionStatus.ACTIVE);
        }
        if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
            this.getInstitutionalProposalVersioningService().updateInstitutionalProposalVersionStatus(this.getInstitutionalProposal(), VersionStatus.CANCELED);
        }
    }

    private InstitutionalProposalVersioningService getInstitutionalProposalVersioningService() {
        return KraServiceLocator.getService(InstitutionalProposalVersioningService.class);
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getInstitutionalProposal().getInstProposalNumber() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getInstitutionalProposal().getInstitutionalProposalCustomDataList();
    }
}

