/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.home;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.InstitutionalProposalAssociate;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalNotepad
extends InstitutionalProposalAssociate
implements SequenceAssociate {
    private static final long serialVersionUID = 1L;
    private Long proposalNotepadId;
    private String proposalNumber;
    private Integer entryNumber;
    private String comments;
    private String noteTopic;
    private boolean restrictedView;
    private Date createTimestamp;
    private String createUser;
    private Long noteId;
    private List<Note> attachments;

    public InstitutionalProposalNotepad() {
        Calendar cl = Calendar.getInstance();
        this.setCreateTimestamp(new Date(cl.getTime().getTime()));
        this.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        this.attachments = new ArrayList<Note>();
    }

    public Long getProposalNotepadId() {
        return this.proposalNotepadId;
    }

    public void setProposalNotepadId(Long proposalNotepadId) {
        this.proposalNotepadId = proposalNotepadId;
    }

    @Override
    public String getProposalNumber() {
        return this.proposalNumber;
    }

    @Override
    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Integer getEntryNumber() {
        return this.entryNumber;
    }

    public void setEntryNumber(Integer entryNumber) {
        this.entryNumber = entryNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean getRestrictedView() {
        return this.restrictedView;
    }

    public void setRestrictedView(boolean restrictedView) {
        this.restrictedView = restrictedView;
    }

    public String getNoteTopic() {
        return this.noteTopic;
    }

    public void setNoteTopic(String noteTopic) {
        this.noteTopic = noteTopic;
    }

    public Date getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Date createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public SequenceOwner getSequenceOwner() {
        return this.getInstitutionalProposal();
    }

    public void setSequenceOwner(SequenceOwner newlyVersionedOwner) {
        this.setInstitutionalProposal((InstitutionalProposal)newlyVersionedOwner);
    }

    @Override
    public void resetPersistenceState() {
        this.proposalNotepadId = null;
    }

    @Override
    protected void postPersist() {
        NoteService noteService = KraServiceLocator.getService(NoteService.class);
        for (Note note : this.getAttachments()) {
            if (!StringUtils.isBlank((String)note.getRemoteObjectIdentifier())) continue;
            note.setRemoteObjectIdentifier(this.getObjectId());
            noteService.save(note);
        }
        if (!(this.getAttachments().isEmpty() || this.getNoteId() != null && this.getNoteId() == this.getAttachments().get(0).getNoteIdentifier())) {
            this.setNoteId(this.getAttachments().get(0).getNoteIdentifier());
            KraServiceLocator.getService(BusinessObjectService.class).save((PersistableBusinessObject)this);
        }
    }

    public List<Note> getAttachments() {
        Note note;
        if (this.attachments.isEmpty() && this.getNoteId() != null && (note = KraServiceLocator.getService(NoteService.class).getNoteByNoteId(this.getNoteId())) != null) {
            this.attachments.add(note);
        }
        if (this.attachments.isEmpty() && StringUtils.isNotEmpty((String)this.getObjectId())) {
            this.attachments = KraServiceLocator.getService(NoteService.class).getByRemoteObjectId(this.getObjectId());
            if (!this.attachments.isEmpty()) {
                this.setNoteId(this.attachments.get(0).getNoteIdentifier());
            }
        }
        return this.attachments;
    }

    public void setAttachments(List<Note> attachments) {
        this.attachments = attachments;
    }

    public Long getNoteId() {
        return this.noteId;
    }

    public void setNoteId(Long noteId) {
        this.noteId = noteId;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public String getCreateUserName() {
        Person tempUser = KraServiceLocator.getService(PersonService.class).getPersonByPrincipalName(this.getCreateUser());
        return tempUser != null ? tempUser.getName() : this.getCreateUser();
    }

    public void setCreateUser(String createUser) {
        if (!"kr".equals(createUser)) {
            this.createUser = StringUtils.substring((String)createUser, (int)0, (int)60);
        }
    }
}

