/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.ipreview;

import java.io.Serializable;
import java.util.Map;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.ipreview.IntellectualPropertyReview;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalVersioningService;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.service.VersionException;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class IntellectualPropertyReviewMaintainableImpl
extends KraMaintainableImpl
implements Maintainable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            IntellectualPropertyReview ipReview = (IntellectualPropertyReview)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            ipReview.setIpReviewer(principalId);
        }
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (this.businessObject != null && this.businessObject instanceof IntellectualPropertyReview) {
            try {
                IntellectualPropertyReview newVersion = this.getInstitutionalProposalVersioningService().createNewIntellectualPropertyReviewVersion((IntellectualPropertyReview)this.businessObject);
                this.setBusinessObject((PersistableBusinessObject)newVersion);
            }
            catch (VersionException ve) {
                throw new RuntimeException("Caught exception versioning intellectual property review: " + ve);
            }
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        String proposalIdToLink = parameters.get("proposalId")[0];
        ((IntellectualPropertyReview)this.getBusinessObject()).setProposalIdToLink(Long.parseLong(proposalIdToLink));
    }

    private InstitutionalProposalVersioningService getInstitutionalProposalVersioningService() {
        return KraServiceLocator.getService(InstitutionalProposalVersioningService.class);
    }
}

