/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogDocumentAuthorizer;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.exception.DocumentAuthorizationException;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class ProposalLogLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = -7638045643796948730L;
    private static final String USERNAME_FIELD = "person.userName";
    private static final String STATUS_PENDING = "1";
    private static final String DOC_ROUTE_STATUS = "docRouteStatus";
    private boolean isLookupForProposalCreation;
    private DocumentService documentService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        String userName = (String)lookupForm.getFieldsForLookup().get(USERNAME_FIELD);
        if (!StringUtils.isBlank((String)userName)) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(userName);
            if (person != null) {
                lookupForm.getFieldsForLookup().put("piId", person.getPersonId());
            }
            lookupForm.getFieldsForLookup().remove(USERNAME_FIELD);
        }
        Collection results = super.performLookup(lookupForm, resultTable, bounded);
        if (StringUtils.containsIgnoreCase((String)lookupForm.getBackLocation(), (String)"negotiationNegotiation")) {
            return this.cleanSearchResultsForNegotiationLookup(results);
        }
        return results;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.checkIsLookupForProposalCreation(fieldValues.get("backLocation"));
        List results = super.getSearchResults(fieldValues);
        String returnLocation = fieldValues.get("backLocation");
        List<ProposalLog> searchList = this.filterForPermissions(results);
        if (StringUtils.containsIgnoreCase((String)returnLocation, (String)"negotiationNegotiation")) {
            return this.cleanSearchResultsForNegotiationLookup(searchList);
        }
        return searchList;
    }

    protected List<ProposalLog> filterForPermissions(List<ProposalLog> results) {
        Person user = GlobalVariables.getUserSession().getPerson();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        ArrayList<ProposalLog> proposalLogs = new ArrayList<ProposalLog>();
        ProposalLogDocumentAuthorizer authorizer = new ProposalLogDocumentAuthorizer();
        ArrayList<String> proposalIds = new ArrayList<String>();
        fieldValues.put("name", this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(ProposalLog.class));
        ArrayList<String> docTypeIds = new ArrayList<String>();
        for (DocumentType docType : (List)this.getBusinessObjectService().findMatching(DocumentType.class, fieldValues)) {
            docTypeIds.add(docType.getDocumentTypeId());
        }
        fieldValues.clear();
        fieldValues.put("documentTypeId", docTypeIds);
        fieldValues.put(DOC_ROUTE_STATUS, "F");
        List docHeaders = (List)this.getBusinessObjectService().findMatching(DocumentRouteHeaderValue.class, fieldValues);
        for (DocumentRouteHeaderValue docHeader : docHeaders) {
            try {
                MaintenanceDocumentBase doc = (MaintenanceDocumentBase)this.documentService.getByDocumentHeaderId(docHeader.getDocumentId());
                for (ProposalLog proposalLog : results) {
                    ProposalLog proposalLogDoc = (ProposalLog)doc.getNoteTarget();
                    if (proposalLog.getProposalNumber() == null || proposalLogDoc.getProposalNumber() == null || !proposalLog.getProposalNumber().equalsIgnoreCase(proposalLogDoc.getProposalNumber()) || proposalIds.contains(proposalLog.getProposalNumber())) continue;
                    proposalIds.add(proposalLog.getProposalNumber());
                    if (!authorizer.canOpen((Document)doc, user)) continue;
                    proposalLogs.add(proposalLog);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return proposalLogs;
    }

    private List<ProposalLog> cleanSearchResultsForNegotiationLookup(Collection searchResults) {
        ArrayList<ProposalLog> newResults = new ArrayList<ProposalLog>();
        for (ProposalLog pl : (List)searchResults) {
            if (!StringUtils.isBlank((String)pl.getInstProposalNumber())) continue;
            newResults.add(pl);
        }
        return newResults;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList();
        if (this.isLookupForProposalCreation) {
            if (STATUS_PENDING.equals(((ProposalLog)businessObject).getLogStatus())) {
                htmlDataList.add((HtmlData)this.getSelectLinkForProposalCreation((ProposalLog)businessObject));
            }
        } else {
            htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
            if (((ProposalLog)businessObject).isMergeCandidate()) {
                htmlDataList.add((HtmlData)this.getMergeLink(((ProposalLog)businessObject).getProposalNumber()));
            }
            if (((ProposalLog)businessObject).isSubmitted()) {
                this.removeEditLink(htmlDataList);
            }
            htmlDataList.add((HtmlData)this.getPrintLink(((ProposalLog)businessObject).getProposalNumber()));
        }
        return htmlDataList;
    }

    public List<Row> getRows() {
        if (this.getParameters().containsKey("returnLocation") && ((String[])this.getParameters().get("returnLocation"))[0].indexOf("institutionalProposalCreate") > 0) {
            this.isLookupForProposalCreation = true;
        }
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals(USERNAME_FIELD)) {
                    field.setFieldConversions("principalName:person.userName,principalId:personId");
                }
                if (!field.getPropertyName().equals("logStatus") || !this.isLookupForProposalCreation) continue;
                field.setPropertyValue(STATUS_PENDING);
            }
        }
        return rows;
    }

    protected HtmlData.AnchorHtmlData getSelectLinkForProposalCreation(ProposalLog proposalLog) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("select");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "InstitutionalProposalDocument");
        parameters.put("proposalNumber", proposalLog.getProposalNumber());
        String href = UrlFactory.parameterizeUrl((String)"../institutionalProposalHome.do", (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMergeLink(String proposalNumber) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("merge");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "pageEntry");
        parameters.put("proposalLogNumber", proposalNumber);
        String href = UrlFactory.parameterizeUrl((String)"../mergeProposalLog.do", (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getPrintLink(String proposalNumber) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("print");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "printProposalLog");
        parameters.put("proposalNumber", proposalNumber);
        String href = UrlFactory.parameterizeUrl((String)"../printProposalLog.do", (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected void checkIsLookupForProposalCreation(String backLocation) {
        if (backLocation.contains("institutionalProposalCreate.do")) {
            this.isLookupForProposalCreation = true;
            Person user = GlobalVariables.getUserSession().getPerson();
            String instPropDocName = "InstitutionalProposalDocument";
            DocumentAuthorizer documentAuthorizer = KraServiceLocator.getService(DocumentDictionaryService.class).getDocumentAuthorizer(instPropDocName);
            DocumentPresentationController documentPresentationController = KraServiceLocator.getService(DocumentDictionaryService.class).getDocumentPresentationController(instPropDocName);
            LOG.debug((Object)"calling canInitiate from getNewDocument()");
            if (!documentPresentationController.canInitiate(instPropDocName) || !documentAuthorizer.canInitiate(instPropDocName, user)) {
                throw new DocumentAuthorizationException(user.getPrincipalName(), "initiate", instPropDocName);
            }
        }
    }

    protected void removeEditLink(List<HtmlData> htmlDataList) {
        int editLinkIndex = -1;
        int currentIndex = 0;
        for (HtmlData htmlData : htmlDataList) {
            if ("edit".equals(htmlData.getMethodToCall())) {
                editLinkIndex = currentIndex;
                break;
            }
            ++currentIndex;
        }
        if (editLinkIndex != -1) {
            htmlDataList.remove(editLinkIndex);
        }
    }

    protected KcPersonService getKcPersonService() {
        return KraServiceLocator.getService(KcPersonService.class);
    }
}

