/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog;

import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.service.FiscalYearMonthService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalLogMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = 4690638717398206040L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final int FISCAL_YEAR_OFFSET = 6;
    private transient DateTimeService dateTimeService;
    private transient FiscalYearMonthService fiscalYearMonthService;
    private transient InstitutionalProposalService institutionalProposalService;

    public boolean isNotesEnabled() {
        return true;
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            ProposalLog proposalLog = (ProposalLog)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            proposalLog.setPiId(principalId);
            if (proposalLog.getPerson() != null) {
                proposalLog.setLeadUnit(proposalLog.getPerson().getOrganizationIdentifier());
            }
        }
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        ProposalLog proposalLog = (ProposalLog)document.getNoteTarget();
        if (StringUtils.isBlank((String)proposalLog.getProposalNumber())) {
            this.setupDefaultValues(proposalLog);
            this.populateAuditProperties(proposalLog);
            proposalLog.setProposalNumber(this.getInstitutionalProposalService().getNextInstitutionalProposalNumber());
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        ProposalLog proposalLog = (ProposalLog)document.getNoteTarget();
        proposalLog.setCreateTimestamp(null);
        proposalLog.setCreateUser(null);
        proposalLog.setUpdateTimestamp(null);
        proposalLog.setUpdateUser(null);
        proposalLog.setFiscalMonth(null);
        proposalLog.setFiscalYear(null);
        proposalLog.setLogStatus(ProposalLogUtils.getProposalLogPendingStatusCode());
        proposalLog.setProposalLogTypeCode(ProposalLogUtils.getProposalLogPermanentTypeCode());
        this.populateAuditProperties(proposalLog);
        proposalLog.setProposalNumber(this.getInstitutionalProposalService().getNextInstitutionalProposalNumber());
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        ProposalLog proposalLog = (ProposalLog)this.getBusinessObject();
        if (proposalLog.isLogTypeTemporary() && StringUtils.equalsIgnoreCase((String)proposalLog.getLogStatus(), (String)ProposalLogUtils.getProposalLogPendingStatusCode())) {
            proposalLog.setLogStatus(ProposalLogUtils.getProposalLogTemporaryStatusCode());
        }
        proposalLog.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
        if (proposalLog.getPiId() != null) {
            proposalLog.setPiName(proposalLog.getPerson().getFullName());
        } else if (proposalLog.getRolodexId() != null) {
            proposalLog.refreshReferenceObject("rolodex");
            if (proposalLog.getRolodex() != null) {
                proposalLog.setPiName(proposalLog.getRolodex().getFullName());
            }
        }
    }

    private void setupDefaultValues(ProposalLog proposalLog) {
        if (StringUtils.isBlank((String)proposalLog.getLogStatus())) {
            if (proposalLog.isLogTypeTemporary()) {
                proposalLog.setLogStatus(ProposalLogUtils.getProposalLogTemporaryStatusCode());
            } else {
                proposalLog.setLogStatus(ProposalLogUtils.getProposalLogPendingStatusCode());
            }
        }
        if (StringUtils.isBlank((String)proposalLog.getProposalLogTypeCode())) {
            proposalLog.setProposalLogTypeCode(ProposalLogUtils.getProposalLogPermanentTypeCode());
        }
    }

    private void populateAuditProperties(ProposalLog proposalLog) {
        Timestamp currentTimestamp = this.getDateTimeService().getCurrentTimestamp();
        proposalLog.setFiscalMonth(this.getFiscalYearMonthService().getCurrentFiscalMonthForDisplay());
        proposalLog.setFiscalYear(this.getFiscalYearMonthService().getCurrentFiscalYear());
        proposalLog.setCreateTimestamp(currentTimestamp);
        proposalLog.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
    }

    private FiscalYearMonthService getFiscalYearMonthService() {
        if (this.fiscalYearMonthService == null) {
            this.fiscalYearMonthService = KraServiceLocator.getService(FiscalYearMonthService.class);
        }
        return this.fiscalYearMonthService;
    }

    private DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KraServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        if (this.institutionalProposalService == null) {
            this.institutionalProposalService = KraServiceLocator.getService(InstitutionalProposalService.class);
        }
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

