/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.TimeFormatter;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.kns.rules.MaintenanceDocumentRule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class ProposalLogMaintenanceDocumentRules
extends MaintenanceDocumentRuleBase
implements MaintenanceDocumentRule {
    private final String SPONSOR_CODE = "document.newMaintainableObject.sponsorCode";
    private final String SPONSOR_DEADLINE_TIME = "document.newMaintainableObject.deadlineTime";

    protected boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean valid = super.isDocumentValidForSave(document);
        ProposalLog proposalLog = (ProposalLog)document.getNewMaintainableObject().getDataObject();
        if (!this.isProposalStatusChangeValid(document)) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.logStatus", "error.proposalLog.invalidStatusChange", new String[]{proposalLog.getProposalLogStatus().getDescription()});
            valid = false;
        }
        if (ObjectUtils.isNotNull((Object)proposalLog.getPiId())) {
            proposalLog.refreshReferenceObject("person");
            if (proposalLog.getPerson() == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.piName", "error.proposalLog.invalidPi", new String[]{""});
                valid = false;
            }
        }
        if (ObjectUtils.isNotNull((Object)proposalLog.getRolodexId())) {
            proposalLog.refreshReferenceObject("rolodex");
            if (proposalLog.getRolodex() == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rolodexId", "error.proposalLog.invalidPi", new String[]{""});
                valid = false;
            }
        }
        if (ObjectUtils.isNotNull((Object)proposalLog.getPiId()) && ObjectUtils.isNotNull((Object)proposalLog.getRolodexId())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rolodexId", "error.proposalLog.multiplePi", new String[]{""});
            valid = false;
        }
        proposalLog.refreshReferenceObject("unit");
        if (StringUtils.isNotBlank((String)proposalLog.getLeadUnit()) && proposalLog.getUnit() == null) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.leadUnit", "error.proposalLog.invalidLeadUnit", new String[]{""});
            valid = false;
        }
        return valid &= this.isSponsorValid(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = super.processCustomRouteDocumentBusinessRules(document);
        ProposalLog proposalLog = (ProposalLog)document.getNewMaintainableObject().getDataObject();
        if (ObjectUtils.isNull((Object)proposalLog.getPiId()) && ObjectUtils.isNull((Object)proposalLog.getRolodexId())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.piId", "error.proposalLog.noPi", new String[]{""});
            valid = false;
        }
        if (!this.hasUnitAuthorization(proposalLog)) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.leadUnit", "error.proposalLog.unauthorizedLeadUnit", new String[]{GlobalVariables.getUserSession().getPrincipalName().toUpperCase(), proposalLog.getLeadUnit()});
            valid = false;
        }
        return valid;
    }

    private boolean isSponsorValid(MaintenanceDocument document) {
        boolean valid = true;
        ProposalLog proposalLog = (ProposalLog)document.getNewMaintainableObject().getDataObject();
        if (!StringUtils.isBlank((String)proposalLog.getSponsorCode())) {
            proposalLog.refreshReferenceObject("sponsor");
            if (!this.getSponsorService().validateSponsor(proposalLog.getSponsor())) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.sponsorCode", "error.invalid.sponsorCode", new String[0]);
                valid = false;
            }
        }
        if (proposalLog.getDeadlineTime() != null) {
            TimeFormatter formatter = new TimeFormatter();
            String deadLineTime = (String)formatter.convertToObject(proposalLog.getDeadlineTime());
            if (!deadLineTime.equalsIgnoreCase("Invalid Time")) {
                proposalLog.setDeadlineTime(deadLineTime);
            } else {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.deadlineTime", "error.invalid.deadLineTime", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean isProposalStatusChangeValid(MaintenanceDocument document) {
        boolean retval = false;
        ProposalLog oldProposalLog = (ProposalLog)document.getOldMaintainableObject().getDataObject();
        ProposalLog newProposalLog = (ProposalLog)document.getNewMaintainableObject().getDataObject();
        String oldStatus = oldProposalLog.getLogStatus();
        String newStatus = newProposalLog.getLogStatus();
        if (oldProposalLog.getProposalNumber() == null) {
            retval = true;
        } else if (StringUtils.equalsIgnoreCase((String)oldStatus, (String)newStatus) || StringUtils.equalsIgnoreCase((String)newStatus, (String)ProposalLogUtils.getProposalLogVoidStatusCode())) {
            retval = true;
        } else if (StringUtils.equalsIgnoreCase((String)newStatus, (String)ProposalLogUtils.getProposalLogTemporaryStatusCode()) == newProposalLog.isLogTypeTemporary()) {
            retval = true;
        }
        return retval;
    }

    private boolean hasUnitAuthorization(ProposalLog proposalLog) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "ProposalLogMaintenanceDocument");
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("unitNumber", proposalLog.getLeadUnit());
        return ProposalLogMaintenanceDocumentRules.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KC-IP", "Submit Proposal Log", qualifications);
    }

    public SponsorService getSponsorService() {
        return KraServiceLocator.getService(SponsorService.class);
    }
}

