/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalLogServiceImpl
implements ProposalLogService {
    private BusinessObjectService businessObjectService;

    @Override
    public void mergeProposalLog(ProposalLog permanentProposalLog, String temporaryProposalNumber) {
        ProposalLog tempProposalLog = (ProposalLog)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalLog.class, (Object)temporaryProposalNumber);
        if (tempProposalLog == null) {
            throw new IllegalArgumentException("Can't update proposal log status; proposal number " + temporaryProposalNumber + " not found.");
        }
        tempProposalLog.setMergedWith(permanentProposalLog.getProposalNumber());
        tempProposalLog.setLogStatus(ProposalLogUtils.getProposalLogMergedStatusCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)tempProposalLog);
    }

    @Override
    public void mergeProposalLog(String proposalNumber) {
        this.updateProposalLogStatus(proposalNumber, ProposalLogUtils.getProposalLogMergedStatusCode());
    }

    @Override
    public void promoteProposalLog(String proposalNumber) {
        this.updateProposalLogStatus(proposalNumber, ProposalLogUtils.getProposalLogSubmittedStatusCode());
    }

    protected void updateProposalLogStatus(String proposalNumber, String logStatus) {
        ProposalLog proposalLog = (ProposalLog)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalLog.class, (Object)proposalNumber);
        if (proposalLog == null) {
            throw new IllegalArgumentException("Can't update proposal log status; proposal number " + proposalNumber + " not found.");
        }
        proposalLog.setLogStatus(logStatus);
        this.getBusinessObjectService().save((PersistableBusinessObject)proposalLog);
    }

    @Override
    public void updateMergedInstProposal(Long proposalId, String proposalNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", proposalNumber);
        ProposalLog proposalLog = (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, criteria);
        if (proposalLog != null) {
            proposalLog.setInstProposalNumber(proposalId.toString());
            this.getBusinessObjectService().save((PersistableBusinessObject)proposalLog);
        }
    }

    @Override
    public List<ProposalLog> getMatchingTemporaryProposalLogs(String proposalLogTypeCode, String piId, String rolodexId) {
        List<ProposalLog> matchedLogs = new ArrayList<ProposalLog>();
        if ((StringUtils.isNotBlank((String)piId) || StringUtils.isNotBlank((String)rolodexId)) && StringUtils.equals((String)proposalLogTypeCode, (String)ProposalLogUtils.getProposalLogPermanentTypeCode())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)piId)) {
                criteria.put("piId", piId);
            } else if (StringUtils.isNotBlank((String)rolodexId)) {
                criteria.put("rolodexId", rolodexId);
            }
            criteria.put("proposalLogTypeCode", ProposalLogUtils.getProposalLogTemporaryTypeCode());
            matchedLogs = (List)this.getBusinessObjectService().findMatching(ProposalLog.class, criteria);
            this.purgeAlreadyMergedLogs(matchedLogs);
        }
        return matchedLogs;
    }

    private void purgeAlreadyMergedLogs(Collection<ProposalLog> pLogs) {
        Iterator<ProposalLog> iter = pLogs.iterator();
        while (iter.hasNext()) {
            ProposalLog pLog = iter.next();
            if (!pLog.getLogStatus().equals(ProposalLogUtils.getProposalLogMergedStatusCode())) continue;
            iter.remove();
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

