/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalRuleEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class InstitutionalProposalRuleImpl
extends ResearchDocumentRuleBase
implements InstitutionalProposalRule {
    BusinessObjectService boService;

    @Override
    public boolean processInstitutionalProposalRules(InstitutionalProposalRuleEvent institutionalProposalRuleEvent) {
        InstitutionalProposal proposal = institutionalProposalRuleEvent.getInstitutionalProposalForValidation();
        boolean valid = this.validateCurrentAwardNumberExists(proposal.getCurrentAwardNumber());
        if (proposal.getRolodexId() != null) {
            valid &= this.validateRolodexIdExists(proposal.getRolodexId());
        }
        return valid;
    }

    private boolean validateCurrentAwardNumberExists(String currentAwardNumber) {
        boolean valid = true;
        if (currentAwardNumber != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("awardNumber", currentAwardNumber);
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            List sponsors = (List)businessObjectService.findMatching(Award.class, fieldValues);
            if (sponsors.size() == 0) {
                this.reportError("document.institutionalProposalList[0].currentAwardNumber", "error.invalid.awardId", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateRolodexIdExists(int rolodexId) {
        HashMap<String, Integer> primaryKey = new HashMap<String, Integer>();
        primaryKey.put("rolodexId", rolodexId);
        int count = this.getBusinessObjectService().countMatching(Rolodex.class, primaryKey);
        boolean valid = true;
        if (count <= 0) {
            valid = false;
            this.reportError("document.institutionalProposal.rolodexId", "error.invalid.rolodexId", new String[0]);
        }
        return valid;
    }
}

