/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.TimeFormatter;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramRuleEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalSponsorAndProgramRuleImpl
extends ResearchDocumentRuleBase
implements InstitutionalProposalSponsorAndProgramRule {
    private static final long serialVersionUID = -4913188586827287608L;

    @Override
    public boolean processInstitutionalProposalSponsorAndProgramRules(InstitutionalProposalSponsorAndProgramRuleEvent institutionalProposalSponsorAndProgramRuleEvent) {
        return this.processCommonValidations(institutionalProposalSponsorAndProgramRuleEvent.getInstitutionalProposalForValidation());
    }

    public boolean processCommonValidations(InstitutionalProposal institutionalProposal) {
        boolean validCfdaNumber = this.validateCfdaNumber(institutionalProposal);
        boolean validSponsorCode = this.validateSponsorCodeExists(institutionalProposal.getSponsorCode());
        boolean validPrimeSponsorId = this.validatePrimeSponsorIdExists(institutionalProposal.getPrimeSponsorCode());
        boolean validSponsorDeadlineTime = this.validateSponsorDeadlineTime(institutionalProposal);
        return validCfdaNumber && validSponsorCode && validSponsorDeadlineTime;
    }

    private boolean validateSponsorDeadlineTime(InstitutionalProposal institutionalProposal) {
        boolean valid = true;
        if (institutionalProposal.getDeadlineTime() != null) {
            TimeFormatter formatter = new TimeFormatter();
            String formatTime = (String)formatter.convertToObject(institutionalProposal.getDeadlineTime());
            if (!formatTime.equalsIgnoreCase("Invalid Time")) {
                institutionalProposal.setDeadlineTime(formatTime);
            } else {
                GlobalVariables.getMessageMap().putError("document.institutionalProposal.deadlineTime", "error.invalid.deadLineTime", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateSponsorCodeExists(String sponsorCode) {
        boolean valid = true;
        if (sponsorCode != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("sponsorCode", sponsorCode);
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            List sponsors = (List)businessObjectService.findMatching(Sponsor.class, fieldValues);
            if (sponsors.size() == 0) {
                this.reportError("document.institutionalProposalList[0].sponsorCode", "error.invalid.sponsorCode", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validatePrimeSponsorIdExists(String primeSponsorId) {
        boolean valid = true;
        if (primeSponsorId != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("sponsorCode", primeSponsorId);
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            List sponsors = (List)businessObjectService.findMatching(Sponsor.class, fieldValues);
            if (sponsors.size() == 0) {
                this.reportError("document.institutionalProposal.primeSponsorCode", "error.invalid.primeSponsorCode", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateCfdaNumber(InstitutionalProposal institutionalProposal) {
        boolean valid = true;
        String regExpr = "(\\d{2})(\\.)(\\d{3})[a-zA-z]?";
        DataDictionaryService dataDictionaryService = KraServiceLocator.getService(DataDictionaryService.class);
        if (StringUtils.isNotBlank((String)institutionalProposal.getCfdaNumber()) && !institutionalProposal.getCfdaNumber().matches(regExpr) && GlobalVariables.getMessageMap().getMessages("document.institutionalProposalList[0].cfdaNumber") == null) {
            this.reportError("document.institutionalProposal.cfdaNumber", "error.invalidFormat", dataDictionaryService.getAttributeErrorLabel(InstitutionalProposal.class, "cfdaNumber"), institutionalProposal.getCfdaNumber());
            valid = false;
        }
        return valid;
    }
}

