/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.AbstractUnitAdministrator;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.kim.service.impl.AbstractUnitAdministratorDerivedRoleTypeService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.kim.framework.role.RoleTypeService;

public class InstitutionalProposalAllUnitAdministratorDerivedRoleTypeServiceImpl
extends AbstractUnitAdministratorDerivedRoleTypeService
implements RoleTypeService {
    private UnitService unitService;
    private InstitutionalProposalService institutionalProposalService;

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected UnitService getUnitService() {
        return this.unitService;
    }

    @Override
    public List<? extends AbstractUnitAdministrator> getUnitAdministrators(Map<String, String> qualifiers) {
        String proposalId = qualifiers.get("proposal");
        ArrayList<UnitAdministrator> result = new ArrayList<UnitAdministrator>();
        if (StringUtils.isNotBlank((String)proposalId)) {
            InstitutionalProposal proposal = this.getInstitutionalProposalService().getInstitutionalProposal(proposalId);
            HashSet<String> units = new HashSet<String>();
            for (InstitutionalProposalPerson person : proposal.getProjectPersons()) {
                for (InstitutionalProposalPersonUnit unit : person.getUnits()) {
                    units.add(unit.getUnitNumber());
                }
            }
            for (String unit : units) {
                if (!StringUtils.isNotBlank((String)unit)) continue;
                result.addAll(this.unitService.retrieveUnitAdministratorsByUnitNumber(unit));
            }
        }
        return result;
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

