/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.document.authorization.InstitutionalProposalDocumentAuthorizer;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class InstitutionalProposalLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    private static final String MERGE_PROPOSAL_LOG_ACTION = "mergeProposalLog.do";
    private static final String AWARD_HOME_ACTION = "awardHome.do";
    private static final String OPEN = "open";
    private static final String STAT_PENDING = "1";
    private static final String STAT_FUNDED = "2";
    private static final String STAT_REV_REQ = "6";
    private boolean includeMainSearchCustomActionUrls;
    private boolean includeMergeCustomActionUrls;
    private DocumentService documentService;
    private InstitutionalProposalService institutionalProposalService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        this.configureCustomActions(fieldValues);
        fieldValues.remove("proposalSequenceStatus");
        fieldValues.put("proposalSequenceStatus", VersionStatus.ACTIVE.toString());
        HashMap<String, String> formProps = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)fieldValues.get("lookupUnit.unitName"))) {
            formProps.put("units.unit.unitName", fieldValues.get("lookupUnit.unitName"));
        }
        if (!StringUtils.isEmpty((String)fieldValues.get("lookupUnit.unitNumber"))) {
            formProps.put("units.unitNumber", fieldValues.get("lookupUnit.unitNumber"));
        }
        fieldValues.remove("lookupUnit.unitNumber");
        fieldValues.remove("lookupUnit.unitName");
        if (!formProps.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            Collection persons = this.getLookupService().findCollectionBySearch(InstitutionalProposalPerson.class, formProps);
            if (persons.isEmpty()) {
                return new ArrayList();
            }
            for (InstitutionalProposalPerson person : persons) {
                ids.add(person.getInstitutionalProposalContactId());
            }
            fieldValues.put("projectPersons.institutionalProposalContactId", StringUtils.join(ids, (char)'|'));
        }
        List searchResults = super.getSearchResults(fieldValues);
        if (this.lookupIsFromAward(fieldValues)) {
            this.filterAlreadyLinkedProposals(searchResults, fieldValues);
            this.filterApprovedPendingSubmitProposals(searchResults);
            this.filterInvalidProposalStatus(searchResults);
        }
        List<InstitutionalProposal> filteredResults = this.filterForPermissions(searchResults);
        return filteredResults;
    }

    protected List<InstitutionalProposal> filterForPermissions(List<InstitutionalProposal> results) {
        Person user = GlobalVariables.getUserSession().getPerson();
        InstitutionalProposalDocumentAuthorizer authorizer = new InstitutionalProposalDocumentAuthorizer();
        ArrayList<InstitutionalProposal> filteredResults = new ArrayList<InstitutionalProposal>();
        for (InstitutionalProposal institutionalProposal : results) {
            String documentNumber = institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber();
            try {
                InstitutionalProposalDocument document = (InstitutionalProposalDocument)this.documentService.getByDocumentHeaderId(documentNumber);
                if (!authorizer.canOpen((Document)document, user)) continue;
                filteredResults.add(institutionalProposal);
            }
            catch (WorkflowException e) {
                LOG.warn((Object)("Cannot find Document with header id " + documentNumber));
            }
        }
        return filteredResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.includeMainSearchCustomActionUrls) {
            htmlDataList.add((HtmlData)this.getOpenLink((Document)((InstitutionalProposal)businessObject).getInstitutionalProposalDocument()));
        }
        if (this.includeMergeCustomActionUrls) {
            htmlDataList.add((HtmlData)this.getSelectLink((InstitutionalProposal)businessObject));
        }
        htmlDataList.add((HtmlData)this.getMedusaLink((Document)((InstitutionalProposal)businessObject).getInstitutionalProposalDocument(), false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Document document) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(OPEN);
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", "true");
        parameters.put("docOpenedFromIPSearch", "true");
        parameters.put("docId", document.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    @Override
    protected String getHtmlAction() {
        return "institutionalProposalHome.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "InstitutionalProposalDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "proposalNumber";
    }

    protected boolean lookupIsFromAward(Map<String, String> fieldValues) {
        String returnLocation = fieldValues.get("backLocation");
        return returnLocation != null && returnLocation.contains(AWARD_HOME_ACTION);
    }

    protected void filterAlreadyLinkedProposals(List<? extends BusinessObject> searchResults, Map<String, String> fieldValues) {
        List linkedProposals = (List)GlobalVariables.getUserSession().retrieveObject("linkedProposals");
        if (linkedProposals == null) {
            return;
        }
        block0: for (Long linkedProposalId : linkedProposals) {
            for (int j = 0; j < searchResults.size(); ++j) {
                InstitutionalProposal institutionalProposal = (InstitutionalProposal)searchResults.get(j);
                if (!linkedProposalId.equals(institutionalProposal.getProposalId())) continue;
                institutionalProposal.setShowReturnLink(false);
                continue block0;
            }
        }
    }

    protected void filterApprovedPendingSubmitProposals(List<? extends BusinessObject> searchResults) {
        for (int j = 0; j < searchResults.size(); ++j) {
            if (!this.isDevelopmentProposalAppPendingSubmitted((InstitutionalProposal)searchResults.get(j))) continue;
            ((InstitutionalProposal)searchResults.get(j)).setShowReturnLink(false);
        }
    }

    protected void filterInvalidProposalStatus(List<? extends BusinessObject> searchResults) {
        Collection<String> validCodes = this.getInstitutionalProposalService().getValidFundingProposalStatusCodes();
        for (int j = 0; j < searchResults.size(); ++j) {
            InstitutionalProposal result = (InstitutionalProposal)searchResults.get(j);
            if (validCodes.contains(result.getStatusCode().toString())) continue;
            result.setShowReturnLink(false);
        }
    }

    protected boolean isDevelopmentProposalAppPendingSubmitted(InstitutionalProposal ip) {
        boolean isApprovePending = false;
        Collection<DevelopmentProposal> devProposals = this.getDevelopmentProposals(ip);
        for (DevelopmentProposal developmentProposal : devProposals) {
            if (!"5".equals(developmentProposal.getProposalStateTypeCode())) continue;
            isApprovePending = true;
            break;
        }
        return isApprovePending;
    }

    protected Collection<DevelopmentProposal> getDevelopmentProposals(InstitutionalProposal instProposal) {
        ArrayList<DevelopmentProposal> devProposals = new ArrayList<DevelopmentProposal>();
        List proposalAdminDetails = (List)this.businessObjectService.findMatchingOrderBy(ProposalAdminDetails.class, this.getFieldValues("instProposalId", instProposal.getProposalId()), "devProposalNumber", true);
        if (proposalAdminDetails.size() > 0) {
            String latestDevelopmentProposalDocNumber = ((ProposalAdminDetails)((Object)proposalAdminDetails.get(proposalAdminDetails.size() - 1))).getDevProposalNumber();
            DevelopmentProposal devProp = (DevelopmentProposal)this.businessObjectService.findBySinglePrimaryKey(DevelopmentProposal.class, (Object)latestDevelopmentProposalDocNumber);
            devProposals.add(devProp);
        }
        return devProposals;
    }

    private String getDevelopmentProposalDocumentNumberFromDescription(String proposalDescription) {
        String[] splitProposalDescription = proposalDescription.split(" ");
        String returnVal = splitProposalDescription[splitProposalDescription.length - 1];
        return returnVal;
    }

    protected Map<String, Object> getFieldValues(String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return fieldValues;
    }

    protected void configureCustomActions(Map<String, String> fieldValues) {
        String returnLocation = fieldValues.get("backLocation");
        if (returnLocation != null) {
            if (returnLocation.contains(AWARD_HOME_ACTION)) {
                this.includeMainSearchCustomActionUrls = false;
                this.includeMergeCustomActionUrls = false;
            } else if (returnLocation.contains(MERGE_PROPOSAL_LOG_ACTION)) {
                this.includeMainSearchCustomActionUrls = false;
                this.includeMergeCustomActionUrls = true;
            } else {
                this.includeMainSearchCustomActionUrls = true;
                this.includeMergeCustomActionUrls = false;
            }
        } else {
            this.includeMainSearchCustomActionUrls = false;
            this.includeMergeCustomActionUrls = false;
        }
    }

    protected HtmlData.AnchorHtmlData getSelectLink(InstitutionalProposal institutionalProposal) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("select");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "mergeToInstitutionalProposal");
        parameters.put("institutionalProposalNumber", institutionalProposal.getProposalNumber());
        String href = UrlFactory.parameterizeUrl((String)"../mergeProposalLog.do", (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public boolean isResultReturnable(BusinessObject object) {
        InstitutionalProposal institutionalProposal = (InstitutionalProposal)object;
        return institutionalProposal.getShowReturnLink();
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }
}

