/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalLockService;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalAction
extends KraTransactionalDocumentActionBase {
    private static final String MODIFY_IP = "modifyIP";
    private KcNotificationService notificationService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            new AuditActionHelper().auditConditionally((InstitutionalProposalForm)form);
        }
        return actionForward;
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            Document document = formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            DocumentPresentationController documentPresentationController = KNSServiceLocator.getDocumentHelperService().getDocumentPresentationController(document);
            DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
            Set documentActions = documentPresentationController.getDocumentActions(document);
            documentActions = documentAuthorizer.getDocumentActions(document, user, documentActions);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                documentActions = this.getPessimisticLockService().getDocumentActions(document, user, documentActions);
            }
            HashSet<String> editModes = new HashSet<String>();
            if (!documentAuthorizer.canOpen(document, user)) {
                editModes.add("unviewable");
            } else if (documentActions.contains("canEdit")) {
                editModes.add("fullEntry");
            } else {
                editModes.add("viewOnly");
            }
            if (this.hasPermission("Edit Institutional Proposal")) {
                editModes.add(MODIFY_IP);
            }
            Map editMode = this.convertSetToMap(editModes);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                editMode = this.getPessimisticLockService().establishLocks(document, editMode, user);
            }
            if (editMode.containsKey("fullEntry")) {
                if (!documentActions.contains("canEditDocumentOverview")) {
                    documentActions.add("canEditDocumentOverview");
                }
            } else if (documentActions.contains("canEditDocumentOverview")) {
                documentActions.remove("canEditDocumentOverview");
            }
            if (editMode.containsKey("viewOnly") && !editMode.containsKey(MODIFY_IP) && documentActions.contains("canReload")) {
                documentActions.remove("canReload");
            }
            formBase.setDocumentActions(this.convertSetToMap(documentActions));
            formBase.setEditingMode(editMode);
        }
    }

    private boolean hasPermission(String permissionName) {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getUserName());
        return this.getUnitAuthorizationService().hasPermission(person.getPersonId(), "KC-IP", permissionName);
    }

    private String getUserName() {
        return GlobalVariables.getUserSession().getPerson().getPrincipalName();
    }

    private UnitAuthorizationService getUnitAuthorizationService() {
        return KraServiceLocator.getService(UnitAuthorizationService.class);
    }

    private KcPersonService getKcPersonService() {
        return KraServiceLocator.getService(KcPersonService.class);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        forward = super.save(mapping, form, request, response);
        if (institutionalProposalForm.getMethodToCall().equals("save") && institutionalProposalForm.isAuditActivated()) {
            forward = mapping.findForward("institutionalProposalActions");
        }
        return forward;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (institutionalProposalForm.getViewFundingSource()) {
            return mapping.findForward("closePage");
        }
        return super.close(mapping, form, request, response);
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("home");
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        ipForm.getCentralAdminContactsBean().initCentralAdminContacts();
        return mapping.findForward("contacts");
    }

    public ActionForward Contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.contacts(mapping, form, request, response);
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((InstitutionalProposalForm)form).getSpecialReviewHelper().prepareView();
        return mapping.findForward("specialReview");
    }

    public ActionForward intellectualPropertyReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("intellectualPropertyReview");
    }

    public ActionForward distribution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("distribution");
    }

    public ActionForward institutionalProposalActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String command = request.getParameter("command");
        if (StringUtils.isNotEmpty((String)command) && "displayDocSearchView".equals(command)) {
            this.loadDocumentInForm(request, (InstitutionalProposalForm)form);
        }
        return mapping.findForward("institutionalProposalActions");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        institutionalProposalForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, InstitutionalProposalForm institutionalProposalForm) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        return forward;
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = (InstitutionalProposalDocument)institutionalProposalForm.getDocument();
        ActionForward forward = null;
        String command = institutionalProposalForm.getCommand();
        if ("institutionalProposalActions".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)institutionalProposalForm);
            forward = this.institutionalProposalActions(mapping, form, request, response);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if (request.getParameter("docOpenedFromIPSearch") != null && request.getParameter("docOpenedFromIPSearch").equals("true")) {
            institutionalProposalForm.setDocOpenedFromIPSearch(true);
        }
        if ("institutionalProposalActions".equals(command)) {
            forward = this.institutionalProposalActions(mapping, form, request, response);
        }
        return forward;
    }

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        InstitutionalProposal proposal = ((InstitutionalProposalForm)kualiDocumentFormBase).getInstitutionalProposalDocument().getInstitutionalProposal();
        proposal.setSponsorNihMultiplePi(this.getSponsorService().isSponsorNihMultiplePi(proposal));
        if (!proposal.getProjectPersons().isEmpty()) {
            proposal.getProjectPersons().get(0);
        }
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (institutionalProposalForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, institutionalProposalForm);
        }
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)institutionalProposalForm.getDocument();
        institutionalProposalForm.getMedusaBean().setMedusaViewRadio("0");
        institutionalProposalForm.getMedusaBean().setModuleName("IP");
        institutionalProposalForm.getMedusaBean().setModuleIdentifier(document.getInstitutionalProposal().getProposalId());
        institutionalProposalForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("medusa");
    }

    protected void loadDocumentInForm(HttpServletRequest request, InstitutionalProposalForm institutionalProposalForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        InstitutionalProposalDocument retrievedDocument = (InstitutionalProposalDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        institutionalProposalForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    protected PessimisticLockService getPessimisticLockService() {
        return KraServiceLocator.getService(InstitutionalProposalLockService.class);
    }

    protected SponsorService getSponsorService() {
        return KraServiceLocator.getService(SponsorService.class);
    }

    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = KraServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

