/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalCreditSplitBean;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonnelBean;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContactsBean;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;

public class InstitutionalProposalContactsAction
extends InstitutionalProposalAction {
    private static final String DELETE_PROJECT_PERSON_UNIT_PREFIX = "deleteProjectPersonUnit.";
    private static final String LINE_SUFFIX = ".line";
    private static final String CONFIRM_SYNC_UNIT_CONTACTS = "confirmSyncUnitContacts";
    private static final String CONFIRM_SYNC_UNIT_CONTACTS_KEY = "confirmSyncUnitContactsKey";

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposal institutionalProposal = institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        this.setLeadUnitOnInstitutionalProposalFromPILeadUnit(institutionalProposal, institutionalProposalForm);
        institutionalProposalForm.getCentralAdminContactsBean().initCentralAdminContacts();
        ActionForward forward = super.save(mapping, form, request, response);
        return forward;
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        ActionForward forward = super.reload(mapping, form, request, response);
        institutionalProposalForm.getCentralAdminContactsBean().initCentralAdminContacts();
        return forward;
    }

    private void setLeadUnitOnInstitutionalProposalFromPILeadUnit(InstitutionalProposal institutionalProposal, InstitutionalProposalForm institutionalProposalForm) {
        for (InstitutionalProposalPerson person : institutionalProposal.getProjectPersons()) {
            if (!person.isPrincipalInvestigator()) continue;
            List units = (List)this.getBusinessObjectService().findMatching(Unit.class, ServiceHelper.getInstance().buildCriteriaMap("unitName", institutionalProposalForm.getProjectPersonnelBean().getSelectedLeadUnit()));
            if (units.size() > 0) {
                Unit leadUnit = (Unit)((Object)units.get(0));
                institutionalProposal.setUnitNumber(leadUnit.getUnitNumber());
                institutionalProposal.setLeadUnit(leadUnit);
                continue;
            }
            institutionalProposal.setUnitNumber(null);
            institutionalProposal.setLeadUnit(null);
        }
    }

    public ActionForward addNewProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward addProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getProjectPersonnelBean(form).addProjectPerson();
        return mapping.findForward("basic");
    }

    public ActionForward deleteProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getProjectPersonnelBean(form).deleteProjectPerson(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward addUnitContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnitContactsBean(form).addUnitContact();
        return mapping.findForward("basic");
    }

    public ActionForward deleteUnitContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnitContactsBean(form).deleteUnitContact(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getProjectPersonnelBean(form).deleteProjectPersonUnit(this.getProjectPersonIndex(request), this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    private InstitutionalProposalProjectPersonnelBean getProjectPersonnelBean(ActionForm form) {
        return ((InstitutionalProposalForm)form).getProjectPersonnelBean();
    }

    private int getProjectPersonIndex(HttpServletRequest request) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)DELETE_PROJECT_PERSON_UNIT_PREFIX, (String)LINE_SUFFIX));
        }
        return selectedPersonIndex;
    }

    public ActionForward recalculateCreditSplit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getInstitutionalProposalCreditSplitBean(form).recalculateCreditSplit();
        return mapping.findForward("basic");
    }

    public ActionForward syncDefaultUnitContactsToLeadUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncUnitContactsConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_UNIT_CONTACTS, "");
    }

    private StrutsConfirmation buildSyncUnitContactsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_UNIT_CONTACTS_KEY, "document.question.syncUnitContacts.text", new String[0]);
    }

    public ActionForward confirmSyncUnitContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        this.getUnitContactsBean((ActionForm)institutionalProposalForm).syncInstitutionalProposalUnitContactsToLeadUnitContacts();
        return mapping.findForward("basic");
    }

    private InstitutionalProposalCreditSplitBean getInstitutionalProposalCreditSplitBean(ActionForm form) {
        return ((InstitutionalProposalForm)form).getInstitutionalProposalCreditSplitBean();
    }

    private InstitutionalProposalUnitContactsBean getUnitContactsBean(ActionForm form) {
        return ((InstitutionalProposalForm)form).getUnitContactsBean();
    }
}

