/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.krms.service.impl.KcKrmsFactBuilderServiceHelper;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;

public class IrbProtocolFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            ProtocolDocument protocolDocument = (ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, protocolDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, ResearchDocumentBase researchDocument) {
        ProtocolDocument protocolDocument = (ProtocolDocument)researchDocument;
        Protocol protocol = protocolDocument.getProtocol();
        this.addObjectMembersAsFacts(factsBuilder, protocol, "KC-PROTOCOL-CONTEXT", "KC-PROTOCOL");
        factsBuilder.addFact("IrbProtocol", (Object)protocol);
        factsBuilder.addFact("moduleCode", (Object)"7");
        factsBuilder.addFact("moduleItemKey", (Object)protocol.getProtocolNumber());
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

