/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.service.CommitteeScheduleService;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.ProtocolRequestAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersBean;
import org.kuali.kra.irb.actions.correction.AdminCorrectionBean;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionService;
import org.kuali.kra.irb.actions.delete.ProtocolDeleteBean;
import org.kuali.kra.irb.actions.expeditedapprove.ProtocolExpeditedApproveBean;
import org.kuali.kra.irb.actions.followup.FollowupActionService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionBean;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.irb.actions.notifycommittee.ProtocolNotifyCommitteeBean;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbBean;
import org.kuali.kra.irb.actions.print.ProtocolQuestionnairePrintingService;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.actions.undo.UndoLastActionBean;
import org.kuali.kra.irb.actions.withdraw.ProtocolAdministrativelyIncompleteBean;
import org.kuali.kra.irb.actions.withdraw.ProtocolAdministrativelyWithdrawBean;
import org.kuali.kra.irb.actions.withdraw.ProtocolWithdrawBean;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.questionnaire.IrbSubmissionQuestionnaireHelper;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ActionHelperBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolEditableBean;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.questionnaire.ProtocolModuleQuestionnaireBeanBase;
import org.kuali.kra.protocol.questionnaire.ProtocolSubmissionQuestionnaireHelper;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ActionHelper
extends ActionHelperBase {
    private static final long ONE_DAY = 86400000L;
    private static final String NAMESPACE = "KC-UNT";
    private static final List<String> ACTION_TYPE_SUBMISSION_DOC;
    private boolean canNotifyIrb = false;
    private boolean canNotifyIrbUnavailable = false;
    private boolean canRequestCloseEnrollment = false;
    private boolean canRequestCloseEnrollmentUnavailable = false;
    private boolean canRequestReOpenEnrollment = false;
    private boolean canRequestReOpenEnrollmentUnavailable = false;
    private boolean canRequestDataAnalysis = false;
    private boolean canRequestDataAnalysisUnavailable = false;
    private boolean canGrantExemption = false;
    private boolean canGrantExemptionUnavailable = false;
    private boolean canApproveExpedited = false;
    private boolean canApproveExpeditedUnavailable = false;
    private boolean canReopenEnrollment = false;
    private boolean canReopenEnrollmentUnavailable = false;
    private boolean canCloseEnrollment = false;
    private boolean canCloseEnrollmentUnavailable = false;
    private boolean canSuspendByDsmb = false;
    private boolean canSuspendByDsmbUnavailable = false;
    private boolean canPermitDataAnalysis = false;
    private boolean canPermitDataAnalysisUnavailable = false;
    private boolean canEnterRiskLevel = false;
    private boolean canIrbAcknowledgement = false;
    private boolean canIrbAcknowledgementUnavailable = false;
    private boolean canDefer = false;
    private boolean canDeferUnavailable = false;
    private boolean canReviewNotRequired = false;
    private boolean canReviewNotRequiredUnavailable = false;
    private boolean canAddCloseEnrollmentReviewerComments;
    private boolean canAddDataAnalysisReviewerComments;
    private boolean canAddReopenEnrollmentReviewerComments;
    private ProtocolRequestBean protocolCloseEnrollmentRequestBean;
    private ProtocolRequestBean protocolReOpenEnrollmentRequestBean;
    private ProtocolRequestBean protocolDataAnalysisRequestBean;
    private ProtocolNotifyIrbBean protocolNotifyIrbBean = new ProtocolNotifyIrbBean(this, "protocolNotifyIrbBean");
    private ProtocolAssignCmtSchedBean assignCmtSchedBean;
    private ProtocolAssignReviewersBean protocolAssignReviewersBean;
    private ProtocolGrantExemptionBean protocolGrantExemptionBean;
    private ProtocolExpeditedApproveBean protocolExpeditedApprovalBean;
    private ProtocolApproveBean protocolResponseApprovalBean;
    private ProtocolGenericActionBean protocolReopenEnrollmentBean;
    private ProtocolGenericActionBean protocolCloseEnrollmentBean;
    private ProtocolGenericActionBean protocolSuspendByDsmbBean;
    private ProtocolGenericActionBean protocolPermitDataAnalysisBean;
    private ProtocolGenericActionBean protocolIrbAcknowledgementBean;
    private UndoLastActionBean undoLastActionBean;
    private ProtocolModifySubmissionBean protocolModifySubmissionBean;
    private ProtocolGenericActionBean protocolDeferBean;
    private ProtocolReviewNotRequiredBean protocolReviewNotRequiredBean;
    private transient ProtocolSubmitActionService protocolSubmitActionService;
    private transient ProtocolActionService protocolActionService;
    private String printTag;

    public ActionHelper(ProtocolForm form) throws Exception {
        super(form);
        this.protocolNotifyIrbBean.setNewActionAttachment(new ProtocolActionAttachment());
        this.assignCmtSchedBean = new ProtocolAssignCmtSchedBean(this);
        this.assignCmtSchedBean.init();
        this.protocolAssignReviewersBean = new ProtocolAssignReviewersBean(this);
        this.protocolGrantExemptionBean = new ProtocolGrantExemptionBean(this);
        this.protocolGrantExemptionBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolExpeditedApprovalBean = this.buildProtocolExpeditedApproveBean("205");
        this.protocolResponseApprovalBean = (ProtocolApproveBean)this.buildProtocolApproveBean("208", "actionHelper.protocolResponseApprovalBean");
        this.protocolReopenEnrollmentBean = this.buildProtocolGenericActionBean("212", "actionHelper.protocolReopenEnrollmentBean");
        this.protocolCloseEnrollmentBean = this.buildProtocolGenericActionBean("207", "actionHelper.protocolCloseEnrollmentBean");
        this.protocolSuspendByDsmbBean = this.buildProtocolGenericActionBean("306", "actionHelper.protocolSuspendByDsmbBean");
        this.protocolCloseBean = this.buildProtocolGenericActionBean("300", "actionHelper.protocolCloseBean");
        this.protocolPermitDataAnalysisBean = this.buildProtocolGenericActionBean("211", "actionHelper.protocolPermitDataAnalysisBean");
        this.protocolIrbAcknowledgementBean = this.buildProtocolGenericActionBean("209", "actionHelper.protocolIrbAcknowledgementBean");
        this.undoLastActionBean = this.createUndoLastActionBean(this.getProtocol());
        this.protocolModifySubmissionBean = new ProtocolModifySubmissionBean(this);
        this.protocolDeferBean = this.buildProtocolGenericActionBean("201", "actionHelper.protocolDeferBean");
        this.protocolReviewNotRequiredBean = new ProtocolReviewNotRequiredBean(this);
        this.protocolCloseRequestBean = new ProtocolRequestBean(this, "105", "109", "protocolCloseRequestBean");
        this.protocolSuspendRequestBean = new ProtocolRequestBean(this, "106", "110", "protocolSuspendRequestBean");
        this.protocolCloseEnrollmentRequestBean = new ProtocolRequestBean(this, "108", "111", "protocolCloseEnrollmentRequestBean");
        this.protocolReOpenEnrollmentRequestBean = new ProtocolRequestBean(this, "115", "114", "protocolReOpenEnrollmentRequestBean");
        this.protocolDataAnalysisRequestBean = new ProtocolRequestBean(this, "114", "113", "protocolDataAnalysisRequestBean");
        this.protocolTerminateRequestBean = new ProtocolRequestBean(this, "104", "108", "protocolTerminateRequestBean");
        this.toAnswerSubmissionQuestionnaire = this.hasSubmissionQuestionnaire();
        this.initIRBSpecificActionBeanTaskMap();
    }

    private void initIRBSpecificActionBeanTaskMap() {
        this.actionBeanTaskMap.put("protocolAssignToCmtSched", this.assignCmtSchedBean);
        this.actionBeanTaskMap.put("protocolAssignReviewers", this.protocolAssignReviewersBean);
        this.actionBeanTaskMap.put("protocolClose", this.protocolCloseBean);
        this.actionBeanTaskMap.put("protocolCloseEnrollment", this.protocolCloseEnrollmentBean);
        this.actionBeanTaskMap.put("protocolRequestCloseEnrollment", this.protocolCloseEnrollmentRequestBean);
        this.actionBeanTaskMap.put("protocolRequestClose", this.protocolCloseRequestBean);
        this.actionBeanTaskMap.put("protocolPermitDataAnalysis", this.protocolPermitDataAnalysisBean);
        this.actionBeanTaskMap.put("protocolRequestDataAnalysis", this.protocolDataAnalysisRequestBean);
        this.actionBeanTaskMap.put("protocolDefer", this.protocolDeferBean);
        this.actionBeanTaskMap.put("protocolExpediteApproval", this.protocolExpeditedApprovalBean);
        this.actionBeanTaskMap.put("protocolGrantExemption", this.protocolGrantExemptionBean);
        this.actionBeanTaskMap.put("irbAcknowledgement", this.protocolIrbAcknowledgementBean);
        this.actionBeanTaskMap.put("modifyProtocolSubmisison", this.protocolModifySubmissionBean);
        this.actionBeanTaskMap.put("protocolNotifyIrb", this.protocolNotifyIrbBean);
        this.actionBeanTaskMap.put("protocolNotifyCommittee", this.protocolNotifyCommitteeBean);
        this.actionBeanTaskMap.put("protocolReopen", this.protocolReopenEnrollmentBean);
        this.actionBeanTaskMap.put("protocolRequestReOpenEnrollment", this.protocolReOpenEnrollmentRequestBean);
        this.actionBeanTaskMap.put("protocolResponseApproval", this.protocolResponseApprovalBean);
        this.actionBeanTaskMap.put("protocolRequestClose", this.protocolCloseRequestBean);
        this.actionBeanTaskMap.put("protocolRequestCloseEnrollment", this.protocolCloseEnrollmentRequestBean);
        this.actionBeanTaskMap.put("protocolRequestReOpenEnrollment", this.protocolReOpenEnrollmentRequestBean);
        this.actionBeanTaskMap.put("protocolRequestDataAnalysis", this.protocolDataAnalysisRequestBean);
        this.actionBeanTaskMap.put("protocolRequestSuspension", this.protocolSuspendRequestBean);
        this.actionBeanTaskMap.put("protocolRequestTerminate", this.protocolTerminateRequestBean);
        this.actionBeanTaskMap.put("protocolReviewNotRequired", this.protocolReviewNotRequiredBean);
        this.actionBeanTaskMap.put("protocolSuspendByDsmb", this.protocolSuspendByDsmbBean);
        this.actionBeanTaskMap.put("protocolRequestSuspension", this.protocolSuspendRequestBean);
        this.actionBeanTaskMap.put("protocolRequestTerminate", this.protocolTerminateRequestBean);
        this.actionBeanTaskMap.put("protocolUndoLastAction", this.undoLastActionBean);
    }

    @Override
    protected ProtocolGenericActionBean buildProtocolGenericActionBean(String actionTypeCode, String errorPropertyKey) {
        ProtocolGenericActionBean bean = new ProtocolGenericActionBean(this, errorPropertyKey);
        bean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        ProtocolAction protocolAction = (ProtocolAction)this.findProtocolAction(actionTypeCode, this.getProtocol().getProtocolActions(), this.getProtocol().getProtocolSubmission());
        if (protocolAction != null) {
            bean.setComments(protocolAction.getComments());
            bean.setActionDate(new Date(protocolAction.getActionDate().getTime()));
        }
        return bean;
    }

    private ProtocolExpeditedApproveBean buildProtocolExpeditedApproveBean(String actionTypeCode) throws Exception {
        ProtocolExpeditedApproveBean bean = new ProtocolExpeditedApproveBean(this);
        bean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        ProtocolAction protocolAction = (ProtocolAction)this.findProtocolAction(actionTypeCode, this.getProtocol().getProtocolActions(), this.getProtocol().getProtocolSubmission());
        if (protocolAction != null) {
            bean.setComments(protocolAction.getComments());
            bean.setActionDate(new Date(protocolAction.getActionDate().getTime()));
        }
        bean.setApprovalDate(this.buildApprovalDate(this.getProtocol()));
        bean.setExpirationDate(this.buildExpirationDate(this.getProtocol(), bean.getApprovalDate()));
        return bean;
    }

    @Override
    protected void populateExistingAmendmentBean(org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean amendmentBean, List<String> moduleTypeCodes) {
        ProtocolAmendRenewal protocolAmendRenewal = (ProtocolAmendRenewal)this.getProtocol().getProtocolAmendRenewal();
        amendmentBean.setSummary(protocolAmendRenewal.getSummary());
        for (ProtocolAmendRenewModuleBase module : protocolAmendRenewal.getModules()) {
            moduleTypeCodes.add(module.getProtocolModuleTypeCode());
            if (StringUtils.equals((String)"001", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setGeneralInfo(true);
                continue;
            }
            if (StringUtils.equals((String)"008", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setAddModifyAttachments(true);
                continue;
            }
            if (StringUtils.equals((String)"004", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setAreasOfResearch(true);
                continue;
            }
            if (StringUtils.equals((String)"024", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setFundingSource(true);
                continue;
            }
            if (StringUtils.equals((String)"023", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setOthers(true);
                continue;
            }
            if (StringUtils.equals((String)"017", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolOrganizations(true);
                continue;
            }
            if (StringUtils.equals((String)"002", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolPersonnel(true);
                continue;
            }
            if (StringUtils.equals((String)"016", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolReferencesAndOtherIdentifiers(true);
                continue;
            }
            if (StringUtils.equals((String)"007", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setSpecialReview(true);
                continue;
            }
            if (StringUtils.equals((String)"006", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setSubjects(true);
                continue;
            }
            if (StringUtils.equals((String)"025", (String)module.getProtocolModuleTypeCode())) {
                amendmentBean.setProtocolPermissions(true);
                continue;
            }
            if (!StringUtils.equals((String)"026", (String)module.getProtocolModuleTypeCode())) continue;
            amendmentBean.setQuestionnaire(true);
        }
    }

    private UndoLastActionBean createUndoLastActionBean(Protocol protocol) throws Exception {
        this.undoLastActionBean = new UndoLastActionBean(this);
        this.undoLastActionBean.setProtocol(protocol);
        Collections.sort(protocol.getProtocolActions(), new Comparator<ProtocolAction>(){

            @Override
            public int compare(ProtocolAction action1, ProtocolAction action2) {
                return action2.getActualActionDate().compareTo(action1.getActualActionDate());
            }
        });
        this.undoLastActionBean.setActionsPerformed(protocol.getProtocolActions());
        return this.undoLastActionBean;
    }

    @Override
    protected void enableModuleOption(String moduleTypeCode, ProtocolEditableBean amendmentBean) {
        if (StringUtils.equals((String)"001", (String)moduleTypeCode)) {
            amendmentBean.setGeneralInfoEnabled(true);
        } else if (StringUtils.equals((String)"008", (String)moduleTypeCode)) {
            amendmentBean.setAddModifyAttachmentsEnabled(true);
        } else if (StringUtils.equals((String)"004", (String)moduleTypeCode)) {
            amendmentBean.setAreasOfResearchEnabled(true);
        } else if (StringUtils.equals((String)"024", (String)moduleTypeCode)) {
            amendmentBean.setFundingSourceEnabled(true);
        } else if (StringUtils.equals((String)"023", (String)moduleTypeCode)) {
            amendmentBean.setOthersEnabled(true);
        } else if (StringUtils.equals((String)"017", (String)moduleTypeCode)) {
            amendmentBean.setProtocolOrganizationsEnabled(true);
        } else if (StringUtils.equals((String)"002", (String)moduleTypeCode)) {
            amendmentBean.setProtocolPersonnelEnabled(true);
        } else if (StringUtils.equals((String)"016", (String)moduleTypeCode)) {
            amendmentBean.setProtocolReferencesEnabled(true);
        } else if (StringUtils.equals((String)"007", (String)moduleTypeCode)) {
            amendmentBean.setSpecialReviewEnabled(true);
        } else if (StringUtils.equals((String)"006", (String)moduleTypeCode)) {
            amendmentBean.setSubjectsEnabled(true);
        } else if (StringUtils.equals((String)"025", (String)moduleTypeCode)) {
            amendmentBean.setProtocolPermissionsEnabled(true);
        } else if (StringUtils.equals((String)"026", (String)moduleTypeCode)) {
            amendmentBean.setQuestionnaireEnabled(true);
        }
    }

    @Override
    protected ProtocolAmendRenewService getProtocolAmendRenewServiceHook() {
        if (this.protocolAmendRenewService == null) {
            this.protocolAmendRenewService = KraServiceLocator.getService(ProtocolAmendRenewService.class);
        }
        return (ProtocolAmendRenewService)this.protocolAmendRenewService;
    }

    @Override
    public void prepareView() throws Exception {
        super.prepareView();
        this.assignCmtSchedBean.prepareView();
        ((ProtocolNotifyCommitteeBean)this.protocolNotifyCommitteeBean).prepareView();
        this.protocolAssignReviewersBean.prepareView();
        this.protocolExpeditedApprovalBean.prepareView();
        this.submissionConstraint = this.getParameterValue("IRB_COMM_SELECTION_DURING_SUBMISSION");
        this.canNotifyIrb = this.hasNotifyIrbPermission();
        this.canNotifyIrbUnavailable = this.hasNotifyIrbUnavailablePermission();
        this.canNotifyCommittee = this.hasNotifyCommitteePermission();
        this.canNotifyCommitteeUnavailable = this.hasNotifyCommitteeUnavailablePermission();
        this.canRequestClose = this.hasRequestClosePermission();
        this.canRequestCloseUnavailable = this.hasRequestCloseUnavailablePermission();
        this.canRequestSuspension = this.hasRequestSuspensionPermission();
        this.canRequestSuspensionUnavailable = this.hasRequestSuspensionUnavailablePermission();
        this.canRequestCloseEnrollment = this.hasRequestCloseEnrollmentPermission();
        this.canRequestCloseEnrollmentUnavailable = this.hasRequestCloseEnrollmentUnavailablePermission();
        this.canRequestReOpenEnrollment = this.hasRequestReOpenEnrollmentPermission();
        this.canRequestReOpenEnrollmentUnavailable = this.hasRequestReOpenEnrollmentUnavailablePermission();
        this.canRequestDataAnalysis = this.hasRequestDataAnalysisPermission();
        this.canRequestDataAnalysisUnavailable = this.hasRequestDataAnalysisUnavailablePermission();
        this.canRequestTerminate = this.hasRequestTerminatePermission();
        this.canRequestTerminateUnavailable = this.hasRequestTerminateUnavailablePermission();
        this.canAssignCmtSched = this.hasAssignCmtSchedPermission();
        this.canAssignCmtSchedUnavailable = this.hasAssignCmtSchedUnavailablePermission();
        this.canAssignReviewers = this.hasAssignReviewersPermission();
        this.canAssignReviewersCmtSel = this.canSubmitProtocol ? this.hasAssignReviewersCmtSel() : false;
        this.canAssignReviewersUnavailable = this.hasAssignReviewersUnavailablePermission();
        this.canGrantExemption = this.hasGrantExemptionPermission();
        this.canGrantExemptionUnavailable = this.hasGrantExemptionUnavailablePermission();
        this.canApproveExpedited = this.hasExpeditedApprovalPermission();
        this.canApproveExpeditedUnavailable = this.hasExpeditedApprovalUnavailablePermission();
        this.canApproveResponse = this.hasResponseApprovalPermission();
        this.canApproveResponseUnavailable = this.hasResponseApprovalUnavailablePermission();
        this.canReopenEnrollment = this.hasReopenEnrollmentPermission();
        this.canReopenEnrollmentUnavailable = this.hasReopenEnrollmentUnavailablePermission();
        this.canCloseEnrollment = this.hasCloseEnrollmentPermission();
        this.canCloseEnrollmentUnavailable = this.hasCloseEnrollmentUnavailablePermission();
        this.canSuspendByDsmb = this.hasSuspendByDsmbPermission();
        this.canSuspendByDsmbUnavailable = this.hasSuspendByDsmbUnavailablePermission();
        this.canClose = this.hasClosePermission();
        this.canCloseUnavailable = this.hasCloseUnavailablePermission();
        this.canPermitDataAnalysis = this.hasPermitDataAnalysisPermission();
        this.canPermitDataAnalysisUnavailable = this.hasPermitDataAnalysisUnavailablePermission();
        this.canEnterRiskLevel = this.hasEnterRiskLevelPermission();
        this.canUndoLastAction = this.hasUndoLastActionPermission();
        this.canUndoLastActionUnavailable = this.hasUndoLastActionUnavailablePermission();
        this.canIrbAcknowledgement = this.hasIrbAcknowledgementPermission();
        this.canIrbAcknowledgementUnavailable = this.hasIrbAcknowledgementUnavailablePermission();
        this.canDefer = this.hasDeferPermission();
        this.canDeferUnavailable = this.hasDeferUnavailablePermission();
        this.canReviewNotRequired = this.hasReviewNotRequiredPermission();
        this.canReviewNotRequiredUnavailable = this.hasReviewNotRequiredUnavailablePermission();
        this.canApproveOther = this.hasApproveOtherPermission();
        this.canManageNotes = this.hasManageNotesPermission();
        this.canManageNotesUnavailable = this.hasManageNotesUnavailablePermission();
        this.canReturnToPI = this.hasPermission("protocolReturnToPI");
        this.canReturnToPIUnavailable = this.hasPermission("protocolReturnToPIUnavailable");
        this.canAddCloseReviewerComments = this.hasCloseRequestLastAction();
        this.canAddCloseEnrollmentReviewerComments = this.hasCloseEnrollmentRequestLastAction();
        this.canAddDataAnalysisReviewerComments = this.hasDataAnalysisRequestLastAction();
        this.canAddReopenEnrollmentReviewerComments = this.hasReopenEnrollmentRequestLastAction();
        this.hideReviewerName = this.checkToHideReviewName();
        this.undoLastActionBean = this.createUndoLastActionBean(this.getProtocol());
        this.initSummaryDetails();
        this.setAmendmentDetails();
        this.initFilterDatesView();
        this.populateSubmissionQuestionnaires();
    }

    @Override
    public void prepareCommentsView() {
        super.prepareCommentsView();
        this.protocolGrantExemptionBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolIrbAcknowledgementBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolExpeditedApprovalBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolResponseApprovalBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolReopenEnrollmentBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolCloseEnrollmentBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolSuspendByDsmbBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolCloseBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolPermitDataAnalysisBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
        this.protocolDeferBean.getReviewCommentsBean().setReviewComments(this.getCopiedReviewComments());
    }

    @Override
    protected ProtocolVersionService getProtocolVersionService() {
        if (this.protocolVersionService == null) {
            this.protocolVersionService = KraServiceLocator.getService(ProtocolVersionService.class);
        }
        return (ProtocolVersionService)this.protocolVersionService;
    }

    private ProtocolSubmitActionService getProtocolSubmitActionService() {
        if (this.protocolSubmitActionService == null) {
            this.protocolSubmitActionService = KraServiceLocator.getService(ProtocolSubmitActionService.class);
        }
        return this.protocolSubmitActionService;
    }

    private ProtocolActionService getProtocolActionService() {
        if (this.protocolActionService == null) {
            this.protocolActionService = KraServiceLocator.getService(ProtocolActionService.class);
        }
        return this.protocolActionService;
    }

    private boolean hasNotifyIrbPermission() {
        ProtocolTask task = new ProtocolTask("protocolNotifyIrb", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasNotifyIrbUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolNotifyIrbUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasNotifyCommitteePermission() {
        ProtocolTask task = new ProtocolTask("protocolNotifyCommittee", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasNotifyCommitteeUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolNotifyCommitteeUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestClosePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestClose", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestCloseUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestCloseUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestSuspensionPermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestSuspension", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestSuspensionUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestSuspensionUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestCloseEnrollmentPermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestCloseEnrollment", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestCloseEnrollmentUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestCloseEnrollmentUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestReOpenEnrollmentPermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestReOpenEnrollment", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestReOpenEnrollmentUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestReOpenEnrollmentUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestDataAnalysisPermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestDataAnalysis", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestDataAnalysisUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestDataAnalysisUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestTerminatePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestTerminate", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasRequestTerminateUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolRequestTerminateUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasAssignCmtSchedPermission() {
        ProtocolTask task = new ProtocolTask("protocolAssignToCmtSched", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public static boolean hasAssignCmtSchedPermission(String userId, String protocolNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolNumber", protocolNumber);
        BusinessObjectService bos = KraServiceLocator.getService(BusinessObjectService.class);
        Protocol protocol = (Protocol)((List)bos.findMatching(Protocol.class, fieldValues)).get(0);
        ProtocolTask task = new ProtocolTask("modifyProposal", protocol);
        TaskAuthorizationService tas = KraServiceLocator.getService(TaskAuthorizationService.class);
        return tas.isAuthorized(userId, task);
    }

    private boolean hasAssignCmtSchedUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolAssignToCmtSchedUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasAssignReviewersPermission() {
        ProtocolTask task = new ProtocolTask("protocolAssignReviewers", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasAssignReviewersUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolAssignReviewersUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasAssignReviewersCmtSel() {
        ProtocolTask task = new ProtocolTask("protocolAssignReviewersCmtSel", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasGrantExemptionPermission() {
        return this.hasPermission("protocolGrantExemption");
    }

    private boolean hasGrantExemptionUnavailablePermission() {
        return this.hasPermission("protocolGrantExemptionUnavailable");
    }

    private boolean hasExpeditedApprovalPermission() {
        return this.hasPermission("protocolExpediteApproval");
    }

    private boolean hasExpeditedApprovalUnavailablePermission() {
        return this.hasPermission("protocolExpediteApprovalUnavailable");
    }

    private boolean hasResponseApprovalPermission() {
        return this.hasPermission("protocolResponseApproval");
    }

    private boolean hasResponseApprovalUnavailablePermission() {
        return this.hasPermission("protocolResponseApprovalUnavailable");
    }

    private boolean hasReopenEnrollmentPermission() {
        return this.hasGenericPermission("protocolReopen");
    }

    private boolean hasReopenEnrollmentUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolReopen");
    }

    private boolean hasCloseEnrollmentPermission() {
        return this.hasGenericPermission("protocolCloseEnrollment");
    }

    private boolean hasCloseEnrollmentUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolCloseEnrollment");
    }

    @Override
    protected boolean hasSuspendPermission() {
        return this.hasGenericPermission("protocolSuspend");
    }

    @Override
    protected boolean hasSuspendUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolSuspend");
    }

    @Override
    protected ProtocolTaskBase getSuspendTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    @Override
    protected ProtocolTaskBase getSuspendUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    private boolean hasSuspendByDsmbPermission() {
        return this.hasGenericPermission("protocolSuspendByDsmb");
    }

    private boolean hasSuspendByDsmbUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolSuspendByDsmb");
    }

    private boolean hasClosePermission() {
        return this.hasGenericPermission("protocolClose");
    }

    private boolean hasCloseUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolClose");
    }

    @Override
    protected boolean hasExpirePermission() {
        return this.hasGenericPermission("protocolExpire");
    }

    @Override
    protected boolean hasExpireUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolExpire");
    }

    @Override
    protected boolean hasTerminatePermission() {
        return this.hasGenericPermission("protocolTerminate");
    }

    @Override
    protected boolean hasTerminateUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolTerminate");
    }

    @Override
    protected ProtocolTaskBase getExpireTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    @Override
    protected ProtocolTaskBase getExpireUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    @Override
    protected ProtocolTaskBase getTerminateTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    @Override
    protected ProtocolTaskBase getTerminateUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    private boolean hasPermitDataAnalysisPermission() {
        return this.hasGenericPermission("protocolPermitDataAnalysis");
    }

    private boolean hasPermitDataAnalysisUnavailablePermission() {
        return this.hasGenericUnavailablePermission("protocolPermitDataAnalysis");
    }

    @Override
    protected boolean hasAdminCorrectionPermission() {
        return this.hasPermission("protocolAdminCorrection");
    }

    @Override
    protected boolean hasAdminCorrectionUnavailablePermission() {
        return this.hasPermission("protocolAdminCorrectionUnavailable");
    }

    @Override
    protected boolean hasUndoLastActionPermission() {
        return this.hasPermission("protocolUndoLastAction") && this.undoLastActionBean.canUndoLastAction();
    }

    @Override
    protected boolean hasUndoLastActionUnavailablePermission() {
        return this.hasPermission("protocolUndoLastAction") && !this.undoLastActionBean.canUndoLastAction();
    }

    @Override
    protected ProtocolTaskBase getAdminCorrectionProtocolTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    @Override
    protected ProtocolTaskBase getAdminCorrectionUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return null;
    }

    private boolean hasEnterRiskLevelPermission() {
        return this.hasPermission("protocolEnterRiskLevel");
    }

    private boolean hasDeferPermission() {
        return this.hasPermission("protocolDefer");
    }

    private boolean hasDeferUnavailablePermission() {
        return this.hasPermission("protocolDeferUnavailable");
    }

    private boolean hasApproveOtherPermission() {
        ProtocolTask task = new ProtocolTask("protocolApproveOther", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasManageNotesPermission() {
        ProtocolTask task = new ProtocolTask("protocolManageNotes", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasManageNotesUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolManageNotesUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    @Override
    protected boolean hasPermission(String taskName) {
        ProtocolTask task = new ProtocolTask(taskName, this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasGenericPermission(String genericActionName) {
        ProtocolTask task = new ProtocolTask("genericProtocolAction", this.getProtocol(), genericActionName);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasGenericUnavailablePermission(String genericActionName) {
        ProtocolTask task = new ProtocolTask("genericProtocolActionUnavailable", this.getProtocol(), genericActionName);
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasIrbAcknowledgementPermission() {
        ProtocolTask task = new ProtocolTask("irbAcknowledgement", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasIrbAcknowledgementUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("irbAcknowledgementUnavailable", this.getProtocol());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    private boolean hasReviewNotRequiredPermission() {
        ProtocolTask task = new ProtocolTask("protocolReviewNotRequired", this.getProtocol());
        boolean retVal = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
        return retVal;
    }

    private boolean hasReviewNotRequiredUnavailablePermission() {
        ProtocolTask task = new ProtocolTask("protocolReviewNotRequiredUnavailable", this.getProtocol());
        boolean retVal = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
        return retVal;
    }

    private boolean hasCloseRequestLastAction() {
        return "105".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    private boolean hasCloseEnrollmentRequestLastAction() {
        return "108".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    private boolean hasDataAnalysisRequestLastAction() {
        return "114".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    private boolean hasReopenEnrollmentRequestLastAction() {
        return "115".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    private boolean hasSuspendRequestLastAction() {
        return "106".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    private boolean hasTerminateRequestLastAction() {
        return "104".equals(this.getLastPerformedAction().getProtocolActionTypeCode());
    }

    @Override
    public Protocol getProtocol() {
        return (Protocol)super.getProtocol();
    }

    public ProtocolRequestBean getProtocolCloseEnrollmentRequestBean() {
        return this.protocolCloseEnrollmentRequestBean;
    }

    public ProtocolRequestBean getProtocolReOpenEnrollmentRequestBean() {
        return this.protocolReOpenEnrollmentRequestBean;
    }

    public ProtocolRequestBean getProtocolDataAnalysisRequestBean() {
        return this.protocolDataAnalysisRequestBean;
    }

    public ProtocolNotifyIrbBean getProtocolNotifyIrbBean() {
        return this.protocolNotifyIrbBean;
    }

    public ProtocolAssignCmtSchedBean getAssignCmtSchedBean() {
        return this.assignCmtSchedBean;
    }

    public ProtocolAssignReviewersBean getProtocolAssignReviewersBean() {
        return this.protocolAssignReviewersBean;
    }

    public ProtocolGrantExemptionBean getProtocolGrantExemptionBean() {
        return this.protocolGrantExemptionBean;
    }

    public ProtocolApproveBean getProtocolExpeditedApprovalBean() {
        return this.protocolExpeditedApprovalBean;
    }

    public ProtocolApproveBean getProtocolResponseApprovalBean() {
        return this.protocolResponseApprovalBean;
    }

    public ProtocolGenericActionBean getProtocolReopenEnrollmentBean() {
        return this.protocolReopenEnrollmentBean;
    }

    public ProtocolGenericActionBean getProtocolCloseEnrollmentBean() {
        return this.protocolCloseEnrollmentBean;
    }

    public ProtocolGenericActionBean getProtocolSuspendByDsmbBean() {
        return this.protocolSuspendByDsmbBean;
    }

    public ProtocolGenericActionBean getProtocolPermitDataAnalysisBean() {
        return this.protocolPermitDataAnalysisBean;
    }

    public ProtocolGenericActionBean getProtocolIrbAcknowledgementBean() {
        return this.protocolIrbAcknowledgementBean;
    }

    @Override
    public UndoLastActionBean getUndoLastActionBean() {
        if (null != this.undoLastActionBean) {
            this.undoLastActionBean.refreshActionsPerformed();
        }
        return this.undoLastActionBean;
    }

    public ProtocolModifySubmissionBean getProtocolModifySubmissionBean() {
        return this.protocolModifySubmissionBean;
    }

    public boolean getCanNotifyIrb() {
        return this.canNotifyIrb;
    }

    public boolean getCanNotifyIrbUnavailable() {
        return this.canNotifyIrbUnavailable;
    }

    public boolean getCanRequestClose() {
        return this.canRequestClose;
    }

    public boolean getCanRequestCloseUnavailable() {
        return this.canRequestCloseUnavailable;
    }

    public boolean getCanRequestCloseEnrollment() {
        return this.canRequestCloseEnrollment;
    }

    public boolean getCanRequestCloseEnrollmentUnavailable() {
        return this.canRequestCloseEnrollmentUnavailable;
    }

    public boolean getCanRequestReOpenEnrollment() {
        return this.canRequestReOpenEnrollment;
    }

    public boolean getCanRequestReOpenEnrollmentUnavailable() {
        return this.canRequestReOpenEnrollmentUnavailable;
    }

    public boolean getCanRequestDataAnalysis() {
        return this.canRequestDataAnalysis;
    }

    public boolean getCanRequestDataAnalysisUnavailable() {
        return this.canRequestDataAnalysisUnavailable;
    }

    public boolean getCanGrantExemption() {
        return this.canGrantExemption;
    }

    public boolean getCanGrantExemptionUnavailable() {
        return this.canGrantExemptionUnavailable;
    }

    public boolean getCanApproveExpedited() {
        return this.canApproveExpedited;
    }

    public boolean getCanApproveExpeditedUnavailable() {
        return this.canApproveExpeditedUnavailable;
    }

    public boolean getCanReopenEnrollment() {
        return this.canReopenEnrollment;
    }

    public boolean getCanReopenEnrollmentUnavailable() {
        return this.canReopenEnrollmentUnavailable;
    }

    public boolean getCanCloseEnrollment() {
        return this.canCloseEnrollment;
    }

    public boolean getCanCloseEnrollmentUnavailable() {
        return this.canCloseEnrollmentUnavailable;
    }

    public boolean getCanSuspendByDsmb() {
        return this.canSuspendByDsmb;
    }

    public boolean getCanSuspendByDsmbUnavailable() {
        return this.canSuspendByDsmbUnavailable;
    }

    public boolean getCanPermitDataAnalysis() {
        return this.canPermitDataAnalysis;
    }

    public boolean getCanPermitDataAnalysisUnavailable() {
        return this.canPermitDataAnalysisUnavailable;
    }

    public boolean getCanEnterRiskLevel() {
        return this.canEnterRiskLevel;
    }

    public boolean getCanIrbAcknowledgement() {
        return this.canIrbAcknowledgement;
    }

    public boolean getCanIrbAcknowledgementUnavailable() {
        return this.canIrbAcknowledgementUnavailable;
    }

    public boolean getCanDefer() {
        return this.canDefer;
    }

    public boolean getCanDeferUnavailable() {
        return this.canDeferUnavailable;
    }

    public boolean getCanReviewNotRequired() {
        return this.canReviewNotRequired;
    }

    public boolean getCanReviewNotRequiredUnavailable() {
        return this.canReviewNotRequiredUnavailable;
    }

    public boolean getCanAddCloseReviewerComments() {
        return this.canAddCloseReviewerComments;
    }

    public boolean getCanAddCloseEnrollmentReviewerComments() {
        return this.canAddCloseEnrollmentReviewerComments;
    }

    public boolean getCanAddDataAnalysisReviewerComments() {
        return this.canAddDataAnalysisReviewerComments;
    }

    public boolean getCanAddReopenEnrollmentReviewerComments() {
        return this.canAddReopenEnrollmentReviewerComments;
    }

    public void setPrintTag(String printTag) {
        this.printTag = printTag;
    }

    public String getPrintTag() {
        return this.printTag;
    }

    @Override
    public void initFilterDatesView() {
        java.util.Date dayBeforeStartDate = null;
        java.util.Date dayAfterEndDate = null;
        if (this.filteredHistoryStartDate != null && this.filteredHistoryEndDate != null) {
            dayBeforeStartDate = DateUtils.addDays((java.util.Date)this.filteredHistoryStartDate, (int)-1);
            dayAfterEndDate = DateUtils.addDays((java.util.Date)this.filteredHistoryEndDate, (int)1);
        }
        for (ProtocolActionBase protocolAction : this.getSortedProtocolActions()) {
            Timestamp actionDate = protocolAction.getActionDate();
            if (dayBeforeStartDate != null && dayAfterEndDate != null) {
                protocolAction.setIsInFilterView(actionDate.after(dayBeforeStartDate) && actionDate.before(dayAfterEndDate));
            } else {
                protocolAction.setIsInFilterView(true);
            }
            if (!protocolAction.getIsInFilterView()) continue;
            ((ProtocolAction)protocolAction).setQuestionnairePrintOptionFromHelper(this);
        }
    }

    @Override
    public List<ProtocolActionBase> getSortedProtocolActions() {
        ArrayList<ProtocolActionBase> protocolActions = new ArrayList<ProtocolActionBase>();
        for (ProtocolActionBase protocolAction : this.form.getProtocolDocument().getProtocol().getProtocolActions()) {
            if (protocolAction.getSubmissionNumber() != null && ACTION_TYPE_SUBMISSION_DOC.contains(protocolAction.getProtocolActionTypeCode())) {
                protocolAction.setProtocolSubmissionDocs(new ArrayList<ProtocolSubmissionDocBase>(this.getSubmissionDocs(protocolAction)));
            }
            protocolActions.add((ProtocolAction)protocolAction);
        }
        Collections.sort(protocolActions, new Comparator<ProtocolAction>(){

            @Override
            public int compare(ProtocolAction action1, ProtocolAction action2) {
                return action2.getActualActionDate().compareTo(action1.getActualActionDate());
            }
        });
        return protocolActions;
    }

    protected CommitteeDecisionService getCommitteeDecisionService() {
        return (CommitteeDecisionService)KraServiceLocator.getService("protocolCommitteeDecisionService");
    }

    @Override
    public int getTotalSubmissions() {
        return this.getProtocolSubmitActionService().getTotalSubmissions(this.getProtocol());
    }

    @Override
    public void initSubmissionDetails() {
        if (this.currentSubmissionNumber <= 0) {
            this.currentSubmissionNumber = this.getTotalSubmissions();
        }
        if (CollectionUtils.isNotEmpty(this.getProtocol().getProtocolSubmissions()) && this.getProtocol().getProtocolSubmissions().size() > 1) {
            this.setPrevNextFlag();
        } else {
            this.setPrevDisabled(true);
            this.setNextDisabled(true);
        }
        this.setReviewComments(this.getReviewerCommentsService().getReviewerComments(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        if (CollectionUtils.isNotEmpty(this.getReviewComments())) {
            if (this.protocolManageReviewCommentsBean.getReviewCommentsBean().getReviewComments().size() == 0 && this.protocolManageReviewCommentsBean.getReviewCommentsBean().getDeletedReviewComments().size() == 0) {
                List<CommitteeScheduleMinuteBase> reviewComments = this.getReviewerCommentsService().getReviewerComments(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber);
                Collections.sort(reviewComments, new Comparator<CommitteeScheduleMinute>(){

                    @Override
                    public int compare(CommitteeScheduleMinute csm1, CommitteeScheduleMinute csm2) {
                        int retVal = 0;
                        if (csm1 != null && csm2 != null && csm1.getEntryNumber() != null && csm2.getEntryNumber() != null) {
                            retVal = csm1.getEntryNumber().compareTo(csm2.getEntryNumber());
                        }
                        return retVal;
                    }
                });
                this.protocolManageReviewCommentsBean.getReviewCommentsBean().setReviewComments(reviewComments);
                this.getReviewerCommentsService().setHideReviewerName(reviewComments);
            }
            this.getReviewerCommentsService().setHideReviewerName(this.getReviewComments());
        }
        this.setReviewAttachments(this.getReviewerCommentsService().getReviewerAttachments(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        if (CollectionUtils.isNotEmpty(this.getReviewAttachments())) {
            this.hideReviewerNameForAttachment = this.getReviewerCommentsService().setHideReviewerName(this.getReviewAttachments());
            this.getReviewerCommentsService().setHideViewButton(this.getReviewAttachments());
        }
        this.getProtocol().getProtocolSubmission().refreshReferenceObject("reviewAttachments");
        this.hideSubmissionReviewerName = this.checkToHideSubmissionReviewerName();
        this.populateReviewersAndOnlineReviewsMap();
        this.setAbstainees(this.getCommitteeDecisionService().getAbstainers(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        this.setRecusers(this.getCommitteeDecisionService().getRecusers(this.getProtocol().getProtocolNumber(), this.currentSubmissionNumber));
        this.protocolSubmissionQuestionnaireHelper = new IrbSubmissionQuestionnaireHelper(this.getProtocol(), null, Integer.toString(this.currentSubmissionNumber), true);
        this.protocolSubmissionQuestionnaireHelper.populateAnswers();
        this.setSubmissionQuestionnaireExist(!this.protocolSubmissionQuestionnaireHelper.getAnswerHeaders().isEmpty());
    }

    @Override
    protected void setAmendmentDetails() throws Exception {
        if (!this.currentTaskName.equalsIgnoreCase("modifyAmendmentSections")) {
            ProtocolAmendmentBean amendmentBean = (ProtocolAmendmentBean)this.getProtocolAmendmentBean();
            String originalProtocolNumber = this.getProtocol().isAmendment() ? this.getProtocol().getProtocolAmendRenewal().getProtocolNumber() : this.getProtocol().getProtocolNumber();
            List<ProtocolBase> protocols = this.getProtocolAmendRenewServiceHook().getAmendmentAndRenewals(originalProtocolNumber);
            ProtocolAmendRenewal correctAmendment = (ProtocolAmendRenewal)this.getCorrectAmendment(protocols);
            this.setSubmissionHasNoAmendmentDetails(true);
        }
    }

    @Override
    protected String getCoeusModule() {
        return "7";
    }

    @Override
    protected ModuleQuestionnaireBean getQuestionnaireBean(String moduleCode, String moduleKey, String subModuleCode, String subModuleKey, boolean finalDoc) {
        return new ProtocolModuleQuestionnaireBean(moduleCode, moduleKey, subModuleCode, subModuleKey, finalDoc);
    }

    public void addNotifyIrbAttachment() {
        this.getProtocolNotifyIrbBean().getActionAttachments().add(this.getProtocolNotifyIrbBean().getNewActionAttachment());
        this.getProtocolNotifyIrbBean().setNewActionAttachment(new ProtocolActionAttachment());
    }

    public boolean validFile(ProtocolActionAttachment attachment, String propertyName) {
        boolean valid = true;
        if (attachment.getFile() == null || StringUtils.isBlank((String)attachment.getFile().getFileName())) {
            valid = false;
            new ErrorReporter().reportError("actionHelper." + propertyName + ".newActionAttachment.file", "error.attachment.required", new String[0]);
        }
        return valid;
    }

    public ProtocolGenericActionBean getProtocolDeferBean() {
        return this.protocolDeferBean;
    }

    public ProtocolReviewNotRequiredBean getProtocolReviewNotRequiredBean() {
        return this.protocolReviewNotRequiredBean;
    }

    public ProtocolRequestBean getRequestBean(String actionTypeCode) {
        ProtocolActionBean bean;
        ProtocolRequestBean protocolRequestBean = null;
        ProtocolRequestAction action = ProtocolRequestAction.valueOfActionTypeCode(actionTypeCode);
        if (action != null && (bean = (ProtocolActionBean)this.actionBeanTaskMap.get(action.getTaskName())) instanceof ProtocolRequestBean) {
            protocolRequestBean = (ProtocolRequestBean)bean;
        }
        return protocolRequestBean;
    }

    @Override
    public boolean isSubmissionQuestionnaireExist() {
        return this.submissionQuestionnaireExist;
    }

    @Override
    public void setSubmissionQuestionnaireExist(boolean submissionQuestionnaireExist) {
        this.submissionQuestionnaireExist = submissionQuestionnaireExist;
    }

    @Override
    public boolean isToAnswerSubmissionQuestionnaire() {
        return this.toAnswerSubmissionQuestionnaire;
    }

    @Override
    public void setToAnswerSubmissionQuestionnaire(boolean toAnswerSubmissionQuestionnaire) {
        this.toAnswerSubmissionQuestionnaire = toAnswerSubmissionQuestionnaire;
    }

    public boolean isIrbAdmin() {
        return this.getKraAuthorizationService().hasRole(GlobalVariables.getUserSession().getPrincipalId(), NAMESPACE, "IRB Administrator");
    }

    @Override
    protected String getSRRProtocolActionTypeHook() {
        return "202";
    }

    @Override
    protected String getSMRProtocolActionTypeHook() {
        return "203";
    }

    @Override
    protected String getReturnToPIActionTypeHook() {
        return "213";
    }

    @Override
    protected String getDisapprovedProtocolActionTypeHook() {
        return "304";
    }

    @Override
    protected String getProtocolActionTypeCodeForManageReviewCommentsHook() {
        return "310";
    }

    @Override
    protected org.kuali.kra.protocol.actions.decision.CommitteeDecision<?> getNewCommitteeDecisionInstanceHook(ActionHelperBase actionHelper) {
        return new CommitteeDecision((ActionHelper)actionHelper);
    }

    @Override
    protected org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean getNewProtocolAssignToAgendaBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolAssignToAgendaBean((ActionHelper)actionHelper);
    }

    @Override
    protected ProtocolAdministrativelyWithdrawBean getNewProtocolAdminWithdrawBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolAdministrativelyWithdrawBean((ActionHelper)actionHelper);
    }

    @Override
    protected ProtocolAdministrativelyIncompleteBean getNewProtocolAdminIncompleteBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolAdministrativelyIncompleteBean((ActionHelper)actionHelper);
    }

    @Override
    protected String getAdminApprovalProtocolActionTypeHook() {
        return "204";
    }

    @Override
    protected String getFullApprovalProtocolActionTypeHook() {
        return "204";
    }

    @Override
    protected ProtocolWithdrawBean getNewProtocolWithdrawBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolWithdrawBean((ActionHelper)actionHelper);
    }

    @Override
    protected ProtocolAmendmentBean getNewProtocolAmendmentBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolAmendmentBean((ActionHelper)actionHelper);
    }

    @Override
    protected ProtocolNotifyCommitteeBean getNewProtocolNotifyCommitteeBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolNotifyCommitteeBean((ActionHelper)actionHelper);
    }

    @Override
    protected ProtocolSubmitAction getNewProtocolSubmitActionInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolSubmitAction((ActionHelper)actionHelper);
    }

    @Override
    protected ProtocolDeleteBean getNewProtocolDeleteBeanInstanceHook(ActionHelperBase actionHelper) {
        return new ProtocolDeleteBean((ActionHelper)actionHelper);
    }

    @Override
    protected AdminCorrectionBean getNewAdminCorrectionBeanInstanceHook(ActionHelperBase actionHelper) {
        return new AdminCorrectionBean((ActionHelper)actionHelper);
    }

    @Override
    protected UndoLastActionBean getNewUndoLastActionBeanInstanceHook() {
        return new UndoLastActionBean(this);
    }

    @Override
    protected String getAbandonActionTypeHook() {
        return "119";
    }

    @Override
    protected String getAbandonPropertyKeyHook() {
        return "actionHelper.protocolAbandonBean";
    }

    @Override
    protected String getExpireKeyHook() {
        return "305";
    }

    @Override
    protected String getTerminateKeyHook() {
        return "301";
    }

    @Override
    protected String getSuspendKeyHook() {
        return "302";
    }

    protected Class<ReviewCommentsService> getReviewCommentsServiceClassHook() {
        return ReviewCommentsService.class;
    }

    @Override
    protected ProtocolApproveBean getNewProtocolApproveBeanInstanceHook(ActionHelperBase actionHelper, String errorPropertyKey) {
        return new ProtocolApproveBean((ActionHelper)actionHelper, errorPropertyKey);
    }

    @Override
    protected ProtocolTaskBase getNewAdminApproveProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("adminApproveProtocol", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAdminApproveUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("adminApproveProtocolUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAdminWithdrawProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("adminWithdrawProtocol", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAdminWithdrawUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("adminWithdrawProtocolUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAdminMarkIncompleteProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("adminMarkIncompleteProtocol", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAdminMarkIncompleteUnavailableProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("adminMarkIncompleteProtocolUnavailable", this.getProtocol());
    }

    @Override
    protected Class<? extends CommitteeScheduleServiceBase> getCommitteeScheduleServiceClassHook() {
        return CommitteeScheduleService.class;
    }

    @Override
    protected Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook() {
        return ProtocolDocument.class;
    }

    @Override
    protected ProtocolTaskBase getNewSubmitProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("submitProtocol", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewSubmitProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("submitProtocolUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAmendmentProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("createAmendment", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewAmendmentProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("createAmendmentUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getModifyAmendmentSectionsProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyAmendmentSections", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getModifyAmendmentSectionsUnavailableProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyAmendmentSectionsUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewRenewalProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("createRenewal", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewRenewalProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("createRenewalUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewWithdrawProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolWithdraw", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getNewWithdrawProtocolUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolWithdrawUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase createNewAmendRenewDeleteTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolAmendRenewDelete", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase createNewAmendRenewDeleteUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolAmendRenewDeleteUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase createNewAssignToAgendaTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolAssignToAgenda", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase createNewAssignToAgendaUnavailableTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolAssignToAgendaUnavailable", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase createNewAbandonTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("protocolAbandon", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getModifySubmissionAvailableTaskHook() {
        return new ProtocolTask("modifyProtocolSubmisison", this.getProtocol());
    }

    @Override
    protected ProtocolTaskBase getModifySubmissionUnavailableTaskHook() {
        return new ProtocolTask("modifyProtocolSubmisisonUnavailable", this.getProtocol());
    }

    @Override
    protected Class<? extends ProtocolSubmissionDocBase> getProtocolSubmissionDocClassHook() {
        return ProtocolSubmissionDoc.class;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return CommitteeService.class;
    }

    @Override
    protected Class<? extends org.kuali.kra.protocol.actions.followup.FollowupActionService<?>> getFollowupActionServiceClassHook() {
        return FollowupActionService.class;
    }

    @Override
    protected ProtocolQuestionnairePrintingService getProtocolQuestionnairePrintingServiceHook() {
        return KraServiceLocator.getService(ProtocolQuestionnairePrintingService.class);
    }

    @Override
    protected ProtocolModuleQuestionnaireBeanBase getNewProtocolModuleQuestionnaireBeanInstanceHook(ProtocolBase protocol) {
        return new ProtocolModuleQuestionnaireBean((Protocol)protocol);
    }

    @Override
    protected void enableModuleOption(org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean amendmentBean, ProtocolAmendRenewalBase correctAmendment) {
    }

    @Override
    protected ProtocolSubmissionQuestionnaireHelper getProtocolSubmissionQuestionnaireHelperHook(ProtocolBase protocol, String actionTypeCode, String submissionNumber, boolean finalDoc) {
        return new IrbSubmissionQuestionnaireHelper(protocol, actionTypeCode, submissionNumber, finalDoc);
    }

    public boolean isReviewersDisplayToBeSuppressed() {
        boolean retVal = false;
        ProtocolSubmitAction submitBean = (ProtocolSubmitAction)this.getProtocolSubmitAction();
        if (!this.canAssignReviewersCmtSel || StringUtils.isBlank((String)submitBean.getScheduleId()) && !submitBean.isExpeditedProtocolReviewType() || StringUtils.isBlank((String)submitBean.getCommitteeId())) {
            retVal = true;
        }
        return retVal;
    }

    static {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("116");
        codes.add("105");
        codes.add("114");
        codes.add("106");
        codes.add("115");
        codes.add("104");
        codes.add("108");
        ACTION_TYPE_SUBMISSION_DOC = codes;
    }
}

