/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.notification.NotificationRenderer;
import org.kuali.kra.common.notification.bo.NotificationTypeRecipient;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.ProtocolRequestAction;
import org.kuali.kra.irb.actions.ProtocolRiskLevelCommentable;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.abandon.ProtocolAbandonService;
import org.kuali.kra.irb.actions.amendrenew.CreateAmendmentEvent;
import org.kuali.kra.irb.actions.amendrenew.CreateRenewalEvent;
import org.kuali.kra.irb.actions.amendrenew.ModifyAmendmentSectionsEvent;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveEvent;
import org.kuali.kra.irb.actions.approve.ProtocolApproveService;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaEvent;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedEvent;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersBean;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersEvent;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.irb.actions.copy.ProtocolCopyService;
import org.kuali.kra.irb.actions.correction.AdminCorrectionBean;
import org.kuali.kra.irb.actions.correction.ProtocolAdminCorrectionEvent;
import org.kuali.kra.irb.actions.correspondence.AbstractProtocolActionsCorrespondence;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionAbstainerEvent;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionEvent;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionRecuserEvent;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionService;
import org.kuali.kra.irb.actions.decision.CommitteePerson;
import org.kuali.kra.irb.actions.delete.ProtocolDeleteService;
import org.kuali.kra.irb.actions.expeditedapprove.ProtocolExpeditedApproveBean;
import org.kuali.kra.irb.actions.expeditedapprove.ProtocolExpeditedApproveEvent;
import org.kuali.kra.irb.actions.followup.FollowupActionService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionEvent;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.irb.actions.grantexemption.GrantExemptionCorrespondence;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionEvent;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionService;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionEvent;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionService;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredEvent;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredService;
import org.kuali.kra.irb.actions.notification.AssignReviewerNotificationRenderer;
import org.kuali.kra.irb.actions.notification.NotifyCommitteeNotificationRenderer;
import org.kuali.kra.irb.actions.notification.NotifyIrbNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolClosedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolDisapprovedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolExpiredNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.actions.notification.ProtocolSuspendedByDSMBNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolSuspendedNotificationRenderer;
import org.kuali.kra.irb.actions.notification.ProtocolTerminatedNotificationRenderer;
import org.kuali.kra.irb.actions.notifycommittee.ProtocolNotifyCommitteeBean;
import org.kuali.kra.irb.actions.notifycommittee.ProtocolNotifyCommitteeService;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbBean;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbService;
import org.kuali.kra.irb.actions.print.ProtocolActionPrintEvent;
import org.kuali.kra.irb.actions.print.ProtocolPrintType;
import org.kuali.kra.irb.actions.print.ProtocolPrintingService;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestEvent;
import org.kuali.kra.irb.actions.request.ProtocolRequestService;
import org.kuali.kra.irb.actions.reviewcomments.ProtocolAddReviewAttachmentEvent;
import org.kuali.kra.irb.actions.reviewcomments.ProtocolAddReviewCommentEvent;
import org.kuali.kra.irb.actions.reviewcomments.ProtocolManageReviewAttachmentEvent;
import org.kuali.kra.irb.actions.reviewcomments.ReviewAttachmentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.irb.actions.risklevel.ProtocolAddRiskLevelEvent;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevelBean;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevelService;
import org.kuali.kra.irb.actions.risklevel.ProtocolUpdateRiskLevelEvent;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionEvent;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.actions.submit.ValidProtocolActionAction;
import org.kuali.kra.irb.actions.undo.UndoLastActionBean;
import org.kuali.kra.irb.actions.undo.UndoLastActionService;
import org.kuali.kra.irb.actions.withdraw.ProtocolWithdrawService;
import org.kuali.kra.irb.actions.withdraw.WithdrawCorrespondence;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondence;
import org.kuali.kra.irb.noteattachment.AddProtocolNotepadEvent;
import org.kuali.kra.irb.noteattachment.AddProtocolNotepadRuleImpl;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.noteattachment.ProtocolNotepad;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.onlinereview.ProtocolReviewAttachment;
import org.kuali.kra.irb.questionnaire.ProtocolQuestionnaireAuditRule;
import org.kuali.kra.irb.summary.ProtocolSummary;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.WatermarkService;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolOnlineReviewCommentable;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class ProtocolProtocolActionsAction
extends ProtocolAction
implements AuditModeAction {
    private static final Log LOG = LogFactory.getLog(ProtocolProtocolActionsAction.class);
    private static final String CONFIRM_NO_ACTION = "";
    private static final String CONFIRM_DELETE_ACTION_ATT = "confirmDeleteActionAttachment";
    private static final String CONFIRM_FOLLOWUP_ACTION = "confirmAddFollowupAction";
    private static final String PROTOCOL_TAB = "protocol";
    private static final String PROTOCOL_ACTIONS_TAB = "protocolActions";
    private static final String CONFIRM_SUBMIT_FOR_REVIEW_KEY = "confirmSubmitForReview";
    private static final String CONFIRM_ASSIGN_TO_AGENDA_KEY = "confirmAssignToAgenda";
    private static final String CONFIRM_ASSIGN_CMT_SCHED_KEY = "confirmAssignCmtSched";
    private static final String CONIFRM_REMOVE_REVIEWER_KEY = "confirmRemoveReviewer";
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final String CONFIRM_DELETE_PROTOCOL_KEY = "confirmDeleteProtocol";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String SUBMISSION_ID = "submissionId";
    private static final String CORRESPONDENCE = "correspondence";
    private static final Map<String, String> PRINTTAG_MAP = new HashMap<String, String>(){
        {
            this.put("summary", "PROTOCOL_SUMMARY_VIEW_REPORT");
            this.put("full", "PROTOCOL_FULL_PROTOCOL_REPORT");
            this.put("history", "PROTOCOL_PROTOCOL_HISTORY_REPORT");
            this.put("comments", "PROTOCOL_REVIEW_COMMENTS_REPORT");
        }
    };
    private static Map<String, String> motionTypeMap = new HashMap<String, String>(){
        {
            this.put("1", "Approve Action");
            this.put("2", "Disapprove");
            this.put("3", "Return for Specific Minor Revisions");
            this.put("4", "Return for Substantive Revisions Required");
        }
    };
    private static final List GENERIC_TYPE_PONDENCE;
    private static final Map<String, String> CORR_TYPE_TO_ACTION_TYPE_MAP;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String currentTaskName = this.getTaskName(request);
        if (currentTaskName != null) {
            protocolForm.getActionHelper().setCurrentTask(currentTaskName);
        } else {
            protocolForm.getActionHelper().setCurrentTask(CONFIRM_NO_ACTION);
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        protocolForm.getActionHelper().prepareView();
        protocolForm.getActionHelper().initSubmissionDetails();
        return actionForward;
    }

    public ActionForward copyProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ApplicationTask task = new ApplicationTask("createProtocol");
        if (this.isAuthorized(task)) {
            String newDocId = this.getProtocolCopyService().copyProtocol(protocolForm.getProtocolDocument()).getDocumentNumber();
            protocolForm.setDocId(newDocId);
            protocolForm.setViewOnly(false);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolDocument().setViewOnly(protocolForm.isViewOnly());
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            protocolForm.getActionHelper().prepareCommentsView();
            return mapping.findForward(PROTOCOL_TAB);
        }
        return mapping.findForward("basic");
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (ProtocolForm)form, true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new AuditActionHelper().setAuditMode(mapping, (ProtocolForm)form, false);
    }

    public ActionForward refreshPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward submitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolSubmitAction submitAction;
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        protocolForm.setAuditActivated(true);
        ProtocolTask task = new ProtocolTask("submitProtocol", protocolDocument.getProtocol());
        if (this.isAuthorized(task) && this.applyRules(protocolForm, (KualiDocumentEvent)new ProtocolSubmitActionEvent(protocolDocument, submitAction = (ProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction()))) {
            AuditActionHelper auditActionHelper = new AuditActionHelper();
            if (auditActionHelper.auditUnconditionally((Document)protocolDocument)) {
                forward = this.isCommitteeMeetingAssignedMaxProtocols(submitAction.getNewCommitteeId(), submitAction.getNewScheduleId()) ? this.confirm(this.buildSubmitForReviewConfirmationQuestion(mapping, form, request, response), CONFIRM_SUBMIT_FOR_REVIEW_KEY, CONFIRM_NO_ACTION) : this.submitForReviewAndRedirect(mapping, form, request, response);
            } else {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            }
        }
        return forward;
    }

    private boolean isCommitteeMeetingAssignedMaxProtocols(String committeeId, String scheduleId) {
        CommitteeSchedule schedule;
        boolean isMax = false;
        Committee committee = (Committee)this.getCommitteeService().getCommitteeById(committeeId);
        if (committee != null && (schedule = (CommitteeSchedule)this.getCommitteeService().getCommitteeSchedule(committee, scheduleId)) != null) {
            int currentSubmissionCount = schedule.getLatestProtocolSubmissions() == null ? 0 : this.activeSubmissonCount(schedule.getLatestProtocolSubmissions());
            int maxSubmissionCount = schedule.getMaxProtocols();
            isMax = currentSubmissionCount >= maxSubmissionCount;
        }
        return isMax;
    }

    private int activeSubmissonCount(List<ProtocolSubmission> submissions) {
        int count = 0;
        for (ProtocolSubmission submission : submissions) {
            if (!submission.getProtocol().isActive()) continue;
            ++count;
        }
        return count;
    }

    private StrutsConfirmation buildSubmitForReviewConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SUBMIT_FOR_REVIEW_KEY, "question.protocol.confirmExceedMaxProtocols", new String[0]);
    }

    public ActionForward confirmSubmitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SUBMIT_FOR_REVIEW_KEY.equals(question)) {
            forward = this.submitForReviewAndRedirect(mapping, form, request, response);
        }
        return forward;
    }

    private ActionForward submitForReviewAndRedirect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        Protocol protocol = protocolDocument.getProtocol();
        ProtocolSubmitAction submitAction = (ProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction();
        this.getProtocolSubmitActionService().submitToIrbForReview(protocol, submitAction);
        protocolForm.getActionHelper().getAssignCmtSchedBean().init();
        super.route(mapping, (ActionForm)protocolForm, request, response);
        AssignReviewerNotificationRenderer renderer1 = new AssignReviewerNotificationRenderer(protocolForm.getProtocolDocument().getProtocol(), "added");
        List<ProtocolNotificationRequestBean> addReviewerNotificationBeans = this.getNotificationRequestBeans(submitAction.getReviewers(), "create");
        if (!CollectionUtils.isEmpty(addReviewerNotificationBeans)) {
            ProtocolNotificationRequestBean notificationBean1 = addReviewerNotificationBeans.get(0);
            IRBNotificationContext context1 = new IRBNotificationContext(notificationBean1.getProtocol(), notificationBean1.getProtocolOnlineReview(), notificationBean1.getActionType(), notificationBean1.getDescription(), (NotificationRenderer)renderer1);
            this.getNotificationService().sendNotificationAndPersist(context1, new IRBProtocolNotification(), protocol);
        }
        ProtocolNotificationRequestBean notificationBean2 = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "321", "Submit");
        IRBNotificationRenderer renderer2 = new IRBNotificationRenderer(notificationBean2.getProtocol());
        IRBNotificationContext context2 = new IRBNotificationContext(protocol, notificationBean2.getActionType(), notificationBean2.getDescription(), (NotificationRenderer)renderer2);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context2)) {
            context2.setForwardName("holdingPage");
            protocolForm.getNotificationHelper().initializeDefaultValues(context2);
            return mapping.findForward("protocolNotificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist(context2, new IRBProtocolNotification(), protocol);
        return this.routeProtocolToHoldingPage(mapping, protocolForm);
    }

    private ActionForward routeProtocolToHoldingPage(ActionMapping mapping, ProtocolForm protocolForm) {
        String routeHeaderId = protocolForm.getProtocolDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, PROTOCOL_ACTIONS_TAB, "ProtocolDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation);
    }

    public ActionForward withdrawProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("protocolWithdraw", protocolForm.getProtocolDocument().getProtocol());
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                ProtocolDocument pd = (ProtocolDocument)this.getProtocolWithdrawService().withdraw(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolWithdrawBean());
                protocolForm.setDocId(pd.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "303", "Withdrawn");
                protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
                this.recordProtocolActionSuccess("Withdraw");
                if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private ProtocolCorrespondence getProtocolCorrespondence(ProtocolForm protocolForm, String forwardName, ProtocolNotificationRequestBean notificationRequestBean, boolean holdingPage) {
        boolean result = false;
        HashMap<String, Long> keyValues = new HashMap<String, Long>();
        keyValues.put("actionIdFk", protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction().getProtocolActionId());
        List correspondences = (List)this.getBusinessObjectService().findMatching(ProtocolCorrespondence.class, keyValues);
        if (correspondences.isEmpty()) {
            return null;
        }
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)((Object)correspondences.get(0));
        correspondence.setForwardName(forwardName);
        correspondence.setNotificationRequestBean(notificationRequestBean);
        correspondence.setHoldingPage(holdingPage);
        return correspondence;
    }

    public ActionForward notifyIrbProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getActionHelper().preSaveSubmissionQuestionnaires();
        if (this.isMandatoryQuestionnaireComplete(protocolForm.getActionHelper().getProtocolNotifyIrbBean(), "actionHelper.protocolNotifyIrbBean.datavalidation")) {
            this.getProtocolNotifyIrbService().submitIrbNotification(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolNotifyIrbBean());
            protocolForm.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
            LOG.info((Object)("notifyIrbProtocol " + protocolForm.getProtocolDocument().getDocumentNumber()));
            this.recordProtocolActionSuccess("Notify IRB");
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "116", "Notify IRB"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward notifyCommitteeProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getActionHelper().setCurrentTask("protocolNotifyCommittee");
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionHelper actionHelper = protocolForm.getActionHelper();
        this.getProtocolNotifyCommitteeService().submitCommitteeNotification(protocol, (ProtocolNotifyCommitteeBean)actionHelper.getProtocolNotifyCommitteeBean());
        this.recordProtocolActionSuccess("Notify Committee");
        ProtocolNotificationRequestBean newNotificationBean = new ProtocolNotificationRequestBean(protocol, "109", "Notify Committee");
        newNotificationBean.setCommitteeName(actionHelper.getProtocolNotifyCommitteeBean().getCommitteeName());
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_ACTIONS_TAB, newNotificationBean, false));
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            return mapping.findForward(CORRESPONDENCE);
        }
        return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, newNotificationBean);
    }

    private boolean isMandatoryQuestionnaireComplete(ProtocolRequestBean submissionBean, String errorKey) {
        boolean valid = true;
        ProtocolQuestionnaireAuditRule auditRule = new ProtocolQuestionnaireAuditRule();
        if (!auditRule.isMandatorySubmissionQuestionnaireComplete(submissionBean.getQuestionnaireHelper().getAnswerHeaders())) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(errorKey, "error.mandatory.questionnaire", new String[0]);
            valid = false;
        }
        return valid;
    }

    public ActionForward createAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("createAmendment", protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateAmendmentEvent(protocolForm.getProtocolDocument(), "actionHelper.protocolCreateAmendment", (ProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createAmendment(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Amendment");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "323", "Amendment Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward modifyAmendmentSections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        protocolForm.getActionHelper().setCurrentTask("modifyAmendmentSections");
        ProtocolTask task = new ProtocolTask("modifyAmendmentSections", protocol);
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new ModifyAmendmentSectionsEvent((ProtocolDocumentBase)protocolForm.getProtocolDocument(), "actionHelper.protocolModifyAmendment", (ProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            this.getProtocolAmendRenewService().updateAmendmentRenewal(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
            return this.save(mapping, (ActionForm)protocolForm, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createRenewal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("createRenewal", protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateRenewalEvent(protocolForm.getProtocolDocument(), "actionHelper.renewalSummary", protocolForm.getActionHelper().getRenewalSummary()))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createRenewal(protocolForm.getProtocolDocument(), ((ProtocolForm)form).getActionHelper().getRenewalSummary());
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Renewal without Amendment");
            protocolForm.getActionHelper().getProtocolAmendmentBean().setSummary(protocolForm.getActionHelper().getRenewalSummary());
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "322", "Renewal Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createRenewalWithAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("createRenewal", protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            if (!this.applyRules((KualiDocumentEvent)new CreateAmendmentEvent(protocolForm.getProtocolDocument(), "actionHelper.protocolCreateRenewalWithAmendment", (ProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolRenewAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            String newDocId = this.getProtocolAmendRenewService().createRenewalWithAmendment(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolRenewAmendmentBean());
            protocolForm.setDocId(newDocId);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Create Renewal with Amendment");
            protocolForm.getActionHelper().setProtocolAmendmentBean(protocolForm.getActionHelper().getProtocolRenewAmendmentBean());
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "909", "Renewal With Amendment Created");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("protocolAmendRenewDelete", protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            return this.confirm(this.buildDeleteProtocolConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_PROTOCOL_KEY, CONFIRM_NO_ACTION);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_KEY.equals(question)) {
            ProtocolForm protocolForm = (ProtocolForm)form;
            this.getProtocolDeleteService().delete(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolDeleteBean());
            this.recordProtocolActionSuccess("Delete Protocol, Amendment, or Renewal");
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteProtocolConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocument doc = ((ProtocolForm)form).getProtocolDocument();
        String protocolNumber = doc.getProtocol().getProtocolNumber();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_KEY, "document.question.deleteProtocol.text", protocolNumber);
    }

    public ActionForward viewProtocolAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int selected = this.getSelectedLine(request);
        ProtocolAttachmentProtocol attachment = (ProtocolAttachmentProtocol)protocolForm.getProtocolDocument().getProtocol().getActiveAttachmentProtocolsNoDelete().get(selected);
        return this.printAttachmentProtocol(mapping, response, attachment, protocolForm);
    }

    public ActionForward viewProtocolPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int selected = this.getSelectedLine(request);
        ProtocolAttachmentPersonnel personAttach = (ProtocolAttachmentPersonnel)protocolForm.getProtocolDocument().getProtocol().getAttachmentPersonnels().get(selected);
        return this.printPersonnelAttachmentProtocol(mapping, response, personAttach, protocolForm);
    }

    public ActionForward printProtocolDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        ActionHelper actionHelper = protocolForm.getActionHelper();
        StringBuffer fileName = new StringBuffer().append("Protocol-");
        if (this.applyRules((KualiDocumentEvent)new ProtocolActionPrintEvent(protocolForm.getProtocolDocument(), actionHelper.getSummaryReport(), actionHelper.getFullReport(), actionHelper.getHistoryReport(), actionHelper.getReviewCommentsReport()))) {
            ProtocolPrintType printType = ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT;
            String reportName = protocol.getProtocolNumber() + "-" + printType.getReportName();
            AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getPrintReportArtifacts((ActionForm)protocolForm, fileName));
            if (dataStream.getContent() != null) {
                dataStream.setFileName(fileName.toString());
                PrintingUtils.streamToResponse(dataStream, response);
                forward = null;
            }
        }
        return forward;
    }

    private Map<Class, Object> getReportOptions(ProtocolForm protocolForm, ProtocolPrintType printType) {
        HashMap<Class, Object> reportParameters = new HashMap<Class, Object>();
        ProtocolSummaryPrintOptions summaryOptions = protocolForm.getActionHelper().getProtocolSummaryPrintOptions();
        if (printType.equals((Object)ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT)) {
            summaryOptions.setActions(true);
            summaryOptions.setAmendmentRenewalHistory(true);
            summaryOptions.setAmmendmentRenewalSummary(true);
            summaryOptions.setAreaOfResearch(true);
            summaryOptions.setAttachments(true);
            summaryOptions.setCorrespondents(true);
            summaryOptions.setDocuments(true);
            summaryOptions.setFundingSource(true);
            summaryOptions.setInvestigator(true);
            summaryOptions.setNotes(true);
            summaryOptions.setOrganizaition(true);
            summaryOptions.setProtocolDetails(true);
            summaryOptions.setReferences(true);
            summaryOptions.setRiskLevel(true);
            summaryOptions.setRoles(true);
            summaryOptions.setSpecialReview(true);
            summaryOptions.setStudyPersonnels(true);
            summaryOptions.setSubjects(true);
        }
        reportParameters.put(ProtocolSummaryPrintOptions.class, summaryOptions);
        return reportParameters;
    }

    public ActionForward printProtocolSelectedItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "Protocol_Summary_Report.pdf";
        ProtocolPrintType printType = ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT;
        String reportName = protocol.getProtocolNumber() + "-" + printType.getReportName();
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getPrintArtifacts((ActionForm)protocolForm));
        if (dataStream.getContent() != null) {
            dataStream.setFileName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward printProtocolQuestionnaires(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "Protocol_questionnaire_Report.pdf";
        String reportName = protocol.getProtocolNumber() + "-" + "ProtocolQuestionnaires";
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getQuestionnairePrintingService().getQuestionnairePrintable(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getQuestionnairesToPrints()));
        if (dataStream.getContent() != null) {
            dataStream.setFileName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private List<Printable> getPrintArtifacts(ActionForm form) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        org.kuali.kra.protocol.actions.print.ProtocolPrintType printType = org.kuali.kra.protocol.actions.print.ProtocolPrintType.valueOf(PRINTTAG_MAP.get("full"));
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintingService().getProtocolPrintable(printType);
        printable.setPrintableBusinessObject(protocolForm.getProtocolDocument().getProtocol());
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ProtocolSummaryPrintOptions summaryOptions = protocolForm.getActionHelper().getProtocolPrintOption();
        reportParameters.put((String)((Object)ProtocolSummaryPrintOptions.class), summaryOptions);
        printable.setReportParameters(reportParameters);
        printableArtifactList.add(printable);
        if (summaryOptions.isReviewComments()) {
            Map<Class, Object> reportParameters1 = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_REVIEW_COMMENTS_REPORT);
            AbstractPrint printable1 = (AbstractPrint)this.getProtocolPrintingService().getProtocolPrintable(org.kuali.kra.protocol.actions.print.ProtocolPrintType.valueOf(PRINTTAG_MAP.get("comments")));
            printable1.setPrintableBusinessObject(protocolForm.getProtocolDocument().getProtocol());
            printable1.setReportParameters(reportParameters1);
            printableArtifactList.add(printable1);
        }
        return printableArtifactList;
    }

    private List<Printable> getPrintReportArtifacts(ActionForm form, StringBuffer fileName) {
        Map<Class, Object> reportParameters;
        ProtocolForm protocolForm = (ProtocolForm)form;
        Boolean printSummary = protocolForm.getActionHelper().getSummaryReport();
        Boolean printFull = protocolForm.getActionHelper().getFullReport();
        Boolean printHistory = protocolForm.getActionHelper().getHistoryReport();
        Boolean printReviewComments = protocolForm.getActionHelper().getReviewCommentsReport();
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        if (printSummary.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_SUMMARY_VIEW_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "summary", fileName, reportParameters));
            protocolForm.getActionHelper().setSummaryReport(false);
        }
        if (printFull.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "full", fileName, reportParameters));
            protocolForm.getActionHelper().setFullReport(false);
        }
        if (printHistory.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_PROTOCOL_HISTORY_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "history", fileName, reportParameters));
            protocolForm.getActionHelper().setHistoryReport(false);
        }
        if (printReviewComments.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_REVIEW_COMMENTS_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "comments", fileName, reportParameters));
            protocolForm.getActionHelper().setReviewCommentsReport(false);
        }
        fileName.append("report.pdf");
        return printableArtifactList;
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, ProtocolAttachmentProtocol attachment, ProtocolForm form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        byte[] attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_ACTION);
        if ((attachmentFileType = attachmentFileType.replace("\\", CONFIRM_NO_ACTION)).equalsIgnoreCase("application/pdf")) {
            attachmentFile = this.getProtocolAttachmentFile(form, attachment);
            if (attachmentFile != null) {
                this.streamToResponse(attachmentFile, ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
            } else {
                this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
            }
            return RESPONSE_ALREADY_HANDLED;
        }
        this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private ActionForward printPersonnelAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, ProtocolAttachmentBase attachment, ProtocolForm form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getProtocolAttachmentFile(ProtocolForm form, ProtocolAttachmentProtocol attachment) {
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getProtocolPrintingService().getProtocolPrintArtifacts(form.getProtocolDocument().getProtocol());
        Protocol protocolCurrent = form.getProtocolDocument().getProtocol();
        int currentProtoSeqNumber = protocolCurrent.getSequenceNumber();
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                int currentAttachmentSequence = attachment.getSequenceNumber();
                String docStatusCode = attachment.getDocumentStatusCode();
                String statusCode = attachment.getStatusCode();
                if (this.getProtocolAttachmentService().isAttachmentActive(attachment) && currentProtoSeqNumber == currentAttachmentSequence || docStatusCode.equals("1")) {
                    if ("2".equals(statusCode)) {
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getInvalidWatermark());
                    LOG.info((Object)(INVALID_ATTACHMENT + attachment.getDocumentId()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured in ProtocolNoteAndAttachmentAction. : ", (Throwable)e);
        }
        return attachmentFile;
    }

    public ActionForward filterHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Date startDate = protocolForm.getActionHelper().getFilteredHistoryStartDate();
        Date endDate = protocolForm.getActionHelper().getFilteredHistoryEndDate();
        if (this.applyRules((KualiDocumentEvent)new ProtocolHistoryFilterDatesEvent((Document)protocolForm.getProtocolDocument(), startDate, endDate))) {
            protocolForm.getActionHelper().initFilterDatesView();
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getActionHelper().setFilteredHistoryStartDate(null);
        protocolForm.getActionHelper().setFilteredHistoryEndDate(null);
        protocolForm.getActionHelper().initFilterDatesView();
        return mapping.findForward("basic");
    }

    public ActionForward loadProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        org.kuali.kra.irb.actions.ProtocolAction action = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getSelectedProtocolAction();
        if (action != null) {
            protocolForm.getActionHelper().setCurrentSequenceNumber(action.getSequenceNumber());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolSummary protocolSummary = (ProtocolSummary)protocolForm.getActionHelper().getProtocolSummary();
        if (((String)request.getAttribute("methodToCallAttribute")).contains(".prev.")) {
            protocolSummary = (ProtocolSummary)protocolForm.getActionHelper().getPrevProtocolSummary();
        }
        int selectedIndex = this.getSelectedLine(request);
        AttachmentSummary attachmentSummary = protocolSummary.getAttachments().get(selectedIndex);
        if (attachmentSummary.getAttachmentType().startsWith("Protocol: ")) {
            ProtocolAttachmentProtocol attachment = this.getProtocolAttachmentService().getAttachment(ProtocolAttachmentProtocol.class, attachmentSummary.getAttachmentId());
            return this.printAttachmentProtocol(mapping, response, attachment, protocolForm);
        }
        ProtocolAttachmentPersonnel personnelAttachment = this.getProtocolAttachmentService().getAttachment(ProtocolAttachmentPersonnel.class, attachmentSummary.getAttachmentId());
        return this.printPersonnelAttachmentProtocol(mapping, response, personnelAttachment, protocolForm);
    }

    public ActionForward viewPreviousProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() - 1);
        ((ProtocolForm)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewNextProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() + 1);
        ((ProtocolForm)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewPreviousSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getPrevSubmissionNumber());
        actionHelper.setAmendmentDetails();
        actionHelper.initAmendmentBeans(true);
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewNextSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getNextSubmissionNumber());
        actionHelper.setAmendmentDetails();
        actionHelper.initAmendmentBeans(true);
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("basic");
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_ID, request.getParameter(SUBMISSION_ID));
        ProtocolSubmission protocolSubmission = (ProtocolSubmission)this.getBusinessObjectService().findByPrimaryKey(ProtocolSubmission.class, fieldValues);
        protocolSubmission.getProtocol().setProtocolSubmission(protocolSubmission);
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.setDocId(protocolSubmission.getProtocol().getProtocolDocument().getDocumentNumber());
        this.loadDocument((KualiDocumentFormBase)protocolForm);
        protocolForm.initialize();
        return mapping.findForward("basic");
    }

    public ActionForward assignToAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getActionHelper().setCurrentTask("protocolAssignToAgenda");
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            ProtocolTask task = new ProtocolTask("protocolAssignToAgenda", protocolForm.getProtocolDocument().getProtocol());
            if (this.isAuthorized(task)) {
                ProtocolAssignToAgendaBean actionBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
                if (this.applyRules((KualiDocumentEvent)new ProtocolAssignToAgendaEvent(protocolForm.getProtocolDocument(), actionBean))) {
                    this.getProtocolAssignToAgendaService().assignToAgenda((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), actionBean);
                    this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
                    this.recordProtocolActionSuccess("Assign to Agenda");
                    org.kuali.kra.irb.actions.ProtocolAction lastAction = protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction();
                    ProtocolActionType lastActionType = (ProtocolActionType)lastAction.getProtocolActionType();
                    String description = lastActionType.getDescription();
                    IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
                    IRBNotificationContext context = new IRBNotificationContext(protocol, "200", description, (NotificationRenderer)renderer);
                    if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                        protocolForm.getNotificationHelper().initializeDefaultValues(context);
                        forward = mapping.findForward("protocolNotificationEditor");
                    } else {
                        this.getNotificationService().sendNotificationAndPersist(context, new IRBProtocolNotification(), protocol);
                    }
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward protocolReviewNotRequired(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolReviewNotRequiredBean actionBean;
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolTask task = new ProtocolTask("protocolReviewNotRequired", protocol);
        if (this.isAuthorized(task) && this.applyRules((KualiDocumentEvent)new ProtocolReviewNotRequiredEvent(document, actionBean = protocolForm.getActionHelper().getProtocolReviewNotRequiredBean()))) {
            KraServiceLocator.getService(ProtocolReviewNotRequiredService.class).reviewNotRequired(document, actionBean);
            this.recordProtocolActionSuccess("Review Not Required");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(document.getProtocol(), "210", "Review Not Required");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward assignCommitteeSchedule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String callerString = "assignCommitteeSchedule";
        ProtocolTask task = new ProtocolTask("protocolAssignToCmtSched", protocolForm.getProtocolDocument().getProtocol());
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                ProtocolAssignCmtSchedBean actionBean = protocolForm.getActionHelper().getAssignCmtSchedBean();
                if (this.applyRules((KualiDocumentEvent)new ProtocolAssignCmtSchedEvent(protocolForm.getProtocolDocument(), actionBean)) && protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission() != null) {
                    boolean performAssignment = false;
                    String question = request.getParameter("questionIndex");
                    String buttonClicked = request.getParameter("buttonClicked");
                    if (this.isCommitteeMeetingAssignedMaxProtocols(actionBean.getNewCommitteeId(), actionBean.getNewScheduleId())) {
                        if (question == null || !CONFIRM_ASSIGN_CMT_SCHED_KEY.equals(question)) {
                            return this.performQuestionWithoutInput(mapping, form, request, response, CONFIRM_ASSIGN_CMT_SCHED_KEY, this.getKualiConfigurationService().getPropertyValueAsString("question.protocol.confirmExceedMaxProtocols"), "confirmationQuestion", "assignCommitteeSchedule", CONFIRM_NO_ACTION);
                        }
                        if ("0".equals(buttonClicked)) {
                            performAssignment = true;
                        }
                    } else {
                        performAssignment = true;
                    }
                    if (performAssignment) {
                        this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedule(protocolForm.getProtocolDocument().getProtocol(), actionBean);
                        this.recordProtocolActionSuccess("Assign to Committee and Schedule");
                    }
                    ((ProtocolForm)form).getActionHelper().prepareView();
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildAssignToAgendaConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_ASSIGN_TO_AGENDA_KEY, "question.protocol.confirmExceedMaxProtocols", new String[0]);
    }

    public ActionForward confirmAssignToAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_ASSIGN_TO_AGENDA_KEY.equals(question)) {
            ProtocolForm protocolForm = (ProtocolForm)form;
            ProtocolAssignToAgendaBean actionBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
            this.getProtocolAssignToAgendaService().assignToAgenda((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), actionBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward assignReviewers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("protocolAssignReviewers", protocolForm.getProtocolDocument().getProtocol());
        String callerString = String.format("assignReviewers", new Object[0]);
        String question = request.getParameter("questionIndex");
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task)) {
                ProtocolAssignReviewersBean actionBean = protocolForm.getActionHelper().getProtocolAssignReviewersBean();
                if (this.applyRules((KualiDocumentEvent)new ProtocolAssignReviewersEvent(protocolForm.getProtocolDocument(), actionBean))) {
                    boolean processRequest = true;
                    if (GlobalVariables.getMessageMap().hasWarnings()) {
                        if (question == null) {
                            forward = this.performQuestionWithoutInput(mapping, form, request, response, CONIFRM_REMOVE_REVIEWER_KEY, this.getKualiConfigurationService().getPropertyValueAsString("message.protocol.reviewer.removeReview.removeReviewWithComments"), "confirmationQuestion", callerString, CONFIRM_NO_ACTION);
                            processRequest = false;
                        } else {
                            String buttonClicked = request.getParameter("buttonClicked");
                            if ("DocDisapprove".equals(question) && "1".equals(buttonClicked)) {
                                processRequest = false;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"User declined to confirm the request, not processing.");
                                }
                            }
                        }
                    }
                    if (processRequest) {
                        ProtocolSubmission submission = protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission();
                        List<ProtocolReviewerBeanBase> beans = actionBean.getReviewers();
                        this.getProtocolAssignReviewersService().assignReviewers(submission, beans);
                        GlobalVariables.getMessageMap().getWarningMessages().clear();
                        this.recordProtocolActionSuccess("Assign Reviewers");
                        AssignReviewerNotificationRenderer renderer = new AssignReviewerNotificationRenderer(protocolForm.getProtocolDocument().getProtocol(), "added");
                        List<ProtocolNotificationRequestBean> addReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "create");
                        List<ProtocolNotificationRequestBean> removeReviewerNotificationBeans = this.getNotificationRequestBeans(beans, "remove");
                        if (!CollectionUtils.isEmpty(addReviewerNotificationBeans)) {
                            ProtocolNotificationRequestBean notificationBean = addReviewerNotificationBeans.get(0);
                            IRBNotificationContext context = new IRBNotificationContext(notificationBean.getProtocol(), notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), (NotificationRenderer)renderer);
                            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                                forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, renderer, addReviewerNotificationBeans);
                                if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
                                    GlobalVariables.getUserSession().addObject("removeReviewer", removeReviewerNotificationBeans);
                                }
                            }
                        } else if (!CollectionUtils.isEmpty(removeReviewerNotificationBeans)) {
                            renderer = new AssignReviewerNotificationRenderer(protocolForm.getProtocolDocument().getProtocol(), "removed");
                            ProtocolNotificationRequestBean notificationBean = removeReviewerNotificationBeans.get(0);
                            IRBNotificationContext context = new IRBNotificationContext(notificationBean.getProtocol(), notificationBean.getProtocolOnlineReview(), notificationBean.getActionType(), notificationBean.getDescription(), (NotificationRenderer)renderer);
                            if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
                                forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, renderer, removeReviewerNotificationBeans);
                            }
                        }
                    }
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    private List<ProtocolNotificationRequestBean> getNotificationRequestBeans(List<ProtocolReviewerBean> beans, String actionFlag) {
        ArrayList<ProtocolNotificationRequestBean> notificationRequestBeans = new ArrayList<ProtocolNotificationRequestBean>();
        for (ProtocolReviewerBean bean : beans) {
            if (!StringUtils.equals((String)actionFlag, (String)bean.getActionFlag())) continue;
            notificationRequestBeans.add((ProtocolNotificationRequestBean)bean.getNotificationRequestBean());
        }
        return notificationRequestBeans;
    }

    public ActionForward grantExemption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGrantExemptionBean actionBean = protocolForm.getActionHelper().getProtocolGrantExemptionBean();
        ActionForward forward = mapping.findForward("basic");
        if (this.hasPermission("protocolGrantExemption", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGrantExemptionEvent(document, actionBean))) {
            this.getProtocolGrantExemptionService().grantExemption(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Grant Exemption");
            forward = this.confirmFollowupAction(mapping, form, request, response, "basic");
        }
        if (request.getParameter("questionIndex") != null) {
            forward = this.confirmFollowupAction(mapping, form, request, response, "basic");
        }
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "206", "Exemption Granted");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            return mapping.findForward(CORRESPONDENCE);
        }
        return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
    }

    public ActionForward grantFullApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolApproveBean actionBean = (ProtocolApproveBean)protocolForm.getActionHelper().getProtocolFullApprovalBean();
        if (this.hasPermission("protocolApprove", document.getProtocol()) && this.applyRules((KualiDocumentEvent)new ProtocolApproveEvent(document, actionBean))) {
            forward = super.approve(mapping, (ActionForm)protocolForm, request, response);
            this.getProtocolApproveService().grantFullApproval(document.getProtocol(), actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Full Approval");
            protocolForm.getProtocolHelper().prepareView();
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "204", "Approved");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                GlobalVariables.getUserSession().addObject("approvalComplCorrespondence", GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY"));
                GlobalVariables.getUserSession().removeObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
                return mapping.findForward(CORRESPONDENCE);
            }
            IRBNotificationRenderer renderer = new IRBNotificationRenderer(document.getProtocol());
            IRBNotificationContext context = new IRBNotificationContext(document.getProtocol(), "204", "Approved", (NotificationRenderer)renderer);
            this.getNotificationService().sendNotificationAndPersist(context, new IRBProtocolNotification(), document.getProtocol());
            forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return forward;
    }

    public ActionForward grantExpeditedApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getActionHelper().setCurrentTask("protocolExpediteApproval");
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolExpeditedApproveBean expeditedActionBean = (ProtocolExpeditedApproveBean)protocolForm.getActionHelper().getProtocolExpeditedApprovalBean();
        if (this.hasPermission("protocolExpediteApproval", document.getProtocol())) {
            if (this.applyRules((KualiDocumentEvent)new ProtocolExpeditedApproveEvent(document, expeditedActionBean))) {
                if (expeditedActionBean.isAssignToAgenda()) {
                    ProtocolAssignCmtSchedBean cmtAssignBean = protocolForm.getActionHelper().getAssignCmtSchedBean();
                    cmtAssignBean.setScheduleId(expeditedActionBean.getScheduleId());
                    boolean alreadyAssignedToAgenda = this.getProtocolAssignToAgendaService().isAssignedToAgenda(document.getProtocol());
                    if (alreadyAssignedToAgenda) {
                        if (cmtAssignBean.scheduleHasChanged()) {
                            this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedulePostAgendaAssignment(protocolForm.getProtocolDocument().getProtocol(), cmtAssignBean);
                        }
                    } else {
                        this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedule(protocolForm.getProtocolDocument().getProtocol(), cmtAssignBean);
                        ProtocolAssignToAgendaBean agendaBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
                        agendaBean.setScheduleDate(this.getProtocolAssignToAgendaService().getAssignedScheduleDate(protocolForm.getProtocolDocument().getProtocol()));
                        agendaBean.setActionDate(expeditedActionBean.getActionDate());
                    }
                    if (!alreadyAssignedToAgenda || cmtAssignBean.scheduleHasChanged()) {
                        this.getProtocolAssignToAgendaService().assignToAgenda(protocolForm.getProtocolDocument().getProtocol(), expeditedActionBean);
                        this.recordProtocolActionSuccess("Assign to Agenda");
                    }
                }
                this.getProtocolApproveService().grantExpeditedApproval(protocolForm.getProtocolDocument().getProtocol(), expeditedActionBean);
                this.saveReviewComments(protocolForm, expeditedActionBean.getReviewCommentsBean());
                this.recordProtocolActionSuccess("Expedited Approval");
                forward = this.confirmFollowupAction(mapping, form, request, response, PROTOCOL_ACTIONS_TAB);
                protocolForm.getTabStates().put(":" + WebUtils.generateTabKey((String)"Assign to Agenda"), "OPEN");
            } else {
                return forward;
            }
        }
        if (request.getParameter("questionIndex") != null) {
            this.confirmFollowupAction(mapping, form, request, response, PROTOCOL_ACTIONS_TAB);
            protocolForm.getProtocolHelper().prepareView();
        }
        ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "205", "Expedited Approval Granted");
        protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            return mapping.findForward(CORRESPONDENCE);
        }
        forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
        return forward;
    }

    public ActionForward grantResponseApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolApproveBean actionBean = protocolForm.getActionHelper().getProtocolResponseApprovalBean();
        if (this.hasPermission("protocolResponseApproval", document.getProtocol()) && this.applyRules((KualiDocumentEvent)new ProtocolApproveEvent(document, actionBean))) {
            this.getProtocolApproveService().grantResponseApproval(document.getProtocol(), actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
            this.recordProtocolActionSuccess("Response Approval");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(document.getProtocol(), "208", "Response Approval");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return forward;
    }

    public ActionForward requestAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        String taskName = this.getTaskName(request);
        protocolForm.getActionHelper().preSaveSubmissionQuestionnaires();
        if (StringUtils.isNotBlank((String)taskName) && this.isAuthorized(new ProtocolTask(taskName, protocol))) {
            ProtocolRequestAction requestAction = ProtocolRequestAction.valueOfTaskName(taskName);
            ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            if (requestBean != null) {
                boolean valid = this.applyRules((KualiDocumentEvent)new ProtocolRequestEvent(document, requestAction.getErrorPath(), requestBean));
                if (valid &= this.isMandatoryQuestionnaireComplete(requestBean, "actionHelper." + requestAction.getBeanName() + ".datavalidation")) {
                    this.getProtocolRequestService().submitRequest(protocolForm.getProtocolDocument().getProtocol(), requestBean);
                    this.recordProtocolActionSuccess(requestAction.getActionName());
                    return this.sendRequestNotification(mapping, form, protocol, requestBean);
                }
            }
        }
        return mapping.findForward("basic");
    }

    private ActionForward sendRequestNotification(ActionMapping mapping, ActionForm form, Protocol protocol, ProtocolRequestBean requestBean) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolActionType protocolActionType = (ProtocolActionType)this.getBusinessObjectService().findBySinglePrimaryKey(ProtocolActionType.class, (Object)requestBean.getProtocolActionTypeCode());
        String protocolActionTypeCode = protocolActionType.getProtocolActionTypeCode();
        String description = protocolActionType.getDescription();
        return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), protocolActionTypeCode, description));
    }

    private ProtocolRequestBean getProtocolRequestBean(ActionForm form, HttpServletRequest request) {
        ProtocolRequestBean protocolRequestBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolRequestBean) {
            protocolRequestBean = (ProtocolRequestBean)protocolActionBean;
        }
        return protocolRequestBean;
    }

    public ActionForward closeProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolCloseBean();
        if (this.hasGenericPermission("protocolClose", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().close(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Close");
            ProtocolNotificationRequestBean notificationBean = null;
            notificationBean = "300".equals((Object)protocol.getProtocolStatus()) ? new ProtocolNotificationRequestBean(protocol, "300", "Closed By Administrator") : new ProtocolNotificationRequestBean(protocol, "300", "Closed By Investigator");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward closeEnrollment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolCloseEnrollmentBean();
        if (this.hasGenericPermission("protocolCloseEnrollment", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().closeEnrollment(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Close Enrollment");
        }
        return mapping.findForward("basic");
    }

    public ActionForward defer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolDeferBean();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolDefer", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
                ProtocolDocument newDocument = this.getProtocolGenericActionService().defer(protocol, actionBean);
                this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
                protocolForm.setDocId(newDocument.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                this.recordProtocolActionSuccess("Defer");
                protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "201", "Deferred"), false));
                if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "201", "Deferred"));
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward disapproveProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolDisapproveBean();
        if (this.hasPermission("protocolDisapprove", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().disapprove(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Disapprove");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "304", "Disapproved");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward expire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolExpireBean();
        if (this.hasGenericPermission("protocolExpire", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().expire(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Expire");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "305", "Expired");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward irbAcknowledgement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolIrbAcknowledgementBean();
        if (this.hasPermission("irbAcknowledgement", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().irbAcknowledgement(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("IRB Acknowledgement");
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_ACTIONS_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "209", "IRB Acknowledgement"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward permitDataAnalysis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolPermitDataAnalysisBean();
        if (this.hasGenericPermission("protocolPermitDataAnalysis", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().permitDataAnalysis(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Permit Data Analysis Only");
        }
        return mapping.findForward("basic");
    }

    public ActionForward reopenEnrollment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolReopenEnrollmentBean();
        if (this.hasGenericPermission("protocolReopen", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().reopenEnrollment(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Re-open Enrollment");
        }
        return mapping.findForward("basic");
    }

    public ActionForward returnForSMR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSMRBean();
        if (this.hasPermission("protocolReturnForSMR", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            ProtocolDocument newDocument = (ProtocolDocument)this.getProtocolGenericActionService().returnForSMR(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            protocolForm.setDocId(newDocument.getDocumentNumber());
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Return for Specific Minor Revisions");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "203", "Specific Minor Revisions Required"), false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "203", "Specific Minor Revisions Required"));
        }
        return forward;
    }

    public ActionForward returnForSRR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSRRBean();
        if (this.hasPermission("protocolReturnForSRR", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            ProtocolDocument newDocument = (ProtocolDocument)this.getProtocolGenericActionService().returnForSRR(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            protocolForm.setDocId(newDocument.getDocumentNumber());
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Return for Substantive Revisions Required");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "202", "Substantive Revisions Required"), false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "202", "Substantive Revisions Required"));
        }
        return forward;
    }

    public ActionForward returnToPI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolReturnToPIBean();
        if (this.hasPermission("protocolReturnToPI", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            ProtocolDocument newDocument = (ProtocolDocument)this.getProtocolGenericActionService().returnToPI(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            protocolForm.setDocId(newDocument.getDocumentNumber());
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Return To PI");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "213", "Return To PI"), false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "213", "Returned To PI"));
        }
        return forward;
    }

    public ActionForward suspend(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolSuspendBean();
        if (this.hasGenericPermission("protocolSuspend", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().suspend(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Suspend");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "302", "Suspended");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward suspendByDsmb(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = protocolForm.getActionHelper().getProtocolSuspendByDsmbBean();
        if (this.hasGenericPermission("protocolSuspendByDsmb", protocol) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().suspendByDsmb(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Suspend by DSMB");
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "306", "Suspended by DSMB");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward terminate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        Protocol protocol = document.getProtocol();
        ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolTerminateBean();
        if (this.hasGenericPermission("protocolTerminate", protocolForm.getProtocolDocument().getProtocol()) && this.applyRules((KualiDocumentEvent)new ProtocolGenericActionEvent(document, actionBean))) {
            this.getProtocolGenericActionService().terminate(protocol, actionBean);
            this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
            this.recordProtocolActionSuccess("Terminate");
            protocolForm.getProtocolHelper().prepareView();
            ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "301", "Terminated");
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward manageComments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", protocolForm.getProtocolDocument().getProtocol())) {
                ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
                this.recordProtocolActionSuccess("Manage Review Comments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward openProtocolForAdminCorrection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        ActionForward forward = mapping.findForward("basic");
        ProtocolTask task = new ProtocolTask("protocolAdminCorrection", protocolDocument.getProtocol());
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.isAuthorized(task) && this.applyRules((KualiDocumentEvent)new ProtocolAdminCorrectionEvent(protocolDocument, (AdminCorrectionBean)protocolForm.getActionHelper().getProtocolAdminCorrectionBean()))) {
                protocolDocument.getProtocol().setCorrectionMode(true);
                protocolForm.getProtocolHelper().prepareView();
                AdminCorrectionBean adminCorrectionBean = (AdminCorrectionBean)protocolForm.getActionHelper().getProtocolAdminCorrectionBean();
                protocolDocument.updateProtocolStatus("113", adminCorrectionBean.getComments());
                this.recordProtocolActionSuccess("Make Administrative Correction");
                ProtocolNotificationRequestBean notificationBean = new ProtocolNotificationRequestBean(protocolDocument.getProtocol(), "113", "Administrative Correction");
                protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_TAB, notificationBean, false));
                if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                    return mapping.findForward(CORRESPONDENCE);
                }
                return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, notificationBean);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return forward;
    }

    public ActionForward undoLastAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
            UndoLastActionBean undoLastActionBean = protocolForm.getActionHelper().getUndoLastActionBean();
            String lastActionType = undoLastActionBean.getLastPerformedAction().getProtocolActionTypeCode();
            UndoLastActionService undoLastActionService = KraServiceLocator.getService(UndoLastActionService.class);
            ProtocolDocument updatedDocument = (ProtocolDocument)undoLastActionService.undoLastAction(protocolDocument, undoLastActionBean);
            this.recordProtocolActionSuccess("Undo Last Action");
            if (!updatedDocument.getDocumentNumber().equals(protocolForm.getDocId())) {
                protocolForm.setDocId(updatedDocument.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                return mapping.findForward(PROTOCOL_TAB);
            }
            if ("203".equals(lastActionType) || "202".equals(lastActionType)) {
                return this.routeProtocolToHoldingPage(mapping, protocolForm);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward submitCommitteeDecision(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.applyRules((KualiDocumentEvent)new CommitteeDecisionEvent(protocolForm.getProtocolDocument(), (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision()))) {
                CommitteeDecision actionBean = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
                this.getCommitteeDecisionService().processCommitteeDecision(protocolForm.getProtocolDocument().getProtocol(), actionBean);
                this.saveReviewComments(protocolForm, actionBean.getReviewCommentsBean());
                this.confirmFollowupAction(mapping, form, request, response, "basic");
                protocolForm.getTabStates().put(":" + WebUtils.generateTabKey((String)motionTypeMap.get(actionBean.getMotionTypeCode())), "OPEN");
                this.recordProtocolActionSuccess("Record Committee Decision");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((KualiDocumentEvent)new CommitteeDecisionAbstainerEvent(protocolForm.getProtocolDocument(), decision))) {
            decision.getAbstainers().add(decision.getNewAbstainer());
            decision.setNewAbstainer(new CommitteePerson());
            decision.setAbstainCount(decision.getAbstainCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        CommitteePerson person = decision.getAbstainers().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getAbstainersToDelete().add(person);
            decision.getAbstainers().remove(this.getLineToDelete(request));
            decision.setAbstainCount(decision.getAbstainCount() - 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((KualiDocumentEvent)new CommitteeDecisionRecuserEvent(protocolForm.getProtocolDocument(), decision))) {
            decision.getRecused().add(decision.getNewRecused());
            decision.setNewRecused(new CommitteePerson());
            decision.setRecusedCount(decision.getRecusedCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward modifySubmsionAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            ProtocolModifySubmissionBean bean = protocolForm.getActionHelper().getProtocolModifySubmissionBean();
            if (this.applyRules((KualiDocumentEvent)new ProtocolModifySubmissionEvent(protocolForm.getProtocolDocument(), bean))) {
                KraServiceLocator.getService(ProtocolModifySubmissionService.class).modifySubmisison(protocolForm.getProtocolDocument(), bean);
                this.recordProtocolActionSuccess("Modify Submission Request");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        CommitteePerson person = decision.getRecused().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getRecusedToDelete().add(person);
            decision.getRecused().remove(this.getLineToDelete(request));
            decision.setRecusedCount(decision.getRecusedCount() - 1);
        }
        return mapping.findForward("basic");
    }

    private Printable getPrintableArtifacts(Protocol protocol, String reportType, StringBuffer fileName, Map reportParameters) {
        org.kuali.kra.protocol.actions.print.ProtocolPrintType printType = org.kuali.kra.protocol.actions.print.ProtocolPrintType.valueOf(PRINTTAG_MAP.get(reportType));
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintingService().getProtocolPrintable(printType);
        printable.setPrintableBusinessObject(protocol);
        printable.setReportParameters(reportParameters);
        fileName.append(reportType).append("-");
        return printable;
    }

    private ProtocolPrintingService getProtocolPrintingService() {
        return KraServiceLocator.getService(ProtocolPrintingService.class);
    }

    public ActionForward addRiskLevel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRiskLevelBean protocolRiskLevelBean = this.getProtocolRiskLevelBean(mapping, form, request, response);
        if (protocolRiskLevelBean != null) {
            String errorPropertyName = protocolRiskLevelBean.getErrorPropertyKey();
            ProtocolRiskLevel newProtocolRiskLevel = protocolRiskLevelBean.getNewProtocolRiskLevel();
            Protocol protocol = document.getProtocol();
            if (this.applyRules((KualiDocumentEvent)new ProtocolAddRiskLevelEvent(document, errorPropertyName, newProtocolRiskLevel))) {
                this.getProtocolRiskLevelService().addRiskLevel(newProtocolRiskLevel, protocol);
                protocolRiskLevelBean.setNewProtocolRiskLevel(new ProtocolRiskLevel());
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateRiskLevel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRiskLevelBean protocolRiskLevelBean = this.getProtocolRiskLevelBean(mapping, form, request, response);
        if (protocolRiskLevelBean != null) {
            int lineNumber = this.getSelectedLine(request);
            ProtocolRiskLevel currentProtocolRiskLevel = document.getProtocol().getProtocolRiskLevels().get(lineNumber);
            ProtocolRiskLevel newProtocolRiskLevel = protocolRiskLevelBean.getNewProtocolRiskLevel();
            if (this.applyRules((KualiDocumentEvent)new ProtocolUpdateRiskLevelEvent(document, lineNumber))) {
                this.getProtocolRiskLevelService().updateRiskLevel(currentProtocolRiskLevel, newProtocolRiskLevel);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRiskLevel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRiskLevelBean protocolRiskLevelBean = this.getProtocolRiskLevelBean(mapping, form, request, response);
        if (protocolRiskLevelBean != null) {
            int lineNumber = this.getSelectedLine(request);
            Protocol protocol = document.getProtocol();
            this.getProtocolRiskLevelService().deleteRiskLevel(lineNumber, protocol);
        }
        return mapping.findForward("basic");
    }

    private ProtocolRiskLevelBean getProtocolRiskLevelBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolRiskLevelBean protocolRiskLevelBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolRiskLevelCommentable) {
            protocolRiskLevelBean = ((ProtocolRiskLevelCommentable)((Object)protocolActionBean)).getProtocolRiskLevelBean();
        }
        return protocolRiskLevelBean;
    }

    public ActionForward addReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            String errorPropertyName = reviewCommentsBean.getErrorPropertyName();
            CommitteeScheduleMinute newReviewComment = (CommitteeScheduleMinute)reviewCommentsBean.getNewReviewComment();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            Protocol protocol = document.getProtocol();
            if (this.applyRules((KualiDocumentEvent)new ProtocolAddReviewCommentEvent(document, errorPropertyName, newReviewComment))) {
                this.getReviewCommentsService().addReviewComment((CommitteeScheduleMinuteBase)newReviewComment, reviewComments, protocol);
                reviewCommentsBean.setNewReviewComment(new CommitteeScheduleMinute("3"));
            }
            reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveUpReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            Protocol protocol = document.getProtocol();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveUpReviewComment(reviewComments, protocol, lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveDownReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            Protocol protocol = document.getProtocol();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveDownReviewComment(reviewComments, protocol, lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getLineToDelete(request);
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().deleteReviewComment(reviewComments, lineNumber, deletedReviewComments);
            if (reviewComments.isEmpty()) {
                reviewCommentsBean.setHideReviewerName(true);
            } else {
                reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward abandon(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("protocolAbandon", protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            this.getProtocolAbandonService().abandonProtocol(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getProtocolAbandonBean());
            protocolForm.getProtocolHelper().prepareView();
            this.recordProtocolActionSuccess("Abandon");
            org.kuali.kra.irb.actions.ProtocolAction lastAction = protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction();
            protocolForm.getProtocolHelper().prepareView();
            protocolForm.getActionHelper().setProtocolCorrespondence(this.getProtocolCorrespondence(protocolForm, PROTOCOL_ACTIONS_TAB, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "119", "Abandon"), false));
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            return this.checkToSendNotification(mapping, mapping.findForward(PROTOCOL_TAB), protocolForm, new ProtocolNotificationRequestBean(protocolForm.getProtocolDocument().getProtocol(), "119", "Abandon"));
        }
        return mapping.findForward("basic");
    }

    private void saveReviewComments(ProtocolForm protocolForm, ReviewCommentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewComments(actionBean.getReviewComments(), actionBean.getDeletedReviewComments());
        actionBean.setDeletedReviewComments(new ArrayList<CommitteeScheduleMinuteBase>());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    private ReviewCommentsBean getReviewCommentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewCommentsBean reviewCommentsBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewCommentsBean = (ReviewCommentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewCommentsBean();
        }
        return reviewCommentsBean;
    }

    private ProtocolActionBean getActionBean(ActionForm form, HttpServletRequest request) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String taskName = this.getTaskName(request);
        ProtocolActionBean protocolActionBean = null;
        if (StringUtils.isNotBlank((String)taskName)) {
            protocolActionBean = (ProtocolActionBean)protocolForm.getActionHelper().getActionBean(taskName);
        }
        return protocolActionBean;
    }

    private String getTaskName(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String taskName = CONFIRM_NO_ACTION;
        if (StringUtils.isNotBlank((String)parameterName)) {
            taskName = StringUtils.substringBetween((String)parameterName, (String)".taskName", (String)".");
        }
        return taskName;
    }

    private boolean hasPermission(String taskName, Protocol protocol) {
        ProtocolTask task = new ProtocolTask(taskName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    private boolean hasGenericPermission(String genericActionName, Protocol protocol) {
        ProtocolTask task = new ProtocolTask("genericProtocolAction", protocol, genericActionName);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    private ProtocolAttachmentService getProtocolAttachmentService() {
        return KraServiceLocator.getService(ProtocolAttachmentService.class);
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    private ProtocolGenericActionService getProtocolGenericActionService() {
        return KraServiceLocator.getService(ProtocolGenericActionService.class);
    }

    private ProtocolAbandonService getProtocolAbandonService() {
        return KraServiceLocator.getService(ProtocolAbandonService.class);
    }

    public ProtocolCopyService getProtocolCopyService() {
        return KraServiceLocator.getService(ProtocolCopyService.class);
    }

    private ProtocolSubmitActionService getProtocolSubmitActionService() {
        return KraServiceLocator.getService(ProtocolSubmitActionService.class);
    }

    private ProtocolWithdrawService getProtocolWithdrawService() {
        return KraServiceLocator.getService(ProtocolWithdrawService.class);
    }

    private ProtocolRequestService getProtocolRequestService() {
        return KraServiceLocator.getService(ProtocolRequestService.class);
    }

    private ProtocolNotifyIrbService getProtocolNotifyIrbService() {
        return KraServiceLocator.getService(ProtocolNotifyIrbService.class);
    }

    private ProtocolNotifyCommitteeService getProtocolNotifyCommitteeService() {
        return KraServiceLocator.getService(ProtocolNotifyCommitteeService.class);
    }

    private ProtocolAmendRenewService getProtocolAmendRenewService() {
        return KraServiceLocator.getService(ProtocolAmendRenewService.class);
    }

    private ProtocolDeleteService getProtocolDeleteService() {
        return KraServiceLocator.getService(ProtocolDeleteService.class);
    }

    private ProtocolAssignCmtSchedService getProtocolAssignCmtSchedService() {
        return KraServiceLocator.getService(ProtocolAssignCmtSchedService.class);
    }

    private ProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        return KraServiceLocator.getService(ProtocolAssignToAgendaService.class);
    }

    private ProtocolAssignReviewersService getProtocolAssignReviewersService() {
        return KraServiceLocator.getService(ProtocolAssignReviewersService.class);
    }

    private ProtocolGrantExemptionService getProtocolGrantExemptionService() {
        return KraServiceLocator.getService(ProtocolGrantExemptionService.class);
    }

    private ProtocolApproveService getProtocolApproveService() {
        return KraServiceLocator.getService(ProtocolApproveService.class);
    }

    private CommitteeService getCommitteeService() {
        return KraServiceLocator.getService(CommitteeService.class);
    }

    private CommitteeDecisionService getCommitteeDecisionService() {
        return (CommitteeDecisionService)KraServiceLocator.getService("protocolCommitteeDecisionService");
    }

    private ProtocolRiskLevelService getProtocolRiskLevelService() {
        return KraServiceLocator.getService(ProtocolRiskLevelService.class);
    }

    private ReviewCommentsService getReviewCommentsService() {
        return KraServiceLocator.getService(ReviewCommentsService.class);
    }

    public ActionForward addNotifyIrbAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (((ProtocolForm)form).getActionHelper().validFile(((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().getNewActionAttachment(), "protocolNotifyIrbBean")) {
            LOG.info((Object)("addNotifyIrbAttachment " + ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().getNewActionAttachment().getFile().getFileName() + ((ProtocolForm)form).getProtocolDocument().getDocumentNumber()));
            ((ProtocolForm)form).getActionHelper().addNotifyIrbAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewNotifyIrbAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (ProtocolForm)form, request, response);
    }

    private ActionForward viewAttachment(ActionMapping mapping, ProtocolForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolActionAttachment attachment = form.getActionHelper().getProtocolNotifyIrbBean().getActionAttachments().get(selection);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getFile().getFileData(), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getFileName()), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteNotifyIrbAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirmDeleteAttachment(mapping, (ProtocolForm)form, request, response, ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().getActionAttachments());
    }

    private ActionForward confirmDeleteAttachment(ActionMapping mapping, ProtocolForm form, HttpServletRequest request, HttpServletResponse response, List<ProtocolActionAttachment> attachments) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolActionAttachment attachment = attachments.get(selection);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + selection));
            return mapping.findForward("basic");
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, CONFIRM_DELETE_ACTION_ATT, "document.question.deleteAttachment.text", CONFIRM_NO_ACTION, attachment.getFile().getFileName());
        return this.confirm(confirm, CONFIRM_DELETE_ACTION_ATT, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmDeleteActionAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String taskName = this.getTaskName(request);
        int selection = this.getSelectedLine(request);
        if (StringUtils.isBlank((String)taskName)) {
            ProtocolNotifyIrbBean notifyIrbBean = ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean();
            notifyIrbBean.getActionAttachments().remove(selection);
        } else {
            ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            requestBean.getActionAttachments().remove(selection);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolSubmissionDoc attachment = (ProtocolSubmissionDoc)protocolAction.getProtocolSubmissionDocs().get(attachmentIndex);
        if (attachment == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolSubmissionDoc: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getDocument(), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFileName()), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewActionCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence attachment = (ProtocolCorrespondence)protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (attachment == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getCorrespondence(), StringUtils.replace((String)attachment.getProtocolCorrespondenceType().getDescription(), (String)" ", (String)CONFIRM_NO_ACTION) + ".pdf", "application/pdf", response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private int getSelectedAttachment(HttpServletRequest request) {
        int selectedAttachment = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String attachmentNumber = StringUtils.substringBetween((String)parameterName, (String)".attachment", (String)".");
            selectedAttachment = Integer.parseInt(attachmentNumber);
        }
        return selectedAttachment;
    }

    public ActionForward addRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
        if (protocolForm.getActionHelper().validFile(requestBean.getNewActionAttachment(), requestBean.getBeanName())) {
            LOG.info((Object)("addRequestAttachment " + requestBean.getProtocolActionTypeCode() + " " + requestBean.getNewActionAttachment().getFile().getFileName() + protocolForm.getProtocolDocument().getDocumentNumber()));
            requestBean.getActionAttachments().add(requestBean.getNewActionAttachment());
            requestBean.setNewActionAttachment(new ProtocolActionAttachment());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
        int selection = this.getSelectedLine(request);
        if (requestBean != null) {
            ProtocolActionAttachment attachment = requestBean.getActionAttachments().get(selection);
            if (attachment == null) {
                LOG.info((Object)(NOT_FOUND_SELECTION + selection));
                return mapping.findForward("basic");
            }
            this.streamToResponse(attachment.getFile().getFileData(), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getFileName()), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getContentType()), response);
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
        if (requestBean != null) {
            forward = this.confirmDeleteAttachment(mapping, (ProtocolForm)form, request, response, requestBean.getActionAttachments());
        }
        return forward;
    }

    private void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getActionHelper().getCanManageNotes()) {
            protocolForm.getNotesAttachmentsHelper().addNewNote();
            protocolForm.getNotesAttachmentsHelper().setManageNotesOpen(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward editNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getActionHelper().getCanManageNotes()) {
            int selection = this.getSelectedLine(request);
            protocolForm.getNotesAttachmentsHelper().modifyNote(selection);
            protocolForm.getNotesAttachmentsHelper().setManageNotesOpen(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getActionHelper().getCanManageNotes() && protocolForm.getActionHelper().getCanManageNotes()) {
            int noteToDelete = this.getLineToDelete(request);
            protocolForm.getNotesAttachmentsHelper().deleteNote(noteToDelete);
            protocolForm.getNotesAttachmentsHelper().setManageNotesOpen(false);
        }
        return mapping.findForward("basic");
    }

    public ActionForward saveNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (protocolForm.getActionHelper().getCanManageNotes()) {
                AddProtocolNotepadRuleImpl rule = new AddProtocolNotepadRuleImpl();
                boolean validNotes = true;
                for (ProtocolNotepadBase note : protocol.getNotepads()) {
                    AddProtocolNotepadEvent event;
                    if (!note.isEditable() || rule.processAddProtocolNotepadRules(event = new AddProtocolNotepadEvent((ProtocolDocument)protocol.getProtocolDocument(), (ProtocolNotepad)note))) continue;
                    validNotes = false;
                }
                if (validNotes) {
                    for (ProtocolNotepadBase note : protocol.getNotepads()) {
                        if (StringUtils.isBlank((String)note.getUpdateUserFullName())) {
                            note.setUpdateUserFullName(GlobalVariables.getUserSession().getPerson().getName());
                            note.setUpdateTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
                        }
                        if (StringUtils.isNotBlank((String)note.getCreateUser())) {
                            Person creator = this.getPersonService().getPersonByPrincipalName(note.getCreateUser());
                            note.setCreateUserFullName(creator == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, note.getCreateUser()) : creator.getName());
                        } else {
                            note.setCreateUserFullName(CONFIRM_NO_ACTION);
                        }
                        note.setEditable(false);
                    }
                    this.getBusinessObjectService().save(protocol.getNotepads());
                    this.recordProtocolActionSuccess("Manage Notes");
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private ActionForward confirmFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String forward) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(((ProtocolForm)form).getProtocolDocument().getProtocol());
        if (validFollowupActions.isEmpty()) {
            LOG.info((Object)"No followup action");
            return mapping.findForward(forward);
        }
        if (!((ValidProtocolActionAction)((Object)validFollowupActions.get(0))).getUserPromptFlag()) {
            this.addFollowupAction(((ProtocolForm)form).getProtocolDocument().getProtocol());
            return mapping.findForward(forward);
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_FOLLOWUP_ACTION, "question.protocol.confirmFollowupAction", ((ValidProtocolActionAction)((Object)validFollowupActions.get(0))).getUserPrompt());
        LOG.info((Object)("followup action " + ((ValidProtocolActionAction)((Object)validFollowupActions.get(0))).getUserPrompt()));
        return this.confirm(confirm, CONFIRM_FOLLOWUP_ACTION, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmAddFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addFollowupAction(((ProtocolForm)form).getProtocolDocument().getProtocol());
        return mapping.findForward("basic");
    }

    private void addFollowupAction(Protocol protocol) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(protocol);
        protocol.getLastProtocolAction().setFollowupActionCode(((ValidProtocolActionAction)((Object)validFollowupActions.get(0))).getFollowupActionCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol.getLastProtocolAction());
    }

    private void setQnCompleteStatus(List<AnswerHeader> answerHeaders) {
        for (AnswerHeader answerHeader : answerHeaders) {
            answerHeader.setCompleted(this.getQuestionnaireAnswerService().isQuestionnaireAnswerComplete(answerHeader.getAnswers()));
        }
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    private FollowupActionService getFollowupActionService() {
        return KraServiceLocator.getService(FollowupActionService.class);
    }

    private WatermarkService getWatermarkService() {
        return KraServiceLocator.getService(WatermarkService.class);
    }

    public ActionForward viewReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            return this.streamReviewAttachment(mapping, request, response, reviewAttachmentsBean.getReviewAttachments());
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewSubmissionReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.streamReviewAttachment(mapping, request, response, ((ProtocolForm)form).getActionHelper().getReviewAttachments());
    }

    private ActionForward streamReviewAttachment(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, List<ProtocolReviewAttachment> reviewAttachments) throws Exception {
        int lineNumber = this.getLineToDelete(request);
        ProtocolReviewAttachment attachment = reviewAttachments.get(lineNumber);
        if (attachment == null) {
            LOG.info((Object)(NOT_FOUND_SELECTION + lineNumber));
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            int lineNumber = this.getLineToDelete(request);
            List deletedReviewAttachments = reviewAttachmentsBean.getDeletedReviewAttachments();
            this.getReviewCommentsService().deleteReviewAttachment(reviewAttachments, lineNumber, deletedReviewAttachments);
            if (reviewAttachments.isEmpty()) {
                reviewAttachmentsBean.setHideReviewerName(true);
            } else {
                reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
            }
        }
        return mapping.findForward("basic");
    }

    private ReviewAttachmentsBean getReviewAttachmentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewAttachmentsBean reviewAttachmentsBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewAttachmentsBean = (ReviewAttachmentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewAttachmentsBean();
        }
        return reviewAttachmentsBean;
    }

    public ActionForward manageAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", protocolForm.getProtocolDocument().getProtocol()) && this.applyRules((KualiDocumentEvent)new ProtocolManageReviewAttachmentEvent(protocolForm.getProtocolDocument(), "actionHelper.protocolManageReviewCommentsBean.reviewAttachmentsBean.", protocolForm.getActionHelper().getProtocolManageReviewCommentsBean().getReviewAttachmentsBean().getReviewAttachments()))) {
                ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewAttachments(protocolForm, actionBean.getReviewAttachmentsBean());
                this.recordProtocolActionSuccess("Manage Review Attachments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private void saveReviewAttachments(ProtocolForm protocolForm, ReviewAttachmentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewAttachments(actionBean.getReviewAttachments(), actionBean.getDeletedReviewAttachments());
        actionBean.setDeletedReviewAttachments(new ArrayList());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    public ActionForward addReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            String errorPropertyName = reviewAttachmentsBean.getErrorPropertyName();
            ProtocolReviewAttachment newReviewAttachment = (ProtocolReviewAttachment)((Object)reviewAttachmentsBean.getNewReviewAttachment());
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            Protocol protocol = document.getProtocol();
            if (this.applyRules((KualiDocumentEvent)new ProtocolAddReviewAttachmentEvent(document, errorPropertyName, newReviewAttachment))) {
                this.getReviewCommentsService().addReviewAttachment(newReviewAttachment, reviewAttachments, protocol);
                reviewAttachmentsBean.setNewReviewAttachment(new ProtocolReviewAttachment());
            }
            reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
        }
        return mapping.findForward("basic");
    }

    private boolean hasDocumentStateChanged(ProtocolForm protocolForm) {
        boolean result = false;
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("protocolId", protocolForm.getProtocolDocument().getProtocol().getProtocolId());
        Protocol dbProtocol = (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, primaryKeys);
        if (dbProtocol != null) {
            if (!StringUtils.equals((String)dbProtocol.getProtocolStatusCode(), (String)protocolForm.getProtocolDocument().getProtocol().getProtocolStatusCode())) {
                result = true;
            }
            if (dbProtocol.getProtocolSubmission() != null && protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission().getSubmissionStatusCode() != null && !StringUtils.equals((String)dbProtocol.getProtocolSubmission().getSubmissionStatusCode(), (String)protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission().getSubmissionStatusCode())) {
                result = true;
            }
        }
        if (!result) {
            result = !this.isDocumentPostprocessingComplete(protocolForm.getProtocolDocument());
        }
        return result;
    }

    private boolean isDocumentPostprocessingComplete(ProtocolDocument document) {
        return document.getDocumentHeader().hasWorkflowDocument() && !this.isPessimisticallyLocked((Document)document);
    }

    private boolean isPessimisticallyLocked(Document document) {
        boolean isPessimisticallyLocked = false;
        Person pessimisticLockHolder = this.getPersonService().getPersonByPrincipalName("kr");
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (!pessimisticLock.isOwnedByUser(pessimisticLockHolder)) continue;
            isPessimisticallyLocked = true;
            break;
        }
        return isPessimisticallyLocked;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, ProtocolForm protocolForm, ProtocolNotificationRequestBean notificationRequestBean) {
        IRBNotificationRenderer renderer = null;
        renderer = StringUtils.equals((String)"116", (String)notificationRequestBean.getActionType()) ? new NotifyIrbNotificationRenderer(notificationRequestBean.getProtocol(), protocolForm.getActionHelper().getProtocolNotifyIrbBean().getComment()) : (StringUtils.equals((String)"109", (String)notificationRequestBean.getActionType()) ? new NotifyCommitteeNotificationRenderer(notificationRequestBean.getProtocol(), protocolForm.getActionHelper().getProtocolNotifyCommitteeBean().getCommitteeName(), protocolForm.getActionHelper().getProtocolNotifyCommitteeBean().getComment(), protocolForm.getActionHelper().getProtocolNotifyCommitteeBean().getActionDate()) : (StringUtils.equals((String)"301", (String)notificationRequestBean.getActionType()) ? new ProtocolTerminatedNotificationRenderer(notificationRequestBean.getProtocol(), protocolForm.getActionHelper().getProtocolTerminateRequestBean().getReason()) : (StringUtils.equals((String)"305", (String)notificationRequestBean.getActionType()) ? new ProtocolExpiredNotificationRenderer(notificationRequestBean.getProtocol()) : (StringUtils.equals((String)"304", (String)notificationRequestBean.getActionType()) ? new ProtocolDisapprovedNotificationRenderer(notificationRequestBean.getProtocol()) : (StringUtils.equals((String)"302", (String)notificationRequestBean.getActionType()) ? new ProtocolSuspendedNotificationRenderer(notificationRequestBean.getProtocol()) : (StringUtils.equals((String)"306", (String)notificationRequestBean.getActionType()) ? new ProtocolSuspendedByDSMBNotificationRenderer(notificationRequestBean.getProtocol()) : (StringUtils.equals((String)"300", (String)notificationRequestBean.getActionType()) ? new ProtocolClosedNotificationRenderer(notificationRequestBean.getProtocol(), notificationRequestBean) : new IRBNotificationRenderer(notificationRequestBean.getProtocol()))))))));
        IRBNotificationContext context = new IRBNotificationContext(notificationRequestBean.getProtocol(), notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), (NotificationRenderer)renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            context.setForwardName(forward.getName());
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            return mapping.findForward("protocolNotificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist(context, new IRBProtocolNotification(), protocolForm.getProtocolDocument().getProtocol());
        return forward;
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, ActionForward forward, ProtocolForm protocolForm, IRBNotificationRenderer renderer, List<ProtocolNotificationRequestBean> notificationRequestBeans) {
        IRBNotificationContext context = new IRBNotificationContext(notificationRequestBeans.get(0).getProtocol(), notificationRequestBeans.get(0).getProtocolOnlineReview(), notificationRequestBeans.get(0).getActionType(), notificationRequestBeans.get(0).getDescription(), (NotificationRenderer)renderer);
        context.setPopulateRole(true);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            List<NotificationTypeRecipient> notificationRecipients = protocolForm.getNotificationHelper().getNotificationRecipients();
            ArrayList<NotificationTypeRecipient> allRecipients = new ArrayList<NotificationTypeRecipient>();
            for (NotificationTypeRecipient recipient : notificationRecipients) {
                try {
                    NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                    context.populateRoleQualifiers(copiedRecipient);
                    allRecipients.add(copiedRecipient);
                }
                catch (Exception e) {}
            }
            for (int i = 1; notificationRequestBeans.size() > i; ++i) {
                context = new IRBNotificationContext(notificationRequestBeans.get(i).getProtocol(), notificationRequestBeans.get(i).getProtocolOnlineReview(), notificationRequestBeans.get(i).getActionType(), notificationRequestBeans.get(i).getDescription(), (NotificationRenderer)renderer);
                context.setPopulateRole(true);
                protocolForm.getNotificationHelper().initializeDefaultValues(context);
                List<NotificationTypeRecipient> recipients = protocolForm.getNotificationHelper().getNotificationRecipients();
                for (NotificationTypeRecipient recipient : recipients) {
                    try {
                        NotificationTypeRecipient copiedRecipient = (NotificationTypeRecipient)((Object)ObjectUtils.deepCopy((Serializable)((Object)recipient)));
                        context.populateRoleQualifiers(copiedRecipient);
                        allRecipients.add(copiedRecipient);
                    }
                    catch (Exception e) {}
                }
            }
            protocolForm.getNotificationHelper().setNotificationRecipients(allRecipients);
            if (forward == null) {
                context.setForwardName("holdingPage");
            } else {
                context.setForwardName(forward.getName());
            }
            return mapping.findForward("protocolNotificationEditor");
        }
        return forward;
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        IRBNotificationContext context = new IRBNotificationContext(protocol, "999", "Ad-Hoc Notification", (NotificationRenderer)renderer);
        protocolForm.getNotificationHelper().initializeDefaultValues(context);
        return mapping.findForward("protocolNotificationEditor");
    }

    protected PersonService getPersonService() {
        return KraServiceLocator.getService(PersonService.class);
    }

    @Override
    protected KcNotificationService getNotificationService() {
        return KraServiceLocator.getService(KcNotificationService.class);
    }

    public ActionForward viewCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionHelper actionHelper = ((ProtocolForm)form).getActionHelper();
        PrintableAttachment source = new PrintableAttachment();
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)actionHelper.getProtocolCorrespondence();
        source.setContent(correspondence.getCorrespondence());
        source.setContentType("application/pdf");
        source.setFileName("Correspondence-" + correspondence.getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    public ActionForward saveCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, true);
    }

    public ActionForward closeCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, false);
    }

    private ActionForward correspondenceAction(ActionMapping mapping, ActionForm form, boolean saveAction) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)actionHelper.getProtocolCorrespondence();
        if (saveAction) {
            if (correspondence.getFinalFlag()) {
                correspondence.setFinalFlagTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)correspondence);
        }
        if (GlobalVariables.getUserSession().retrieveObject("approvalComplpondence") != null) {
            GlobalVariables.getUserSession().addObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY", GlobalVariables.getUserSession().retrieveObject("approvalComplCorrespondence"));
            GlobalVariables.getUserSession().removeObject("approvalComplCorrespondence");
        }
        if (correspondence.getNotificationRequestBean() != null) {
            return this.checkToSendNotification(mapping, mapping.findForward(correspondence.getForwardName()), protocolForm, (ProtocolNotificationRequestBean)correspondence.getNotificationRequestBean());
        }
        if (correspondence.isHoldingPage()) {
            return this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return mapping.findForward(correspondence.getForwardName());
    }

    public ActionForward regenerateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence protocolCorrespondence = (ProtocolCorrespondence)protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        Protocol protocol = (Protocol)protocolCorrespondence.getProtocol();
        AttachmentDataSource dataSource = this.generateCorrespondenceDocument(protocol, protocolCorrespondence.getProtoCorrespTypeCode());
        PrintableAttachment source = new PrintableAttachment();
        if (dataSource != null) {
            protocolCorrespondence.setCorrespondence(dataSource.getContent());
            protocolCorrespondence.setFinalFlag(false);
            protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
            protocolCorrespondence.setCreateTimestamp(KraServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            protocolCorrespondence.setForwardName(PROTOCOL_ACTIONS_TAB);
            protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
            this.getBusinessObjectService().save((PersistableBusinessObject)protocolCorrespondence);
            return mapping.findForward(CORRESPONDENCE);
        }
        return mapping.findForward("basic");
    }

    protected AttachmentDataSource generateCorrespondenceDocument(Protocol protocol, String correspondenceType) throws PrintingException {
        AbstractProtocolActionsCorrespondence correspondence = null;
        if (StringUtils.equals((String)"16", (String)correspondenceType)) {
            correspondence = new WithdrawCorrespondence();
        } else if (GENERIC_TYPE_PONDENCE.contains(correspondenceType)) {
            correspondence = new ProtocolGenericCorrespondence(CORR_TYPE_TO_ACTION_TYPE_MAP.get(correspondenceType));
        } else if (StringUtils.equals((String)"17", (String)correspondenceType)) {
            correspondence = new GrantExemptionCorrespondence();
        }
        correspondence.setProtocol(protocol);
        return this.getProtocolActionCorrespondenceGenerationService().reGenerateCorrespondenceDocument(correspondence);
    }

    private ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return KraServiceLocator.getService(ProtocolActionCorrespondenceGenerationService.class);
    }

    public ActionForward updateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        protocolAction.refreshReferenceObject("protocolCorrespondences");
        ProtocolCorrespondence protocolCorrespondence = (ProtocolCorrespondence)protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info((Object)("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex));
            return mapping.findForward("basic");
        }
        protocolCorrespondence.setForwardName(PROTOCOL_ACTIONS_TAB);
        protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
        return mapping.findForward(CORRESPONDENCE);
    }

    static {
        ArrayList<String> correspondenceTypes = new ArrayList<String>();
        correspondenceTypes.add("28");
        correspondenceTypes.add("1");
        correspondenceTypes.add("26");
        correspondenceTypes.add("5");
        correspondenceTypes.add("3");
        correspondenceTypes.add("6");
        correspondenceTypes.add("4");
        correspondenceTypes.add("7");
        correspondenceTypes.add("8");
        GENERIC_TYPE_PONDENCE = correspondenceTypes;
        CORR_TYPE_TO_ACTION_TYPE_MAP = new HashMap<String, String>();
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("28", "119");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("1", "204");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("26", "300");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("5", "205");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("3", "201");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("6", "203");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("4", "202");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("7", "302");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("8", "301");
    }

    private class PrintableAttachment
    extends AttachmentDataSource {
        private byte[] streamData;

        private PrintableAttachment() {
        }

        @Override
        public byte[] getContent() {
            return this.streamData;
        }

        public void setContent(byte[] streamData) {
            this.streamData = streamData;
        }
    }
}

