/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.decision;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.IrbActionsKeyValuesBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class CommitteeMemberValuesFinder
extends IrbActionsKeyValuesBase {
    private static final long serialVersionUID = -7110160295510181062L;

    public List<KeyValue> getKeyValues() {
        ProtocolSubmission submission;
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        Protocol protocol = this.getProtocol();
        if (protocol != null && (submission = this.getCurrentSubmission(protocol)) != null) {
            String committeeId = submission.getCommitteeId();
            Committee committee = (Committee)this.getCommitteeService().getCommitteeById(committeeId);
            if (committee != null) {
                List<CommitteeMembershipBase> members = committee.getCommitteeMemberships();
                for (CommitteeMembershipBase member : members) {
                    if (!member.isActive() || !this.isReviewerAttendingMeeting((CommitteeMembership)member)) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue(member.getCommitteeMembershipId().toString(), member.getPersonName()));
                }
            }
        }
        return keyValues;
    }

    private ProtocolSubmission getCurrentSubmission(Protocol protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"101") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"100")) continue;
            return (ProtocolSubmission)submission;
        }
        return null;
    }

    private Protocol getProtocol() {
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null && form instanceof ProtocolForm) {
            return ((ProtocolForm)form).getProtocolDocument().getProtocol();
        }
        return null;
    }

    private boolean isReviewerAttendingMeeting(CommitteeMembership member) {
        Protocol prot = this.getProtocol();
        boolean retVal = false;
        if (prot != null) {
            List<CommitteeScheduleAttendanceBase> attendees = prot.getProtocolSubmission().getCommitteeSchedule().getCommitteeScheduleAttendances();
            for (CommitteeScheduleAttendanceBase attendee : attendees) {
                if (!attendee.isCommitteeMember(member)) continue;
                return true;
            }
        }
        return retVal;
    }
}

