/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.modifysubmission;

import java.util.HashMap;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionService;
import org.kuali.kra.irb.actions.proccessbillable.ProtocolProccessBillableService;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolModifySubmissionServiceImpl
extends ProtocolProccessBillableService
implements ProtocolModifySubmissionService {
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;

    @Override
    public void modifySubmisison(ProtocolDocument protocolDocument, ProtocolModifySubmissionBean bean) throws Exception {
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        submission.setSubmissionTypeCode(bean.getSubmissionTypeCode());
        submission.setSubmissionTypeQualifierCode(bean.getSubmissionQualifierTypeCode());
        this.proccessBillable(protocolDocument.getProtocol(), bean.isBillable());
        String existingReviewType = submission.getProtocolReviewTypeCode();
        String newReviewType = bean.getProtocolReviewTypeCode();
        if (existingReviewType.equals("3") || existingReviewType.equals("2")) {
            this.deleteExistingCheckBoxes(submission);
        }
        if (!existingReviewType.equals(newReviewType)) {
            this.proccessNewReviewType(submission, newReviewType);
        }
        if (newReviewType.equals("2")) {
            this.proccessExpeditedReviewCheckBoxes(submission, bean);
        } else if (newReviewType.equals("3")) {
            this.proccessExemptStudiesCheckBoxes(submission, bean);
        }
        this.documentService.saveDocument((Document)protocolDocument);
    }

    protected void deleteExistingCheckBoxes(ProtocolSubmission submission) {
        this.businessObjectService.delete(submission.getExemptStudiesCheckList());
        this.businessObjectService.delete(submission.getExpeditedReviewCheckList());
        submission.getExemptStudiesCheckList().clear();
        submission.getExpeditedReviewCheckList().clear();
    }

    protected void proccessNewReviewType(ProtocolSubmission submission, String newReviewType) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("PROTOCOL_REVIEW_TYPE_CODE", newReviewType);
        ProtocolReviewType newType = (ProtocolReviewType)this.businessObjectService.findByPrimaryKey(ProtocolReviewType.class, fieldValues);
        submission.setProtocolReviewType(newType);
        submission.setProtocolReviewTypeCode(newType.getReviewTypeCode());
    }

    protected void proccessExemptStudiesCheckBoxes(ProtocolSubmission submission, ProtocolModifySubmissionBean bean) {
        for (ExemptStudiesCheckListItem beanItem : bean.getExemptStudiesCheckList()) {
            if (!beanItem.getChecked()) continue;
            ProtocolExemptStudiesCheckListItem newItem = new ProtocolExemptStudiesCheckListItem();
            newItem.setExemptStudiesCheckListCode(beanItem.getExemptStudiesCheckListCode());
            newItem.setProtocol((Protocol)submission.getProtocol());
            newItem.setProtocolId(submission.getProtocolId());
            newItem.setProtocolNumber(submission.getProtocolNumber());
            newItem.setProtocolSubmission(submission);
            newItem.setSubmissionIdFk(submission.getSubmissionId());
            newItem.setSubmissionNumber(submission.getSubmissionNumber());
            newItem.setSequenceNumber(submission.getSequenceNumber());
            submission.getExemptStudiesCheckList().add(newItem);
        }
    }

    protected void proccessExpeditedReviewCheckBoxes(ProtocolSubmission submission, ProtocolModifySubmissionBean bean) {
        for (ExpeditedReviewCheckListItem beanItem : bean.getExpeditedReviewCheckList()) {
            if (!beanItem.getChecked()) continue;
            ProtocolExpeditedReviewCheckListItem newItem = new ProtocolExpeditedReviewCheckListItem();
            newItem.setExpeditedReviewCheckListCode(beanItem.getExpeditedReviewCheckListCode());
            newItem.setProtocol((Protocol)submission.getProtocol());
            newItem.setProtocolId(submission.getProtocolId());
            newItem.setProtocolNumber(submission.getProtocolNumber());
            newItem.setProtocolSubmission(submission);
            newItem.setSubmissionIdFk(submission.getSubmissionId());
            newItem.setSubmissionNumber(submission.getSubmissionNumber());
            newItem.setSequenceNumber(submission.getSequenceNumber());
            submission.getExpeditedReviewCheckList().add(newItem);
        }
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

